/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.analysis;

import com.antgroup.antchain.myjava.dependency.DependencyInfo;
import com.antgroup.antchain.myjava.dependency.MethodDependencyInfo;
import com.antgroup.antchain.myjava.model.MethodReference;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class ClassMetadataRequirements {
    private static final MethodReference GET_NAME_METHOD = new MethodReference(Class.class, "getName", String.class);
    private static final MethodReference GET_SIMPLE_NAME_METHOD = new MethodReference(Class.class, "getSimpleName", String.class);
    private static final MethodReference GET_DECLARING_CLASS_METHOD = new MethodReference(Class.class, "getDeclaringClass", Class.class);
    private static final MethodReference GET_ENCLOSING_CLASS_METHOD = new MethodReference(Class.class, "getEnclosingClass", Class.class);
    private static final ClassInfo EMPTY_INFO = new ClassInfo();
    private Map<String, ClassInfo> requirements = new HashMap<String, ClassInfo>();

    public ClassMetadataRequirements(DependencyInfo dependencyInfo) {
        MethodDependencyInfo getEnclosingClassMethod;
        MethodDependencyInfo getDeclaringClassMethod;
        MethodDependencyInfo getSimpleNameMethod;
        MethodDependencyInfo getNameMethod = dependencyInfo.getMethod(GET_NAME_METHOD);
        if (getNameMethod != null) {
            this.addClassesRequiringName(this.requirements, getNameMethod.getVariable(0).getClassValueNode().getTypes());
        }
        if ((getSimpleNameMethod = dependencyInfo.getMethod(GET_SIMPLE_NAME_METHOD)) != null) {
            String[] classNames = getSimpleNameMethod.getVariable(0).getClassValueNode().getTypes();
            this.addClassesRequiringName(this.requirements, classNames);
            for (String className : classNames) {
                ClassInfo classInfo = this.requirements.computeIfAbsent(className, k -> new ClassInfo());
                classInfo.simpleName = true;
                classInfo.enclosingClass = true;
            }
        }
        if ((getDeclaringClassMethod = dependencyInfo.getMethod(GET_DECLARING_CLASS_METHOD)) != null) {
            String[] classNames;
            for (String className : classNames = getDeclaringClassMethod.getVariable(0).getClassValueNode().getTypes()) {
                this.requirements.computeIfAbsent((String)className, (Function<String, ClassInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$1(java.lang.String ), (Ljava/lang/String;)Lcom/antgroup/antchain/myjava/model/analysis/ClassMetadataRequirements$ClassInfo;)()).declaringClass = true;
            }
        }
        if ((getEnclosingClassMethod = dependencyInfo.getMethod(GET_ENCLOSING_CLASS_METHOD)) != null) {
            String[] classNames;
            for (String className : classNames = getEnclosingClassMethod.getVariable(0).getClassValueNode().getTypes()) {
                this.requirements.computeIfAbsent((String)className, (Function<String, ClassInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$2(java.lang.String ), (Ljava/lang/String;)Lcom/antgroup/antchain/myjava/model/analysis/ClassMetadataRequirements$ClassInfo;)()).enclosingClass = true;
            }
        }
    }

    public Info getInfo(String className) {
        ClassInfo result = this.requirements.get(className);
        if (result == null) {
            result = EMPTY_INFO;
        }
        return result;
    }

    private void addClassesRequiringName(Map<String, ClassInfo> target, String[] source) {
        for (String typeName : source) {
            if (typeName.startsWith("[")) {
                if (!typeName.endsWith(";")) continue;
                int index = 0;
                while (typeName.charAt(index) == '[') {
                    ++index;
                }
                typeName = typeName.substring(index, typeName.length() - 1).replace('/', '.');
            }
            target.computeIfAbsent((String)typeName, (Function<String, ClassInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$addClassesRequiringName$3(java.lang.String ), (Ljava/lang/String;)Lcom/antgroup/antchain/myjava/model/analysis/ClassMetadataRequirements$ClassInfo;)()).name = true;
        }
    }

    private static /* synthetic */ ClassInfo lambda$addClassesRequiringName$3(String k) {
        return new ClassInfo();
    }

    private static /* synthetic */ ClassInfo lambda$new$2(String k) {
        return new ClassInfo();
    }

    private static /* synthetic */ ClassInfo lambda$new$1(String k) {
        return new ClassInfo();
    }

    public static interface Info {
        public boolean name();

        public boolean simpleName();

        public boolean declaringClass();

        public boolean enclosingClass();
    }

    static class ClassInfo
    implements Info {
        boolean name;
        boolean simpleName;
        boolean declaringClass;
        boolean enclosingClass;

        ClassInfo() {
        }

        @Override
        public boolean name() {
            return this.name;
        }

        @Override
        public boolean simpleName() {
            return this.simpleName;
        }

        @Override
        public boolean declaringClass() {
            return this.declaringClass;
        }

        @Override
        public boolean enclosingClass() {
            return this.enclosingClass;
        }
    }
}

