/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.analysis;

import com.antgroup.antchain.myjava.common.Graph;
import com.antgroup.antchain.myjava.common.GraphBuilder;
import com.antgroup.antchain.myjava.common.GraphUtils;
import com.antgroup.antchain.myjava.common.IntegerArray;
import com.antgroup.antchain.myjava.dependency.DependencyInfo;
import com.antgroup.antchain.myjava.dependency.FieldDependencyInfo;
import com.antgroup.antchain.myjava.dependency.MethodDependencyInfo;
import com.antgroup.antchain.myjava.dependency.ValueDependencyInfo;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.ClassHierarchy;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.Incoming;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Phi;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.TryCatchBlock;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.analysis.SubclassListProvider;
import com.antgroup.antchain.myjava.model.instructions.AbstractInstructionVisitor;
import com.antgroup.antchain.myjava.model.instructions.AssignInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastInstruction;
import com.antgroup.antchain.myjava.model.instructions.ClassConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.CloneArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructMultiArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ExitInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetElementInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvocationType;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutElementInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.RaiseInstruction;
import com.antgroup.antchain.myjava.model.instructions.StringConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.UnwrapArrayInstruction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.teavm.hppc.IntHashSet;
import org.teavm.hppc.IntSet;
import org.teavm.hppc.IntStack;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;
import org.teavm.hppc.cursors.IntCursor;

public class ClassInference {
    private DependencyInfo dependencyInfo;
    private ClassHierarchy hierarchy;
    private SubclassListProvider subclassListProvider;
    private Graph assignmentGraph;
    private Graph arrayDataAssignmentGraph;
    private Graph cloneGraph;
    private Graph arrayGraph;
    private Graph itemGraph;
    private Graph graph;
    private ValueCast[] casts;
    private int[] exceptions;
    private VirtualCallSite[] virtualCallSites;
    private int overflowLimit;
    private int[] propagationPath;
    private int[] nodeMapping;
    private IntHashSet[] types;
    private boolean[] overflowTypes;
    private ObjectIntMap<String> typeMap = new ObjectIntHashMap<String>();
    private List<String> typeList = new ArrayList<String>();
    private boolean changed = true;
    private boolean[] nodeChanged;
    private boolean[] formerNodeChanged;
    private static final int MAX_DEGREE = 3;
    private static final byte FRESH = 0;
    private static final byte VISITING = 1;
    private static final byte VISITED = 2;

    public ClassInference(DependencyInfo dependencyInfo, ClassHierarchy hierarchy, Iterable<? extends String> classNames, int overflowLimit) {
        this.dependencyInfo = dependencyInfo;
        this.hierarchy = hierarchy;
        this.overflowLimit = overflowLimit;
        this.subclassListProvider = new SubclassListProvider(dependencyInfo.getClassSource(), classNames, overflowLimit);
    }

    public void infer(Program program, MethodReference methodReference) {
        this.types = new IntHashSet[program.variableCount() << 3];
        this.overflowTypes = new boolean[program.variableCount() << 3];
        this.nodeChanged = new boolean[this.types.length];
        this.formerNodeChanged = new boolean[this.nodeChanged.length];
        this.nodeMapping = new int[this.types.length];
        for (int i = 0; i < this.types.length; ++i) {
            this.nodeMapping[i] = i;
        }
        MethodDependencyInfo thisMethodDep = this.dependencyInfo.getMethod(methodReference);
        this.buildPreliminaryGraphs(program, thisMethodDep);
        block1: for (int i = 0; i <= methodReference.parameterCount(); ++i) {
            ValueDependencyInfo paramDep = thisMethodDep.getVariable(i);
            if (paramDep == null) continue;
            for (int degree = 0; degree <= 3; ++degree) {
                this.addTypesFrom(i, degree, paramDep);
                if (!paramDep.hasArrayType()) continue block1;
                paramDep = paramDep.getArrayItem();
            }
        }
        this.buildPropagationGraph();
        this.collapseSCCs();
        this.buildPropagationPath();
        this.propagate(program);
        this.assignmentGraph = null;
        this.graph = null;
        this.cloneGraph = null;
        this.arrayGraph = null;
        this.itemGraph = null;
        this.casts = null;
        this.exceptions = null;
        this.virtualCallSites = null;
        this.propagationPath = null;
        this.nodeChanged = null;
    }

    public boolean isOverflow(int variableIndex) {
        return this.overflowTypes[this.nodeMapping[ClassInference.packNodeAndDegree(variableIndex, 0)]];
    }

    public List<? extends MethodReference> getMethodImplementations(MethodDescriptor descriptor) {
        return this.subclassListProvider.getMethods(descriptor);
    }

    public String[] classesOf(int variableIndex) {
        IntHashSet typeSet = this.types[this.nodeMapping[ClassInference.packNodeAndDegree(variableIndex, 0)]];
        if (typeSet == null) {
            return new String[0];
        }
        int[] typeIndexes = typeSet.toArray();
        String[] types = new String[typeIndexes.length];
        for (int i = 0; i < typeIndexes.length; ++i) {
            types[i] = this.typeList.get(typeIndexes[i]);
        }
        return types;
    }

    private void buildPreliminaryGraphs(Program program, MethodDependencyInfo thisMethodDep) {
        GraphBuildingVisitor visitor = new GraphBuildingVisitor(program.variableCount(), this.dependencyInfo);
        visitor.thisMethodDep = thisMethodDep;
        Iterator<BasicBlock> iterator = program.getBasicBlocks().iterator();
        while (iterator.hasNext()) {
            BasicBlock block;
            visitor.currentBlock = block = iterator.next();
            for (Phi phi : block.getPhis()) {
                visitor.visit(phi);
            }
            for (Instruction insn : block) {
                insn.acceptVisitor(visitor);
            }
            if (block.getExceptionVariable() == null) continue;
            this.getNodeTypes(ClassInference.packNodeAndDegree(block.getExceptionVariable().getIndex(), 0));
        }
        this.assignmentGraph = visitor.assignmentGraphBuilder.build();
        this.cloneGraph = visitor.cloneGraphBuilder.build();
        this.arrayGraph = visitor.arrayGraphBuilder.build();
        this.itemGraph = visitor.itemGraphBuilder.build();
        this.casts = visitor.casts.toArray(new ValueCast[0]);
        this.exceptions = visitor.exceptions.getAll();
        this.virtualCallSites = visitor.virtualCallSites.toArray(new VirtualCallSite[0]);
        GraphBuilder arrayAssignmentGraphBuilder = new GraphBuilder(this.assignmentGraph.size());
        for (int i = 0; i < this.assignmentGraph.size(); ++i) {
            for (Object j : (Object)this.assignmentGraph.outgoingEdges(i)) {
                arrayAssignmentGraphBuilder.addEdge(i, (int)j);
            }
        }
        for (ValueCast cast : this.casts) {
            arrayAssignmentGraphBuilder.addEdge(cast.fromVariable, cast.toVariable);
        }
        this.arrayDataAssignmentGraph = arrayAssignmentGraphBuilder.build();
    }

    private void buildPropagationGraph() {
        IntStack stack = new IntStack();
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] == null && !this.overflowTypes[i]) continue;
            stack.push(i);
        }
        boolean[] visited = new boolean[this.types.length];
        GraphBuilder graphBuilder = new GraphBuilder(this.types.length);
        while (!stack.isEmpty()) {
            int predecessorEntry;
            int entry = stack.pop();
            if (visited[entry]) continue;
            visited[entry] = true;
            int degree = ClassInference.extractDegree(entry);
            int variable = ClassInference.extractNode(entry);
            IntHashSet nextEntries = new IntHashSet();
            for (int n : this.assignmentGraph.outgoingEdges(variable)) {
                nextEntries.add(ClassInference.packNodeAndDegree(n, degree));
            }
            for (int n : this.cloneGraph.outgoingEdges(variable)) {
                nextEntries.add(ClassInference.packNodeAndDegree(n, degree));
            }
            if (degree > 0) {
                for (int n : this.arrayDataAssignmentGraph.incomingEdges(variable)) {
                    predecessorEntry = ClassInference.packNodeAndDegree(n, degree);
                    graphBuilder.addEdge(predecessorEntry, entry);
                    graphBuilder.addEdge(entry, predecessorEntry);
                    if (visited[predecessorEntry]) continue;
                    stack.push(predecessorEntry);
                }
                for (int n : this.itemGraph.outgoingEdges(variable)) {
                    nextEntries.add(ClassInference.packNodeAndDegree(n, degree - 1));
                }
                for (int n : this.arrayGraph.incomingEdges(variable)) {
                    predecessorEntry = ClassInference.packNodeAndDegree(n, degree - 1);
                    graphBuilder.addEdge(predecessorEntry, entry);
                    if (visited[predecessorEntry]) continue;
                    stack.push(predecessorEntry);
                }
                for (int n : this.arrayDataAssignmentGraph.outgoingEdges(variable)) {
                    int successorEntry = ClassInference.packNodeAndDegree(n, degree);
                    graphBuilder.addEdge(successorEntry, entry);
                    graphBuilder.addEdge(entry, successorEntry);
                    if (visited[successorEntry]) continue;
                    stack.push(successorEntry);
                }
            }
            if (degree <= 3) {
                for (int n : this.arrayGraph.outgoingEdges(variable)) {
                    nextEntries.add(ClassInference.packNodeAndDegree(n, degree + 1));
                }
                for (int n : this.itemGraph.incomingEdges(variable)) {
                    predecessorEntry = ClassInference.packNodeAndDegree(n, degree + 1);
                    graphBuilder.addEdge(predecessorEntry, entry);
                    if (visited[predecessorEntry]) continue;
                    stack.push(predecessorEntry);
                }
            }
            for (IntCursor next : nextEntries) {
                graphBuilder.addEdge(entry, next.value);
                if (visited[next.value]) continue;
                stack.push(next.value);
            }
        }
        this.graph = graphBuilder.build();
    }

    private void collapseSCCs() {
        int i;
        int[][] sccs = GraphUtils.findStronglyConnectedComponents(this.graph);
        if (sccs.length == 0) {
            return;
        }
        for (int[] scc : sccs) {
            for (i = 1; i < scc.length; ++i) {
                this.nodeMapping[scc[i]] = scc[0];
            }
        }
        boolean[] nodeChangedBackup = (boolean[])this.nodeChanged.clone();
        IntHashSet[] typesBackup = (IntHashSet[])this.types.clone();
        boolean[] overflowTypesBackup = (boolean[])this.overflowTypes.clone();
        Arrays.fill(this.nodeChanged, false);
        Arrays.fill(this.types, null);
        Arrays.fill(this.overflowTypes, false);
        GraphBuilder graphBuilder = new GraphBuilder(this.graph.size());
        for (i = 0; i < this.graph.size(); ++i) {
            IntHashSet nodeTypes;
            int[] nArray = this.graph.outgoingEdges(i);
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                int from = this.nodeMapping[i];
                int j2 = nArray[j];
                int to = this.nodeMapping[j2];
                if (from == to) continue;
                graphBuilder.addEdge(from, to);
            }
            int node = this.nodeMapping[i];
            if (overflowTypesBackup[i]) {
                this.overflowTypes[node] = true;
                this.types[node] = null;
            } else if (typesBackup[i] != null && !this.overflowTypes[i] && (nodeTypes = this.getNodeTypes(node)).addAll(typesBackup[i]) > 0 && nodeTypes.size() > this.overflowLimit) {
                this.types[node] = null;
                this.overflowTypes[node] = true;
            }
            if (!nodeChangedBackup[i]) continue;
            this.nodeChanged[node] = true;
        }
        this.graph = graphBuilder.build();
    }

    private void buildPropagationPath() {
        byte[] state = new byte[this.types.length];
        int[] path = new int[this.types.length];
        int pathSize = 0;
        IntStack stack = new IntStack();
        for (int i = 0; i < this.graph.size(); ++i) {
            if (this.graph.incomingEdgesCount(i) != 0 || !this.overflowTypes[i] && this.types[i] == null) continue;
            stack.push(i);
        }
        while (!stack.isEmpty()) {
            int node = stack.pop();
            if (state[node] == 0) {
                state[node] = 1;
                stack.push(node);
                for (int successor : this.graph.outgoingEdges(node)) {
                    if (state[successor] != 0) continue;
                    stack.push(successor);
                }
                continue;
            }
            if (state[node] != 1) continue;
            path[pathSize++] = node;
            state[node] = 2;
        }
        this.propagationPath = Arrays.copyOf(path, pathSize);
    }

    private void propagate(Program program) {
        boolean outerChanged;
        this.changed = false;
        do {
            System.arraycopy(this.nodeChanged, 0, this.formerNodeChanged, 0, this.nodeChanged.length);
            Arrays.fill(this.nodeChanged, false);
            this.propagateAlongDAG();
            outerChanged = this.changed;
            do {
                this.changed = false;
                this.propagateAlongCasts();
                this.propagateAlongVirtualCalls(program);
                this.propagateAlongExceptions(program);
                if (!this.changed) continue;
                outerChanged = true;
            } while (this.changed);
        } while (outerChanged);
    }

    private void propagateAlongDAG() {
        block0: for (int i = this.propagationPath.length - 1; i >= 0; --i) {
            int node = this.propagationPath[i];
            if (this.overflowTypes[node]) continue;
            boolean predecessorsChanged = false;
            for (int predecessor : this.graph.incomingEdges(node)) {
                if (!this.formerNodeChanged[predecessor] && !this.nodeChanged[predecessor]) continue;
                predecessorsChanged = true;
                break;
            }
            if (!predecessorsChanged) continue;
            IntHashSet nodeTypes = this.getNodeTypes(node);
            for (int predecessor : this.graph.incomingEdges(node)) {
                if (!this.formerNodeChanged[predecessor] && !this.nodeChanged[predecessor]) continue;
                if (this.overflowTypes[predecessor]) {
                    if (this.overflowTypes[node]) continue;
                    this.overflowTypes[node] = true;
                    this.types[node] = null;
                    this.changed = true;
                    this.nodeChanged[node] = true;
                    continue block0;
                }
                if (this.types[predecessor] == null || nodeTypes.addAll(this.types[predecessor]) <= 0) continue;
                if (nodeTypes.size() > this.overflowLimit) {
                    this.types[node] = null;
                    this.overflowTypes[node] = true;
                    this.nodeChanged[node] = true;
                    this.changed = true;
                    continue block0;
                }
                this.nodeChanged[node] = true;
                this.changed = true;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void propagateAlongCasts() {
        block0: for (ValueCast cast : this.casts) {
            int fromNode;
            int toNode = this.nodeMapping[ClassInference.packNodeAndDegree(cast.toVariable, 0)];
            if (this.overflowTypes[toNode] || !this.formerNodeChanged[fromNode = this.nodeMapping[ClassInference.packNodeAndDegree(cast.fromVariable, 0)]] && !this.nodeChanged[fromNode]) continue;
            IntHashSet targetTypes = this.getNodeTypes(toNode);
            if (this.overflowTypes[fromNode]) {
                int degree = 0;
                ValueType targetType = cast.targetType;
                while (targetType instanceof ValueType.Array) {
                    targetType = ((ValueType.Array)targetType).getItemType();
                    ++degree;
                }
                if (targetType instanceof ValueType.Object) {
                    String targetClassName = ((ValueType.Object)targetType).getClassName();
                    List<? extends String> subclasses = this.subclassListProvider.getSubclasses(targetClassName, degree > 0);
                    if (subclasses == null) {
                        this.types[toNode] = null;
                        this.overflowTypes[toNode] = true;
                        this.nodeChanged[toNode] = true;
                        this.changed = true;
                        continue;
                    }
                    for (String string : subclasses) {
                        void var13_15;
                        int typeId;
                        if (degree > 0) {
                            StringBuilder sb = new StringBuilder();
                            for (int i = 0; i < degree; ++i) {
                                sb.append('[');
                            }
                            String string2 = sb.append('L').append(string.replace('.', '/')).append(';').toString();
                        }
                        if (!targetTypes.add(typeId = this.getTypeByName((String)var13_15))) continue;
                        this.changed = true;
                        this.nodeChanged[toNode] = true;
                        if (targetTypes.size() <= this.overflowLimit) continue;
                        this.overflowTypes[toNode] = true;
                        this.types[toNode] = null;
                        continue block0;
                    }
                    continue;
                }
                int typeId = this.getTypeByName(targetType.toString());
                if (!targetTypes.add(typeId)) continue;
                this.changed = true;
                this.nodeChanged[toNode] = true;
                if (targetTypes.size() <= this.overflowLimit) continue;
                this.overflowTypes[toNode] = true;
                this.types[toNode] = null;
                continue;
            }
            for (IntCursor cursor : this.types[fromNode]) {
                ValueType type;
                if (targetTypes.contains(cursor.value)) continue;
                String className = this.typeList.get(cursor.value);
                if (className.startsWith("[")) {
                    type = ValueType.parseIfPossible(className);
                    if (type == null) {
                        type = ValueType.arrayOf(ValueType.object("java.lang.Object"));
                    }
                } else {
                    type = ValueType.object(className);
                }
                if (!this.hierarchy.isSuperType(cast.targetType, type, false) || !targetTypes.add(cursor.value)) continue;
                this.changed = true;
                this.nodeChanged[toNode] = true;
                if (targetTypes.size() <= this.overflowLimit) continue;
                this.overflowTypes[toNode] = true;
                this.types[toNode] = null;
                continue block0;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void propagateAlongVirtualCalls(Program program) {
        ClassReaderSource classSource = this.dependencyInfo.getClassSource();
        VirtualCallSite[] virtualCallSiteArray = this.virtualCallSites;
        int n = virtualCallSiteArray.length;
        int n2 = 0;
        while (true) {
            block6: {
                List<? extends String> receiverTypes;
                VirtualCallSite callSite;
                block9: {
                    int instanceNode;
                    block7: {
                        block8: {
                            if (n2 >= n) {
                                return;
                            }
                            callSite = virtualCallSiteArray[n2];
                            if (callSite.receiverOverflow || !this.formerNodeChanged[instanceNode = this.nodeMapping[ClassInference.packNodeAndDegree(callSite.instance, 0)]] && !this.nodeChanged[instanceNode]) break block6;
                            if (!this.overflowTypes[instanceNode]) break block7;
                            callSite.receiverOverflow = true;
                            List<? extends String> subclasses = this.subclassListProvider.getSubclasses(callSite.method.getClassName(), true);
                            if (subclasses == null) break block8;
                            receiverTypes = subclasses;
                            break block9;
                        }
                        List<? extends MethodReference> list = this.subclassListProvider.getMethods(callSite.method.getDescriptor());
                        if (list != null) {
                            for (MethodReference methodReference : list) {
                                this.mountVirtualMethod(program, callSite, methodReference);
                            }
                        }
                        break block6;
                    }
                    ArrayList<? extends String> instanceNodeTypes = new ArrayList<String>();
                    for (IntCursor type : this.types[instanceNode]) {
                        if (callSite.knownClasses.contains(type.value)) continue;
                        instanceNodeTypes.add(this.typeList.get(type.value));
                    }
                    receiverTypes = instanceNodeTypes;
                }
                for (String string : receiverTypes) {
                    MethodReference methodReference;
                    MethodReader resolvedMethod;
                    int typeId = this.getTypeByName(string);
                    if (!callSite.knownClasses.add(typeId) || (resolvedMethod = classSource.resolveImplementation(methodReference = new MethodReference(string, callSite.method.getDescriptor()))) == null) continue;
                    MethodReference resolvedMethodRef = resolvedMethod.getReference();
                    this.mountVirtualMethod(program, callSite, resolvedMethodRef);
                }
            }
            ++n2;
        }
    }

    private void mountVirtualMethod(Program program, VirtualCallSite callSite, MethodReference methodReference) {
        if (!callSite.resolvedMethods.add(methodReference)) {
            return;
        }
        MethodDependencyInfo methodDep = this.dependencyInfo.getMethod(methodReference);
        if (methodDep == null) {
            return;
        }
        if (callSite.receiver >= 0) {
            this.readValue(methodDep.getResult(), program.variableAt(callSite.receiver));
        }
        for (int i = 0; i < callSite.arguments.length; ++i) {
            this.writeValue(methodDep.getVariable(i + 1), program.variableAt(callSite.arguments[i]));
        }
        for (String thrownTypeName : methodDep.getThrown().getTypes()) {
            this.propagateException(thrownTypeName, program.basicBlockAt(callSite.block));
        }
    }

    private void propagateAlongExceptions(Program program) {
        for (int i = 0; i < this.exceptions.length; i += 2) {
            int variable = this.nodeMapping[ClassInference.packNodeAndDegree(this.exceptions[i], 0)];
            if (!this.formerNodeChanged[variable] && !this.nodeChanged[variable]) continue;
            BasicBlock block = program.basicBlockAt(this.exceptions[i + 1]);
            if (this.overflowTypes[variable]) {
                this.propagateOverflowException(block);
                continue;
            }
            for (IntCursor type : this.types[variable]) {
                String typeName = this.typeList.get(type.value);
                this.propagateException(typeName, block);
            }
        }
    }

    private void propagateException(String thrownTypeName, BasicBlock block) {
        for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
            String expectedType = tryCatch.getExceptionType();
            if (expectedType != null && !this.hierarchy.isSuperType(expectedType, thrownTypeName, false)) continue;
            if (tryCatch.getHandler().getExceptionVariable() == null) break;
            int exceptionNode = ClassInference.packNodeAndDegree(tryCatch.getHandler().getExceptionVariable().getIndex(), 0);
            if (this.overflowTypes[exceptionNode = this.nodeMapping[exceptionNode]]) break;
            int thrownType = this.getTypeByName(thrownTypeName);
            IntHashSet nodeTypes = this.getNodeTypes(exceptionNode);
            if (!nodeTypes.add(thrownType)) break;
            this.nodeChanged[exceptionNode] = true;
            this.changed = true;
            if (nodeTypes.size() <= this.overflowLimit) break;
            this.types[exceptionNode] = null;
            this.overflowTypes[exceptionNode] = true;
            break;
        }
    }

    private void propagateOverflowException(BasicBlock block) {
        block0: for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
            String expectedType;
            List<? extends String> thrownTypes;
            Variable exceptionVar = tryCatch.getHandler().getExceptionVariable();
            if (exceptionVar == null) continue;
            int exceptionNode = ClassInference.packNodeAndDegree(exceptionVar.getIndex(), 0);
            if (this.overflowTypes[exceptionNode = this.nodeMapping[exceptionNode]] || (thrownTypes = this.subclassListProvider.getSubclasses(expectedType = tryCatch.getExceptionType(), false)) == null) continue;
            IntHashSet nodeTypes = this.getNodeTypes(exceptionNode);
            for (String string : thrownTypes) {
                int thrownType = this.getTypeByName(string);
                if (!nodeTypes.add(thrownType)) continue;
                this.nodeChanged[exceptionNode] = true;
                this.changed = true;
                if (nodeTypes.size() <= this.overflowLimit) continue;
                this.types[exceptionNode] = null;
                this.overflowTypes[exceptionNode] = true;
                continue block0;
            }
        }
    }

    IntHashSet getNodeTypes(int node) {
        IntHashSet result = this.types[node];
        if (result == null) {
            this.types[node] = result = new IntHashSet();
        }
        return result;
    }

    int getTypeByName(String typeName) {
        int type = this.typeMap.getOrDefault(typeName, -1);
        if (type < 0) {
            type = this.typeList.size();
            this.typeMap.put(typeName, type);
            this.typeList.add(typeName);
        }
        return type;
    }

    void readValue(ValueDependencyInfo valueDep, Variable receiver) {
        boolean hasArrayType;
        int depth = 0;
        do {
            this.addTypesFrom(receiver.getIndex(), depth, valueDep);
            hasArrayType = valueDep.hasArrayType();
            valueDep = valueDep.getArrayItem();
        } while (hasArrayType && ++depth <= 3);
    }

    void writeValue(ValueDependencyInfo valueDep, Variable source) {
        int depth = 0;
        while (valueDep.hasArrayType() && depth < 3) {
            valueDep = valueDep.getArrayItem();
            this.addTypesFrom(source.getIndex(), ++depth, valueDep);
        }
    }

    boolean addType(int variable, int degree, String typeName) {
        return this.addTypeImpl(ClassInference.packNodeAndDegree(variable, degree), this.getTypeByName(typeName));
    }

    boolean addTypeImpl(int node, int typeId) {
        if (this.overflowTypes[node]) {
            return true;
        }
        IntHashSet nodeTypes = this.getNodeTypes(node);
        if (nodeTypes.add(typeId)) {
            this.nodeChanged[node] = true;
            this.changed = true;
            if (nodeTypes.size() > this.overflowLimit) {
                this.types[node] = null;
                this.overflowTypes[node] = true;
                return true;
            }
        }
        return false;
    }

    void addTypesFrom(int variable, int degree, ValueDependencyInfo dep) {
        if (this.overflowTypes[ClassInference.packNodeAndDegree(variable, degree)]) {
            return;
        }
        if (dep.hasMoreTypesThan(this.overflowLimit)) {
            this.overflowType(variable, degree);
        } else {
            String[] types;
            for (String type : types = dep.getTypes()) {
                if (this.addType(variable, degree, type)) break;
            }
        }
    }

    void overflowType(int variable, int degree) {
        int entry = this.nodeMapping[ClassInference.packNodeAndDegree(variable, degree)];
        if (this.overflowTypes[entry]) {
            return;
        }
        this.overflowTypes[entry] = true;
        this.nodeChanged[entry] = true;
        this.changed = true;
    }

    static int extractNode(int nodeAndDegree) {
        return nodeAndDegree >>> 3;
    }

    static int extractDegree(int nodeAndDegree) {
        return nodeAndDegree & 7;
    }

    static int packNodeAndDegree(int node, int degree) {
        return node << 3 | degree;
    }

    static final class ValueCast {
        final int fromVariable;
        final int toVariable;
        final ValueType targetType;

        ValueCast(int fromVariable, int toVariable, ValueType targetType) {
            this.fromVariable = fromVariable;
            this.toVariable = toVariable;
            this.targetType = targetType;
        }
    }

    static class VirtualCallSite {
        int instance;
        boolean receiverOverflow;
        IntSet knownClasses = new IntHashSet();
        Set<MethodReference> resolvedMethods = new HashSet<MethodReference>();
        MethodReference method;
        int[] arguments;
        int receiver;
        int block;

        VirtualCallSite() {
        }
    }

    class GraphBuildingVisitor
    extends AbstractInstructionVisitor {
        DependencyInfo dependencyInfo;
        GraphBuilder assignmentGraphBuilder;
        GraphBuilder cloneGraphBuilder;
        GraphBuilder arrayGraphBuilder;
        GraphBuilder itemGraphBuilder;
        MethodDependencyInfo thisMethodDep;
        List<ValueCast> casts = new ArrayList<ValueCast>();
        IntegerArray exceptions = new IntegerArray(2);
        List<VirtualCallSite> virtualCallSites = new ArrayList<VirtualCallSite>();
        BasicBlock currentBlock;

        GraphBuildingVisitor(int variableCount, DependencyInfo dependencyInfo) {
            this.dependencyInfo = dependencyInfo;
            this.assignmentGraphBuilder = new GraphBuilder(variableCount);
            this.cloneGraphBuilder = new GraphBuilder(variableCount);
            this.arrayGraphBuilder = new GraphBuilder(variableCount);
            this.itemGraphBuilder = new GraphBuilder(variableCount);
        }

        public void visit(Phi phi) {
            for (Incoming incoming : phi.getIncomings()) {
                this.assignmentGraphBuilder.addEdge(incoming.getValue().getIndex(), phi.getReceiver().getIndex());
            }
        }

        @Override
        public void visit(ClassConstantInstruction insn) {
            ClassInference.this.addType(insn.getReceiver().getIndex(), 0, "java.lang.Class");
        }

        @Override
        public void visit(StringConstantInstruction insn) {
            ClassInference.this.addType(insn.getReceiver().getIndex(), 0, "java.lang.String");
        }

        @Override
        public void visit(AssignInstruction insn) {
            this.assignmentGraphBuilder.addEdge(insn.getAssignee().getIndex(), insn.getReceiver().getIndex());
        }

        @Override
        public void visit(CastInstruction insn) {
            this.casts.add(new ValueCast(insn.getValue().getIndex(), insn.getReceiver().getIndex(), insn.getTargetType()));
            ClassInference.this.getNodeTypes(ClassInference.packNodeAndDegree(insn.getReceiver().getIndex(), 0));
        }

        @Override
        public void visit(RaiseInstruction insn) {
            this.exceptions.add(insn.getException().getIndex());
            this.exceptions.add(this.currentBlock.getIndex());
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
            ClassInference.this.addType(insn.getReceiver().getIndex(), 0, ValueType.arrayOf(insn.getItemType()).toString());
        }

        @Override
        public void visit(ConstructInstruction insn) {
            ClassInference.this.addType(insn.getReceiver().getIndex(), 0, insn.getType());
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
            ValueType type = insn.getItemType();
            for (int i = 0; i < insn.getDimensions().size(); ++i) {
                type = ValueType.arrayOf(type);
            }
            ClassInference.this.addType(insn.getReceiver().getIndex(), 0, type.toString());
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            FieldDependencyInfo fieldDep = this.dependencyInfo.getField(insn.getField());
            ValueDependencyInfo valueDep = fieldDep.getValue();
            ClassInference.this.readValue(valueDep, insn.getReceiver());
        }

        @Override
        public void visit(PutFieldInstruction insn) {
            FieldDependencyInfo fieldDep = this.dependencyInfo.getField(insn.getField());
            ValueDependencyInfo valueDep = fieldDep.getValue();
            ClassInference.this.writeValue(valueDep, insn.getValue());
        }

        @Override
        public void visit(CloneArrayInstruction insn) {
            this.cloneGraphBuilder.addEdge(insn.getArray().getIndex(), insn.getReceiver().getIndex());
        }

        @Override
        public void visit(UnwrapArrayInstruction insn) {
            this.assignmentGraphBuilder.addEdge(insn.getArray().getIndex(), insn.getReceiver().getIndex());
        }

        @Override
        public void visit(GetElementInstruction insn) {
            this.itemGraphBuilder.addEdge(insn.getArray().getIndex(), insn.getReceiver().getIndex());
        }

        @Override
        public void visit(PutElementInstruction insn) {
            this.arrayGraphBuilder.addEdge(insn.getValue().getIndex(), insn.getArray().getIndex());
        }

        @Override
        public void visit(ExitInstruction insn) {
            if (insn.getValueToReturn() != null) {
                ValueDependencyInfo resultDependency = this.thisMethodDep.getResult();
                for (int resultDegree = 0; resultDependency.hasArrayType() && resultDegree <= 3; ++resultDegree) {
                    resultDependency = resultDependency.getArrayItem();
                    ClassInference.this.addTypesFrom(insn.getValueToReturn().getIndex(), resultDegree, resultDependency);
                }
            }
        }

        @Override
        public void visit(InvokeInstruction insn) {
            if (insn.getType() == InvocationType.VIRTUAL) {
                int instance = insn.getInstance().getIndex();
                VirtualCallSite callSite = new VirtualCallSite();
                callSite.instance = instance;
                callSite.method = insn.getMethod();
                callSite.arguments = new int[insn.getArguments().size()];
                for (int i = 0; i < insn.getArguments().size(); ++i) {
                    callSite.arguments[i] = insn.getArguments().get(i).getIndex();
                    for (int j = 0; j <= 3; ++j) {
                        ClassInference.this.getNodeTypes(ClassInference.packNodeAndDegree(callSite.arguments[i], j));
                    }
                }
                callSite.receiver = insn.getReceiver() != null ? insn.getReceiver().getIndex() : -1;
                callSite.block = this.currentBlock.getIndex();
                this.virtualCallSites.add(callSite);
                if (insn.getReceiver() != null) {
                    for (int j = 0; j <= 3; ++j) {
                        ClassInference.this.getNodeTypes(ClassInference.packNodeAndDegree(callSite.receiver, j));
                    }
                }
                return;
            }
            MethodDependencyInfo methodDep = this.dependencyInfo.getMethod(insn.getMethod());
            if (methodDep != null) {
                if (insn.getReceiver() != null) {
                    ClassInference.this.readValue(methodDep.getResult(), insn.getReceiver());
                }
                for (int i = 0; i < insn.getArguments().size(); ++i) {
                    ClassInference.this.writeValue(methodDep.getVariable(i + 1), insn.getArguments().get(i));
                }
                for (String type : methodDep.getThrown().getTypes()) {
                    ClassInference.this.propagateException(type, this.currentBlock);
                }
            }
        }
    }
}

