/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model;

import com.antgroup.antchain.myjava.model.AnnotationContainer;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.ProgramReader;
import com.antgroup.antchain.myjava.model.Variable;
import java.util.ArrayList;
import java.util.List;

public class Program
implements ProgramReader {
    private List<BasicBlock> basicBlocks = new ArrayList<BasicBlock>(2);
    private List<Variable> variables = new ArrayList<Variable>();
    private boolean packed;
    private int lastUsedRegister;
    private AnnotationContainer annotations = new AnnotationContainer();

    public BasicBlock createBasicBlock() {
        BasicBlock block = new BasicBlock(this, this.basicBlocks.size());
        this.basicBlocks.add(block);
        return block;
    }

    public Variable createVariable() {
        Variable variable = new Variable(this);
        variable.setIndex(this.variables.size());
        this.variables.add(variable);
        variable.setRegister(this.lastUsedRegister++);
        return variable;
    }

    public void deleteBasicBlock(int index) {
        BasicBlock basicBlock = this.basicBlocks.get(index);
        if (basicBlock == null) {
            return;
        }
        this.basicBlocks.set(index, null);
        basicBlock.setIndex(-1);
        basicBlock.clearProgram();
        this.packed = false;
    }

    @Override
    public int basicBlockCount() {
        return this.basicBlocks.size();
    }

    @Override
    public BasicBlock basicBlockAt(int index) {
        return this.basicBlocks.get(index);
    }

    public Iterable<BasicBlock> getBasicBlocks() {
        return this.basicBlocks;
    }

    public void rearrangeBasicBlocks(List<BasicBlock> basicBlocks) {
        if (!this.isPacked()) {
            throw new IllegalStateException("This operation is not supported on unpacked programs");
        }
        if (basicBlocks.size() != this.basicBlocks.size()) {
            throw new IllegalArgumentException("New list of basic blocks has wrong size (" + basicBlocks.size() + ", expected " + this.basicBlockCount() + ")");
        }
        boolean[] indexes = new boolean[basicBlocks.size()];
        for (BasicBlock block : basicBlocks) {
            if (block.getProgram() != this) {
                throw new IllegalArgumentException("The list of basic blocks contains a basic block from another program");
            }
            if (indexes[block.getIndex()]) {
                throw new IllegalArgumentException("The list of basic blocks contains same basic block twice");
            }
            indexes[block.getIndex()] = true;
        }
        this.basicBlocks.clear();
        this.basicBlocks.addAll(basicBlocks);
        for (int i = 0; i < this.basicBlocks.size(); ++i) {
            this.basicBlocks.get(i).setIndex(i);
        }
    }

    public void deleteVariable(int index) {
        Variable variable = this.variables.get(index);
        if (variable == null) {
            return;
        }
        this.variables.set(index, null);
        variable.setIndex(-1);
        variable.setProgram(null);
        this.packed = false;
    }

    public boolean isPacked() {
        return this.packed;
    }

    public void pack() {
        int i;
        if (this.packed) {
            return;
        }
        int sz = 0;
        for (i = 0; i < this.basicBlocks.size(); ++i) {
            BasicBlock block = this.basicBlocks.get(i);
            if (block == null) continue;
            block.setIndex(sz);
            this.basicBlocks.set(sz++, block);
        }
        while (this.basicBlocks.size() > sz) {
            this.basicBlocks.remove(this.basicBlocks.size() - 1);
        }
        sz = 0;
        for (i = 0; i < this.variables.size(); ++i) {
            Variable var = this.variables.get(i);
            if (var == null) continue;
            var.setIndex(sz);
            this.variables.set(sz++, var);
        }
        while (this.variables.size() > sz) {
            this.variables.remove(this.variables.size() - 1);
        }
        this.packed = true;
    }

    @Override
    public int variableCount() {
        return this.variables.size();
    }

    @Override
    public Variable variableAt(int index) {
        if (index < 0 || index >= this.variables.size()) {
            throw new IllegalArgumentException("Index " + index + " is out of range");
        }
        return this.variables.get(index);
    }

    @Override
    public AnnotationContainer getAnnotations() {
        return this.annotations;
    }
}

