/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model;

import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Incoming;
import com.antgroup.antchain.myjava.model.IncomingReader;
import com.antgroup.antchain.myjava.model.PhiReader;
import com.antgroup.antchain.myjava.model.Variable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Phi
implements PhiReader {
    private BasicBlock basicBlock;
    private Variable receiver;
    private List<Incoming> incomings = new ArrayList<Incoming>(2);
    private List<Incoming> safeIncomings = new AbstractList<Incoming>(){

        @Override
        public Incoming get(int index) {
            return (Incoming)Phi.this.incomings.get(index);
        }

        @Override
        public Incoming set(int index, Incoming element) {
            if (element.getPhi() != null) {
                throw new IllegalArgumentException("This incoming is already in some phi");
            }
            element.setPhi(Phi.this);
            Incoming old = (Incoming)Phi.this.incomings.get(index);
            old.setPhi(null);
            Phi.this.incomings.set(index, element);
            return old;
        }

        @Override
        public void add(int index, Incoming element) {
            if (element.getPhi() != null) {
                throw new IllegalArgumentException("This incoming is already in some phi");
            }
            element.setPhi(Phi.this);
            Phi.this.incomings.add(index, element);
        }

        @Override
        public Incoming remove(int index) {
            Incoming incoming = (Incoming)Phi.this.incomings.remove(index);
            incoming.setPhi(null);
            return incoming;
        }

        @Override
        public void clear() {
            for (Incoming incoming : Phi.this.incomings) {
                incoming.setPhi(null);
            }
            Phi.this.incomings.clear();
        }

        @Override
        public int size() {
            return Phi.this.incomings.size();
        }
    };
    private List<? extends IncomingReader> immutableIncomings = Collections.unmodifiableList(this.incomings);

    @Override
    public BasicBlock getBasicBlock() {
        return this.basicBlock;
    }

    void setBasicBlock(BasicBlock basicBlock) {
        this.basicBlock = basicBlock;
    }

    @Override
    public Variable getReceiver() {
        return this.receiver;
    }

    public void setReceiver(Variable receiver) {
        this.receiver = receiver;
    }

    public List<Incoming> getIncomings() {
        return this.safeIncomings;
    }

    @Override
    public List<? extends IncomingReader> readIncomings() {
        return this.immutableIncomings;
    }
}

