/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model;

import com.antgroup.antchain.myjava.model.MethodReference;
import java.io.Serializable;
import java.util.Objects;

public class InliningInfo
implements Serializable {
    private MethodReference method;
    private String fileName;
    private int line;
    private InliningInfo parent;
    private transient int hash;

    public InliningInfo(MethodReference method, String fileName, int line, InliningInfo parent) {
        this.method = method;
        this.fileName = fileName;
        this.line = line;
        this.parent = parent;
    }

    public MethodReference getMethod() {
        return this.method;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLine() {
        return this.line;
    }

    public InliningInfo getParent() {
        return this.parent;
    }

    public boolean isEmpty() {
        return this.fileName == null && this.line < 0;
    }

    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            int prime = 31;
            result = 1;
            result = 31 * result + this.method.hashCode();
            result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
            result = 31 * result + this.line;
            this.hash = result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InliningInfo)) {
            return false;
        }
        InliningInfo that = (InliningInfo)obj;
        return Objects.equals(this.method, that.method) && Objects.equals(this.fileName, that.fileName) && this.line == that.line && Objects.equals(this.parent, that.parent);
    }
}

