/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model;

import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ClassReaderSourceHelper;
import com.antgroup.antchain.myjava.model.FieldReader;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface ClassReaderSource {
    public ClassReader get(String var1);

    default public Stream<ClassReader> getAncestorClasses(final String name) {
        return StreamSupport.stream(((Iterable)() -> new Iterator<ClassReader>(){
            ClassReader currentClass;
            {
                this.currentClass = ClassReaderSource.this.get(name);
            }

            @Override
            public ClassReader next() {
                ClassReader result = this.currentClass;
                this.currentClass = this.currentClass.getParent() != null ? ClassReaderSource.this.get(this.currentClass.getParent()) : null;
                return result;
            }

            @Override
            public boolean hasNext() {
                return this.currentClass != null;
            }
        }).spliterator(), false);
    }

    default public Stream<ClassReader> getAncestors(final String name) {
        return StreamSupport.stream(((Iterable)() -> new Iterator<ClassReader>(){
            Deque state = new ArrayDeque();
            private Set visited = new HashSet();
            {
                this.state.push(new ArrayDeque());
                this.add(name);
            }

            @Override
            public ClassReader next() {
                while (!this.state.isEmpty()) {
                    Deque level = (Deque)this.state.peek();
                    if (!level.isEmpty()) {
                        ClassReader result = (ClassReader)level.removeFirst();
                        this.follow(result);
                        return result;
                    }
                    this.state.pop();
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return !this.state.stream().allMatch(e -> e.isEmpty());
            }

            private void follow(ClassReader cls) {
                this.state.push(new ArrayDeque());
                if (cls.getParent() != null) {
                    this.add(cls.getParent());
                }
                for (String iface : cls.getInterfaces()) {
                    this.add(iface);
                }
            }

            private void add(String name2) {
                ClassReader cls = ClassReaderSource.this.get(name2);
                if (cls != null && this.visited.add(cls)) {
                    ((Deque)this.state.peek()).addLast(cls);
                }
            }
        }).spliterator(), false);
    }

    default public MethodReader resolve(MethodReference method) {
        return this.getAncestors(method.getClassName()).map(cls -> cls.getMethod(method.getDescriptor())).filter(Objects::nonNull).findFirst().orElse(null);
    }

    default public List<MethodReader> resolveNonConstructorClassMethodsWithExtendsExceptionObject(String className) {
        HashSet<MethodReader> result = new HashSet<MethodReader>();
        for (ClassReader ancestor : this.getAncestors(className).collect(Collectors.toList())) {
            MethodReader[] ancestorMethods;
            if (ancestor.getName().equals(Object.class.getName())) continue;
            for (MethodReader m : ancestorMethods = ancestor.getMethods().toArray(new MethodReader[0])) {
                MethodReader impl;
                if ("<init>".equals(m.getName()) || (impl = this.resolveImplementation(className, m.getDescriptor())) == null) continue;
                result.add(impl);
            }
        }
        return new ArrayList<MethodReader>(result);
    }

    default public MethodReader resolveImplementation(MethodReference methodReference) {
        return ClassReaderSourceHelper.resolveMethodImplementation(this, methodReference.getClassName(), methodReference.getDescriptor(), new HashSet<String>());
    }

    default public MethodReader resolveImplementation(String className, MethodDescriptor descriptor) {
        return ClassReaderSourceHelper.resolveMethodImplementation(this, className, descriptor, new HashSet<String>());
    }

    default public FieldReader resolve(FieldReference field) {
        return this.getAncestors(field.getClassName()).map(cls -> cls.getField(field.getFieldName())).filter(Objects::nonNull).findFirst().orElse(null);
    }

    default public Stream<MethodReader> overriddenMethods(MethodReference method) {
        return this.getAncestorClasses(method.getClassName()).map(cls -> cls.getMethod(method.getDescriptor())).filter(Objects::nonNull);
    }

    default public Optional<Boolean> isSuperType(String superType, String subType) {
        return ClassReaderSourceHelper.isSuperType(this, superType, subType);
    }
}

