/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.metaprogramming.impl.reflect;

import com.antgroup.antchain.myjava.metaprogramming.ReflectClass;
import com.antgroup.antchain.myjava.metaprogramming.impl.reflect.ReflectAnnotatedElementImpl;
import com.antgroup.antchain.myjava.metaprogramming.impl.reflect.ReflectClassImpl;
import com.antgroup.antchain.myjava.metaprogramming.impl.reflect.ReflectContext;
import com.antgroup.antchain.myjava.metaprogramming.reflect.ReflectAnnotatedElement;
import com.antgroup.antchain.myjava.metaprogramming.reflect.ReflectMethod;
import com.antgroup.antchain.myjava.model.AnnotationContainerReader;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.ValueType;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class ReflectMethodImpl
implements ReflectMethod {
    private ReflectContext context;
    private ReflectClassImpl<?> declaringClass;
    public final MethodReader method;
    private ReflectClassImpl<?> returnType;
    private ReflectClass<?>[] parameterTypes;
    private ReflectAnnotatedElementImpl annotations;
    private ReflectAnnotatedElementImpl[] parameterAnnotations;

    public ReflectMethodImpl(ReflectClassImpl<?> declaringClass, MethodReader method) {
        this.declaringClass = declaringClass;
        this.method = method;
        this.context = declaringClass.getReflectContext();
    }

    @Override
    public ReflectClass<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public int getModifiers() {
        return ReflectContext.getModifiers(this.method);
    }

    @Override
    public boolean isConstructor() {
        return this.method.getName().equals("<init>");
    }

    @Override
    public ReflectClass<?> getReturnType() {
        if (this.returnType == null) {
            this.returnType = this.context.getClass(this.method.getResultType());
        }
        return this.returnType;
    }

    @Override
    public ReflectClass<?>[] getParameterTypes() {
        this.ensureParameterTypes();
        return (ReflectClass[])this.parameterTypes.clone();
    }

    @Override
    public ReflectClass<?> getParameterType(int index) {
        this.ensureParameterTypes();
        return this.parameterTypes[index];
    }

    @Override
    public int getParameterCount() {
        this.ensureParameterTypes();
        return this.parameterTypes.length;
    }

    private void ensureParameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = (ReflectClass[])Arrays.stream(this.method.getParameterTypes()).map(type -> this.context.getClass((ValueType)type)).toArray(ReflectClass[]::new);
        }
    }

    public <S extends Annotation> S getAnnotation(Class<S> type) {
        if (this.annotations == null) {
            this.annotations = new ReflectAnnotatedElementImpl(this.context, this.method.getAnnotations());
        }
        return this.annotations.getAnnotation(type);
    }

    @Override
    public Object invoke(Object obj, Object ... args) {
        throw new IllegalStateException("Don't call this method from compile domain");
    }

    @Override
    public Object construct(Object ... args) {
        throw new IllegalStateException("Don't call this method from compile domain");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getReturnType()).append(' ').append(this.getName()).append('(');
        ReflectClass<?>[] parameterTypes = this.getParameterTypes();
        sb.append(Arrays.stream(parameterTypes).map(Objects::toString).collect(Collectors.joining(", ")));
        sb.append(')');
        return sb.toString();
    }

    @Override
    public ReflectAnnotatedElement getParameterAnnotations(int index) {
        if (this.parameterAnnotations == null) {
            this.parameterAnnotations = (ReflectAnnotatedElementImpl[])Arrays.stream(this.method.getParameterAnnotations()).map(annot -> new ReflectAnnotatedElementImpl(this.context, (AnnotationContainerReader)annot)).toArray(ReflectAnnotatedElementImpl[]::new);
        }
        return this.parameterAnnotations[index];
    }
}

