/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.metaprogramming.impl.model;

import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ValueType;
import java.util.HashMap;
import java.util.Map;

public class MethodModel {
    private MethodReference method;
    private MethodReference metaMethod;
    private int classParameterIndex;
    private boolean isStatic;
    private Map<ValueType, MethodReference> usages = new HashMap<ValueType, MethodReference>();

    MethodModel(MethodReference method, MethodReference metaMethod, int classParameterIndex, boolean isStatic) {
        this.method = method;
        this.metaMethod = metaMethod;
        this.classParameterIndex = classParameterIndex;
        this.isStatic = isStatic;
    }

    public MethodReference getMethod() {
        return this.method;
    }

    public MethodReference getMetaMethod() {
        return this.metaMethod;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public int getClassParameterIndex() {
        return this.classParameterIndex;
    }

    public Map<ValueType, MethodReference> getUsages() {
        return this.usages;
    }

    public int getMetaParameterCount() {
        return (this.isStatic ? 0 : 1) + this.method.parameterCount();
    }

    public ValueType getMetaParameterType(int index) {
        if (!this.isStatic) {
            if (index == 0) {
                return ValueType.object(this.method.getClassName());
            }
            --index;
        }
        return this.method.parameterType(index);
    }

    public int getMetaClassParameterIndex() {
        return this.classParameterIndex >= 0 ? this.mapParameterIndex(this.classParameterIndex) : -1;
    }

    public int mapParameterIndex(int index) {
        return this.isStatic ? index : index + 1;
    }
}

