/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.metaprogramming.impl;

import com.antgroup.antchain.myjava.dependency.AbstractDependencyListener;
import com.antgroup.antchain.myjava.dependency.DependencyAgent;
import com.antgroup.antchain.myjava.dependency.MethodDependency;
import com.antgroup.antchain.myjava.dependency.MethodDependencyInfo;
import com.antgroup.antchain.myjava.metaprogramming.impl.MetaprogrammingClassLoader;
import com.antgroup.antchain.myjava.metaprogramming.impl.MetaprogrammingImpl;
import com.antgroup.antchain.myjava.metaprogramming.impl.UsageGenerator;
import com.antgroup.antchain.myjava.metaprogramming.impl.model.MethodDescriber;
import com.antgroup.antchain.myjava.metaprogramming.impl.model.MethodModel;
import com.antgroup.antchain.myjava.metaprogramming.impl.optimization.Optimizations;
import com.antgroup.antchain.myjava.metaprogramming.impl.reflect.ReflectContext;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.emit.ProgramEmitter;
import com.antgroup.antchain.myjava.model.emit.StringChooseEmitter;
import com.antgroup.antchain.myjava.model.emit.ValueEmitter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MetaprogrammingDependencyListener
extends AbstractDependencyListener {
    private MethodDescriber describer;
    private Set<MethodModel> installedProxies = new HashSet<MethodModel>();
    private MetaprogrammingClassLoader proxyClassLoader;

    @Override
    public void started(DependencyAgent agent) {
        this.proxyClassLoader = new MetaprogrammingClassLoader(agent.getClassLoader());
        this.describer = new MethodDescriber(agent.getDiagnostics(), agent.getClassSource());
        MetaprogrammingImpl.classLoader = this.proxyClassLoader;
        MetaprogrammingImpl.classSource = agent.getClassSource();
        MetaprogrammingImpl.hierarchy = agent.getClassHierarchy();
        MetaprogrammingImpl.incrementalDependencies = agent.getIncrementalCache();
        MetaprogrammingImpl.agent = agent;
        MetaprogrammingImpl.reflectContext = new ReflectContext(agent.getClassHierarchy(), this.proxyClassLoader);
    }

    @Override
    public void complete() {
        MetaprogrammingImpl.classLoader = null;
        MetaprogrammingImpl.classSource = null;
        MetaprogrammingImpl.hierarchy = null;
        MetaprogrammingImpl.incrementalDependencies = null;
        MetaprogrammingImpl.agent = null;
        MetaprogrammingImpl.reflectContext = null;
    }

    @Override
    public void methodReached(DependencyAgent agent, MethodDependency methodDep) {
        MethodModel proxy = this.describer.getMethod(methodDep.getReference());
        if (proxy != null && this.installedProxies.add(proxy)) {
            agent.getIncrementalCache().setNoCache(methodDep.getReference());
            ClassReader cls = agent.getClassSource().get(methodDep.getMethod().getOwnerName());
            int index = 0;
            for (MethodReader methodReader : cls.getMethods()) {
                if (methodReader.getDescriptor().equals(methodDep.getMethod().getDescriptor())) break;
                ++index;
            }
            new UsageGenerator(agent, proxy, methodDep, this.proxyClassLoader, index).installProxyEmitter();
        }
    }

    @Override
    public void completing(DependencyAgent agent) {
        for (MethodModel model : this.describer.getKnownMethods()) {
            ProgramEmitter pe = ProgramEmitter.create(model.getMethod().getDescriptor(), agent.getClassHierarchy());
            ValueEmitter[] paramVars = new ValueEmitter[model.getMetaParameterCount()];
            int offset = model.isStatic() ? 1 : 0;
            for (int i = 0; i < paramVars.length; ++i) {
                paramVars[i] = pe.var(i + offset, model.getMetaParameterType(i));
            }
            if (model.getUsages().size() == 1) {
                this.emitSingleUsage(model, pe, paramVars);
            } else if (model.getUsages().isEmpty()) {
                if (model.getMethod().getReturnType() == ValueType.VOID) {
                    pe.exit();
                } else {
                    pe.constantNull(Object.class).returnValue();
                }
            } else {
                this.emitMultipleUsage(model, pe, agent, paramVars);
            }
            agent.submitMethod(model.getMethod(), new Optimizations().apply(pe.getProgram(), model.getMethod()));
        }
    }

    private void emitSingleUsage(MethodModel model, ProgramEmitter pe, ValueEmitter[] paramVars) {
        MethodReference usage = model.getUsages().values().stream().findFirst().orElse(null);
        ValueEmitter result = pe.invoke(usage, paramVars);
        if (usage.getReturnType() == ValueType.VOID) {
            pe.exit();
        } else {
            assert (result != null) : "Expected non-null result at " + model.getMethod();
            result.returnValue();
        }
    }

    private void emitMultipleUsage(MethodModel model, ProgramEmitter pe, DependencyAgent agent, ValueEmitter[] paramVars) {
        MethodDependencyInfo methodDep = agent.getMethod(model.getMethod());
        ValueEmitter paramVar = paramVars[model.getMetaClassParameterIndex()];
        ValueEmitter tag = paramVar.invokeVirtual("getName", String.class, new ValueEmitter[0]);
        StringChooseEmitter choice = pe.stringChoice(tag);
        for (Map.Entry<ValueType, MethodReference> usageEntry : model.getUsages().entrySet()) {
            ValueType type = usageEntry.getKey();
            String typeName = type instanceof ValueType.Object ? ((ValueType.Object)type).getClassName() : type.toString().replace('/', '.');
            choice.option(typeName, () -> {
                MethodReference implMethod = (MethodReference)usageEntry.getValue();
                ValueEmitter[] castParamVars = new ValueEmitter[paramVars.length];
                for (int i = 0; i < castParamVars.length; ++i) {
                    castParamVars[i] = paramVars[i].cast(implMethod.parameterType(i));
                }
                ValueEmitter result = pe.invoke(implMethod, castParamVars);
                if (implMethod.getReturnType() == ValueType.VOID) {
                    pe.exit();
                } else {
                    assert (result != null) : "Expected non-null result at " + model.getMethod();
                    result.returnValue();
                }
            });
        }
        choice.otherwise(() -> {
            if (methodDep.getReference().getReturnType() == ValueType.VOID) {
                pe.exit();
            } else {
                pe.constantNull(Object.class).returnValue();
            }
        });
    }
}

