/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.metaprogramming.impl;

import com.antgroup.antchain.myjava.common.DisjointSet;
import com.antgroup.antchain.myjava.model.BasicBlockReader;
import com.antgroup.antchain.myjava.model.PhiReader;
import com.antgroup.antchain.myjava.model.ProgramReader;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.VariableReader;
import com.antgroup.antchain.myjava.model.instructions.AbstractInstructionReader;
import com.antgroup.antchain.myjava.model.instructions.ArrayElementType;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

class AliasFinder {
    private int[] aliases;
    private ArrayElement[] arrayElements;

    AliasFinder() {
    }

    /*
     * WARNING - void declaration
     */
    void findAliases(ProgramReader program) {
        void var7_14;
        DisjointSet set = new DisjointSet();
        for (int i = 0; i < program.variableCount(); ++i) {
            set.create();
        }
        AliasReader reader = new AliasReader(set, program.variableCount());
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlockReader block = program.basicBlockAt(i);
            block.readAllInstructions(reader);
            for (PhiReader phiReader : block.readPhis()) {
                Set inputs = phiReader.readIncomings().stream().map(incoming -> incoming.getValue().getIndex()).collect(Collectors.toSet());
                if (inputs.size() != 1) continue;
                set.union((Integer)inputs.iterator().next(), phiReader.getReceiver().getIndex());
            }
        }
        int[] map = new int[set.size()];
        Arrays.fill(map, -1);
        int[] variables = new int[program.variableCount()];
        for (int i = 0; i < variables.length; ++i) {
            int n = set.find(i);
            int master = map[n];
            if (master == -1) {
                map[n] = master = i;
            }
            variables[i] = master;
        }
        this.aliases = variables;
        Object[] constants = reader.constants;
        this.arrayElements = reader.arrayElements;
        boolean bl = false;
        while (var7_14 < this.arrayElements.length) {
            ArrayElement elem = this.arrayElements[var7_14];
            if (elem != null) {
                elem.index = this.aliases[elem.index];
                if (constants[elem.index] instanceof Integer) {
                    elem.index = (Integer)constants[elem.index];
                } else {
                    this.arrayElements[var7_14] = null;
                }
            }
            ++var7_14;
        }
    }

    int[] getAliases() {
        return (int[])this.aliases.clone();
    }

    ArrayElement[] getArrayElements() {
        return (ArrayElement[])this.arrayElements.clone();
    }

    private static class AliasReader
    extends AbstractInstructionReader {
        DisjointSet disjointSet;
        Object[] constants;
        ArrayElement[] arrayElements;

        private AliasReader(DisjointSet disjointSet, int variableCount) {
            this.disjointSet = disjointSet;
            this.constants = new Object[variableCount];
            this.arrayElements = new ArrayElement[variableCount];
        }

        @Override
        public void classConstant(VariableReader receiver, ValueType cst) {
            this.constants[receiver.getIndex()] = cst;
        }

        @Override
        public void integerConstant(VariableReader receiver, int cst) {
            this.constants[receiver.getIndex()] = cst;
        }

        @Override
        public void longConstant(VariableReader receiver, long cst) {
            this.constants[receiver.getIndex()] = cst;
        }

        @Override
        public void floatConstant(VariableReader receiver, float cst) {
            this.constants[receiver.getIndex()] = Float.valueOf(cst);
        }

        @Override
        public void doubleConstant(VariableReader receiver, double cst) {
            this.constants[receiver.getIndex()] = cst;
        }

        @Override
        public void stringConstant(VariableReader receiver, String cst) {
            this.constants[receiver.getIndex()] = cst;
        }

        @Override
        public void assign(VariableReader receiver, VariableReader assignee) {
            this.disjointSet.union(receiver.getIndex(), assignee.getIndex());
        }

        @Override
        public void unwrapArray(VariableReader receiver, VariableReader array, ArrayElementType elementType) {
            this.disjointSet.union(receiver.getIndex(), array.getIndex());
        }

        @Override
        public void getElement(VariableReader receiver, VariableReader array, VariableReader index, ArrayElementType type) {
            ArrayElement elem = new ArrayElement();
            elem.array = array.getIndex();
            elem.index = index.getIndex();
            this.arrayElements[receiver.getIndex()] = elem;
        }
    }

    static class ArrayElement {
        public int array;
        public int index;

        ArrayElement() {
        }
    }
}

