/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.dependency;

import com.antgroup.antchain.myjava.dependency.DependencyNode;
import com.antgroup.antchain.myjava.dependency.DependencyType;
import com.antgroup.antchain.myjava.dependency.DependencyTypeFilter;
import com.antgroup.antchain.myjava.model.ClassHierarchy;
import com.antgroup.antchain.myjava.model.ValueType;
import java.util.Arrays;
import java.util.Set;
import org.teavm.hppc.IntHashSet;

class Transition {
    DependencyNode source;
    DependencyNode destination;
    DependencyTypeFilter filter;
    IntHashSet pendingTypes;
    byte destSubsetOfSrc;

    Transition(DependencyNode source, DependencyNode destination, DependencyTypeFilter filter) {
        this.source = source;
        this.destination = destination;
        this.filter = filter;
    }

    void consume(DependencyType type) {
        if (!this.destination.hasType(type) && this.filterType(type) && this.destination.filter(type)) {
            this.propagate(type);
        }
    }

    private void propagate(DependencyType type) {
        if (this.destination.typeSet == this.source.typeSet) {
            return;
        }
        if (this.shouldMergeDomains()) {
            this.mergeDomains(new DependencyType[]{type});
        } else {
            this.destination.propagate(type);
        }
    }

    private void propagate(DependencyType[] types) {
        if (this.destination.typeSet == this.source.typeSet) {
            return;
        }
        if (this.shouldMergeDomains()) {
            this.mergeDomains(types);
        } else {
            this.destination.propagate(types);
        }
    }

    void mergeDomains(DependencyType[] types) {
        this.destination.moveToSeparateDomain();
        this.destination.scheduleMultipleTypes(types, () -> {
            Set<DependencyNode> domainToMerge = this.destination.typeSet.domain;
            for (DependencyNode node : domainToMerge) {
                node.typeSet = this.source.typeSet;
                this.source.typeSet.domain.add(node);
            }
            this.source.typeSet.invalidate();
        });
    }

    boolean shouldMergeDomains() {
        if (!this.source.dependencyAnalyzer.domainOptimizationEnabled() || this.filter != null || !this.isDestSubsetOfSrc()) {
            return false;
        }
        if (this.destination.typeSet == null) {
            return true;
        }
        if (this.destination.typeSet == this.source.typeSet || this.destination.typeSet.origin == this.source || this.destination.typeSet.typeCount() > this.source.typeSet.typeCount()) {
            return false;
        }
        if (this.destination.splitCount > 4) {
            return false;
        }
        if (this.destination.typeSet.typeCount() == this.source.typeSet.typeCount() && this.destination.typeSet.origin != this.destination) {
            return false;
        }
        for (DependencyType type : this.destination.getTypesInternal()) {
            if (this.source.hasType(type)) continue;
            return false;
        }
        return true;
    }

    void consume(DependencyType[] types) {
        int j = 0;
        boolean copied = false;
        if (this.filter == null) {
            for (DependencyType type : types) {
                boolean added = false;
                if (!this.destination.hasType(type) && this.destination.filter(type)) {
                    types[j++] = type;
                    added = true;
                }
                if (added || copied) continue;
                copied = true;
                types = (DependencyType[])types.clone();
            }
        } else {
            for (DependencyType type : types) {
                boolean added = false;
                if (this.filterType(type) && !this.destination.hasType(type) && this.destination.filter(type)) {
                    types[j++] = type;
                    added = true;
                }
                if (added || copied) continue;
                copied = true;
                types = (DependencyType[])types.clone();
            }
        }
        if (j == 0) {
            return;
        }
        if (j == 1) {
            this.propagate(types[0]);
        } else {
            if (j < types.length) {
                types = Arrays.copyOf(types, j);
            }
            this.propagate(types);
        }
    }

    boolean filterType(DependencyType type) {
        if (this.pendingTypes != null && this.pendingTypes.contains(type.index)) {
            return false;
        }
        if (this.filter == null) {
            return true;
        }
        return this.filter.match(type);
    }

    boolean pointsToDomainOrigin() {
        return this.destination.typeSet == null || this.destination.typeSet.origin == this.destination;
    }

    boolean isDestSubsetOfSrc() {
        if (this.destSubsetOfSrc == 0) {
            this.destSubsetOfSrc = (byte)(this.calculateDestSubsetOfSrc() ? 2 : 1);
        }
        return this.destSubsetOfSrc == 2;
    }

    private boolean calculateDestSubsetOfSrc() {
        if (this.source.typeFilter == null) {
            return true;
        }
        if (this.destination.typeFilter == null) {
            return false;
        }
        ValueType sourceType = this.source.typeFilter;
        ValueType destType = this.destination.typeFilter;
        ClassHierarchy hierarchy = this.source.dependencyAnalyzer.getClassHierarchy();
        return hierarchy.isSuperType(sourceType, destType, false);
    }
}

