/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.dependency;

import com.antgroup.antchain.myjava.dependency.DefaultCallGraphNode;
import com.antgroup.antchain.myjava.dependency.DefaultCallSite;
import com.antgroup.antchain.myjava.dependency.DependencyAnalyzer;
import com.antgroup.antchain.myjava.dependency.DependencyConsumer;
import com.antgroup.antchain.myjava.dependency.DependencyNode;
import com.antgroup.antchain.myjava.dependency.DependencyType;
import com.antgroup.antchain.myjava.dependency.MethodDependency;
import com.antgroup.antchain.myjava.model.CallLocation;
import com.antgroup.antchain.myjava.model.MethodReference;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FastVirtualCallConsumer
implements DependencyConsumer {
    private static final Logger log = LoggerFactory.getLogger(FastVirtualCallConsumer.class);
    private final DependencyNode node;
    private final MethodReference methodRef;
    private final DependencyAnalyzer analyzer;
    private final Map<MethodReference, CallLocation> callLocations = new LinkedHashMap<MethodReference, CallLocation>();
    private final Set<MethodDependency> methods = new LinkedHashSet<MethodDependency>(100, 0.5f);
    final DefaultCallSite callSite;

    FastVirtualCallConsumer(DependencyNode node, MethodReference methodRef, DependencyAnalyzer analyzer) {
        this.node = node;
        this.methodRef = methodRef;
        this.analyzer = analyzer;
        this.callSite = analyzer.callGraph.getNode(methodRef).getVirtualCallSite();
    }

    @Override
    public void consume(DependencyType type) {
        MethodDependency methodDep;
        String className = type.getName();
        if (DependencyAnalyzer.shouldLog) {
            log.info("Virtual call of {} detected on {}. Target class is {}", this.methodRef, this.node.getTag(), className);
        }
        if (className.startsWith("[")) {
            className = "java.lang.Object";
        }
        if (!this.methods.add(methodDep = this.analyzer.linkMethod(className, this.methodRef.getDescriptor()))) {
            return;
        }
        DefaultCallGraphNode calledMethodNode = this.analyzer.callGraph.getNode(methodDep.getReference());
        this.callSite.calledMethods.add(calledMethodNode);
        calledMethodNode.addCaller(this.callSite);
        for (CallLocation location : this.callLocations.values()) {
            methodDep.addLocation(location, false);
        }
        if (!methodDep.isMissing()) {
            methodDep.use();
        }
    }

    void addLocation(CallLocation location) {
        if (this.callLocations.putIfAbsent(location.getMethod(), location) == null) {
            DefaultCallGraphNode caller = this.analyzer.callGraph.getNode(location.getMethod());
            caller.addVirtualCallSite(this.callSite);
            if (location.getSourceLocation() != null) {
                this.callSite.addLocation(caller, location.getSourceLocation());
            }
            for (MethodDependency method : this.methods) {
                method.addLocation(location, false);
            }
        }
    }
}

