/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.dependency;

import com.antgroup.antchain.myjava.callgraph.CallGraphNode;
import com.antgroup.antchain.myjava.callgraph.CallSite;
import com.antgroup.antchain.myjava.dependency.DefaultCallGraphNode;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.TextLocation;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DefaultCallSite
implements CallSite,
Serializable {
    private Map<CallGraphNode, Set<TextLocation>> locations;
    private TextLocation singleLocation;
    MethodReference method;
    Set<DefaultCallGraphNode> callers;
    private DefaultCallGraphNode singleCaller;
    Set<DefaultCallGraphNode> calledMethods;
    DefaultCallGraphNode singleCalledMethod;
    Collection<? extends DefaultCallGraphNode> readonlyCalledMethods;

    DefaultCallSite(MethodReference method, Set<DefaultCallGraphNode> callers) {
        this.method = method;
        this.callers = callers;
        this.locations = new HashMap<CallGraphNode, Set<TextLocation>>();
        this.calledMethods = new LinkedHashSet<DefaultCallGraphNode>();
    }

    DefaultCallSite(DefaultCallGraphNode callee, DefaultCallGraphNode caller) {
        this.singleCalledMethod = callee;
        this.singleCaller = caller;
    }

    @Override
    public Collection<? extends TextLocation> getLocations(CallGraphNode caller) {
        if (this.singleLocation != null) {
            return caller == this.singleCaller ? Collections.singleton(this.singleLocation) : Collections.emptySet();
        }
        if (this.locations == null) {
            return Collections.emptyList();
        }
        Set<TextLocation> result = this.locations.get(caller);
        return result != null ? Collections.unmodifiableSet(result) : Collections.emptySet();
    }

    public void addLocation(DefaultCallGraphNode caller, TextLocation location) {
        if (this.locations == null) {
            if (this.singleLocation == null && this.callers == null) {
                this.singleLocation = location;
                return;
            }
            this.locations = new LinkedHashMap<CallGraphNode, Set<TextLocation>>();
            if (this.singleLocation != null) {
                LinkedHashSet<TextLocation> singleLocations = new LinkedHashSet<TextLocation>();
                singleLocations.add(this.singleLocation);
                this.locations.put(this.singleCaller, singleLocations);
            }
        }
        this.locations.computeIfAbsent(caller, k -> new LinkedHashSet()).add(location);
    }

    public Collection<? extends DefaultCallGraphNode> getCalledMethods() {
        if (this.singleCalledMethod != null) {
            return Collections.singletonList(this.singleCalledMethod);
        }
        if (this.readonlyCalledMethods == null) {
            this.readonlyCalledMethods = Collections.unmodifiableCollection(this.calledMethods);
        }
        return this.readonlyCalledMethods;
    }

    public Collection<? extends DefaultCallGraphNode> getCallers() {
        return this.callers != null ? this.callers : Collections.singletonList(this.singleCaller);
    }
}

