/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.debugging;

import com.antgroup.antchain.myjava.common.Promise;
import com.antgroup.antchain.myjava.debugging.Debugger;
import com.antgroup.antchain.myjava.debugging.Variable;
import com.antgroup.antchain.myjava.debugging.information.DebugInformation;
import com.antgroup.antchain.myjava.debugging.information.SourceLocation;
import com.antgroup.antchain.myjava.debugging.javascript.JavaScriptCallFrame;
import com.antgroup.antchain.myjava.debugging.javascript.JavaScriptLocation;
import com.antgroup.antchain.myjava.model.MethodReference;
import java.util.Map;

public class CallFrame {
    private Debugger debugger;
    private JavaScriptCallFrame originalCallFrame;
    private SourceLocation location;
    private MethodReference method;
    private Promise<Map<String, Variable>> variables;
    private DebugInformation debugInformation;

    CallFrame(Debugger debugger, JavaScriptCallFrame originalFrame, SourceLocation location, MethodReference method, DebugInformation debugInformation) {
        this.debugger = debugger;
        this.originalCallFrame = originalFrame;
        this.location = location;
        this.method = method;
        this.debugInformation = debugInformation;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public JavaScriptLocation getOriginalLocation() {
        return this.originalCallFrame.getLocation();
    }

    public JavaScriptCallFrame getOriginalCallFrame() {
        return this.originalCallFrame;
    }

    public SourceLocation getLocation() {
        return this.location;
    }

    public MethodReference getMethod() {
        return this.method;
    }

    public Promise<Map<String, Variable>> getVariables() {
        if (this.variables == null) {
            this.variables = this.debugger.createVariables(this.originalCallFrame, this.debugInformation);
        }
        return this.variables;
    }
}

