/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.common;

import com.antgroup.antchain.myjava.common.Graph;
import com.antgroup.antchain.myjava.common.IntegerArray;
import com.antgroup.antchain.myjava.common.IntegerStack;
import java.util.Arrays;

class DominatorTreeBuilder {
    private Graph graph;
    private int[] semidominators;
    int[] vertices;
    private int[] parents;
    private int[] ancestors;
    private int[] labels;
    int[] dominators;
    private IntegerArray[] bucket;
    private int[] path;
    private int effectiveSize;
    private int start;

    DominatorTreeBuilder(Graph graph, int start) {
        this.graph = graph;
        this.start = start;
        this.semidominators = new int[graph.size()];
        this.vertices = new int[graph.size()];
        this.parents = new int[graph.size()];
        this.dominators = new int[graph.size()];
        Arrays.fill(this.dominators, -1);
        this.ancestors = new int[graph.size()];
        this.labels = new int[graph.size()];
        this.path = new int[graph.size()];
        this.bucket = new IntegerArray[graph.size()];
    }

    void build() {
        int w;
        int i;
        for (i = 0; i < this.labels.length; ++i) {
            this.labels[i] = i;
        }
        Arrays.fill(this.ancestors, -1);
        this.dfs();
        for (i = this.effectiveSize - 1; i >= 0; --i) {
            int u;
            w = this.vertices[i];
            if (this.parents[w] < 0) continue;
            if (w != this.start) {
                for (int v : this.graph.incomingEdges(w)) {
                    u = this.eval(v);
                    if (this.semidominators[u] < 0) continue;
                    this.semidominators[w] = Math.min(this.semidominators[w], this.semidominators[u]);
                }
            }
            this.addToBucket(this.vertices[this.semidominators[w]], w);
            this.link(this.parents[w], w);
            for (int v : this.getBucket(w)) {
                u = this.eval(v);
                int n = this.semidominators[u] < this.semidominators[v] ? u : this.parents[w];
                this.dominators[v] = n;
            }
            this.bucket[w] = null;
        }
        for (i = 0; i < this.effectiveSize; ++i) {
            w = this.vertices[i];
            if (w < 0 || this.parents[w] < 0 || this.dominators[w] == this.vertices[this.semidominators[w]]) continue;
            this.dominators[w] = this.dominators[this.dominators[w]];
        }
        this.dominators[this.start] = -1;
    }

    private void addToBucket(int v, int w) {
        IntegerArray ws = this.bucket[v];
        if (ws == null) {
            this.bucket[v] = ws = new IntegerArray(1);
        }
        ws.add(w);
    }

    private int[] getBucket(int v) {
        IntegerArray ws = this.bucket[v];
        return ws != null ? ws.getAll() : new int[]{};
    }

    private void link(int v, int w) {
        this.ancestors[w] = v;
    }

    private int eval(int v) {
        int ancestor = this.ancestors[v];
        if (ancestor == -1) {
            return v;
        }
        int i = 0;
        while (ancestor >= 0) {
            this.path[i++] = v;
            v = ancestor;
            ancestor = this.ancestors[v];
        }
        ancestor = v;
        while (--i >= 0) {
            v = this.path[i];
            if (this.semidominators[this.labels[v]] > this.semidominators[this.labels[ancestor]]) {
                this.labels[v] = this.labels[ancestor];
            }
            this.ancestors[v] = ancestor;
            ancestor = v;
        }
        return this.labels[v];
    }

    private void dfs() {
        Arrays.fill(this.semidominators, -1);
        Arrays.fill(this.vertices, -1);
        IntegerStack stack = new IntegerStack(this.graph.size());
        stack.push(this.start);
        Arrays.fill(this.parents, -1);
        int i = 0;
        while (!stack.isEmpty()) {
            int v = stack.pop();
            if (this.semidominators[v] >= 0) continue;
            this.dominators[v] = this.start;
            this.semidominators[v] = i;
            this.vertices[i++] = v;
            for (int w : this.graph.outgoingEdges(v)) {
                if (this.semidominators[w] >= 0) continue;
                this.parents[w] = v;
                stack.push(w);
            }
        }
        this.effectiveSize = i;
        this.dominators[this.start] = this.start;
    }
}

