/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.common;

import com.antgroup.antchain.myjava.common.DominatorTree;
import com.antgroup.antchain.myjava.common.LCATree;
import java.util.Arrays;

class DefaultDominatorTree
implements DominatorTree {
    private LCATree lcaTree;
    private int[] indexes;
    private int[] nodes;

    public DefaultDominatorTree(int[] dominators, int[] vertices) {
        this.lcaTree = new LCATree(dominators.length + 1);
        this.indexes = new int[dominators.length + 1];
        this.nodes = new int[dominators.length + 1];
        Arrays.fill(this.nodes, -1);
        for (int i = 0; i < dominators.length; ++i) {
            int node;
            int v = vertices[i];
            if (v < 0) continue;
            int dom = this.indexes[dominators[v] + 1];
            this.indexes[v + 1] = node = this.lcaTree.addNode(dom);
            this.nodes[node] = v;
        }
    }

    @Override
    public boolean directlyDominates(int a, int b) {
        return this.lcaTree.lcaOf(a = this.indexes[a + 1], b = this.indexes[b + 1]) == a;
    }

    @Override
    public int commonDominatorOf(int a, int b) {
        return this.nodes[this.lcaTree.lcaOf(this.indexes[a + 1], this.indexes[b + 1])];
    }

    @Override
    public boolean dominates(int a, int b) {
        return this.lcaTree.lcaOf(a = this.indexes[a + 1], b = this.indexes[b + 1]) == a;
    }

    @Override
    public int immediateDominatorOf(int a) {
        int result = this.lcaTree.parentOf(this.indexes[a + 1]);
        return result >= 0 ? this.nodes[result] : -1;
    }

    @Override
    public int levelOf(int a) {
        int index = this.indexes[a + 1];
        return this.lcaTree.depthOf(index);
    }
}

