/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util.stream.intimpl;

import com.antgroup.antchain.myjava.classlib.java.util.stream.intimpl.TSimpleIntStreamImpl;
import java.util.function.IntPredicate;

public class TLimitingIntStreamImpl
extends TSimpleIntStreamImpl {
    private TSimpleIntStreamImpl sourceStream;
    private int limit;
    private int remaining;

    public TLimitingIntStreamImpl(TSimpleIntStreamImpl sourceStream, int limit) {
        this.sourceStream = sourceStream;
        this.limit = limit;
        this.remaining = limit;
    }

    @Override
    public boolean next(IntPredicate consumer) {
        if (this.remaining == 0) {
            return false;
        }
        boolean result = this.sourceStream.next(e -> {
            if (this.remaining-- == 0) {
                return false;
            }
            return consumer.test(e);
        });
        if (!result) {
            this.remaining = 0;
        }
        return this.remaining > 0;
    }

    @Override
    protected int estimateSize() {
        int sourceEstimation = this.sourceStream.estimateSize();
        return sourceEstimation < 0 ? this.limit : Math.min(this.limit, sourceEstimation);
    }

    @Override
    public void close() throws Exception {
        this.sourceStream.close();
    }
}

