/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util.stream.impl;

import com.antgroup.antchain.myjava.classlib.java.util.stream.impl.TSimpleStreamImpl;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public class TSimpleStreamIterator<T>
implements Iterator<T> {
    private static final byte NEEDS_MORE = 0;
    private static final byte HAS_DATA = 1;
    private static final byte LAST_ELEMENT = 2;
    private static final byte DONE = 3;
    private TSimpleStreamImpl<T> stream;
    private T lastElement;
    private byte state;

    public TSimpleStreamIterator(TSimpleStreamImpl<T> stream) {
        this.stream = stream;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        this.stream.next(x -> {
            action.accept(x);
            return true;
        });
    }

    @Override
    public boolean hasNext() {
        this.fetchIfNeeded();
        return this.state != 3;
    }

    @Override
    public T next() {
        this.fetchIfNeeded();
        if (this.state == 3) {
            throw new NoSuchElementException();
        }
        T result = this.lastElement;
        this.lastElement = null;
        this.state = (byte)(this.state == 2 ? 3 : 0);
        return result;
    }

    private void fetchIfNeeded() {
        if (this.state != 0) {
            return;
        }
        this.state = 0;
        while (this.state == 0) {
            boolean hasMore = this.stream.next(e -> {
                this.lastElement = e;
                this.state = 1;
                return false;
            });
            if (hasMore) continue;
            this.state = this.state == 0 ? (byte)3 : (byte)2;
            this.stream = null;
        }
    }
}

