/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util.regex;

import com.antgroup.antchain.myjava.classlib.java.util.regex.TAbstractCharClass;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TAbstractSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TCharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TJointSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TMatchResultImpl;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TRangeSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TSupplCharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TSupplRangeSet;

class TLowHighSurrogateRangeSet
extends TJointSet {
    protected TAbstractCharClass surrChars;
    protected boolean alt;

    public TLowHighSurrogateRangeSet(TAbstractCharClass surrChars, TAbstractSet next) {
        this.surrChars = surrChars.getInstance();
        this.alt = surrChars.alt;
        this.setNext(next);
    }

    public TLowHighSurrogateRangeSet(TAbstractCharClass surrChars) {
        this.surrChars = surrChars.getInstance();
        this.alt = surrChars.alt;
    }

    @Override
    public TAbstractSet getNext() {
        return this.next;
    }

    @Override
    public void setNext(TAbstractSet next) {
        this.next = next;
    }

    @Override
    public int matches(int stringIndex, CharSequence testString, TMatchResultImpl matchResult) {
        char high;
        char low;
        int startStr = matchResult.getLeftBound();
        int strLength = matchResult.getRightBound();
        if (stringIndex + 1 > strLength) {
            matchResult.hitEnd = true;
            return -1;
        }
        char ch = testString.charAt(stringIndex);
        if (!this.surrChars.contains(ch)) {
            return -1;
        }
        if (Character.isHighSurrogate(ch) ? stringIndex + 1 < strLength && Character.isLowSurrogate(low = testString.charAt(stringIndex + 1)) : Character.isLowSurrogate(ch) && stringIndex > startStr && Character.isHighSurrogate(high = testString.charAt(stringIndex - 1))) {
            return -1;
        }
        return this.next.matches(stringIndex + 1, testString, matchResult);
    }

    @Override
    protected String getName() {
        return "range:" + (this.alt ? "^ " : " ") + this.surrChars.toString();
    }

    @Override
    public boolean first(TAbstractSet set) {
        if (set instanceof TCharSet) {
            return false;
        }
        if (set instanceof TRangeSet) {
            return false;
        }
        if (set instanceof TSupplRangeSet) {
            return false;
        }
        return !(set instanceof TSupplCharSet);
    }

    protected TAbstractCharClass getChars() {
        return this.surrChars;
    }

    @Override
    public boolean hasConsumed(TMatchResultImpl matchResult) {
        return true;
    }
}

