/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util.regex;

import com.antgroup.antchain.myjava.classlib.java.util.regex.TAbstractSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TCharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TJointSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TLowSurrogateCharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TMatchResultImpl;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TRangeSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TSupplCharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TSupplRangeSet;

class THighSurrogateCharSet
extends TJointSet {
    private char high;

    public THighSurrogateCharSet(char high) {
        this.high = high;
    }

    @Override
    public TAbstractSet getNext() {
        return this.next;
    }

    @Override
    public void setNext(TAbstractSet next) {
        this.next = next;
    }

    @Override
    public int matches(int stringIndex, CharSequence testString, TMatchResultImpl matchResult) {
        char low;
        int strLength = matchResult.getRightBound();
        if (stringIndex + 1 > strLength) {
            matchResult.hitEnd = true;
            return -1;
        }
        char high = testString.charAt(stringIndex);
        if (stringIndex + 1 < strLength && Character.isLowSurrogate(low = testString.charAt(stringIndex + 1))) {
            return -1;
        }
        if (this.high == high) {
            return this.next.matches(stringIndex + 1, testString, matchResult);
        }
        return -1;
    }

    @Override
    public int find(int strIndex, CharSequence testString, TMatchResultImpl matchResult) {
        if (testString instanceof String) {
            String testStr = (String)testString;
            int strLength = matchResult.getRightBound();
            while (strIndex < strLength) {
                if ((strIndex = testStr.indexOf(this.high, strIndex)) < 0) {
                    return -1;
                }
                if (strIndex + 1 < strLength && Character.isLowSurrogate(testStr.charAt(strIndex + 1))) {
                    strIndex += 2;
                    continue;
                }
                if (this.next.matches(strIndex + 1, testString, matchResult) >= 0) {
                    return strIndex;
                }
                ++strIndex;
            }
            return -1;
        }
        return super.find(strIndex, testString, matchResult);
    }

    @Override
    public int findBack(int strIndex, int lastIndex, CharSequence testString, TMatchResultImpl matchResult) {
        if (testString instanceof String) {
            String testStr = (String)testString;
            int strLength = matchResult.getRightBound();
            while (lastIndex >= strIndex) {
                if ((lastIndex = testStr.lastIndexOf(this.high, lastIndex)) < 0 || lastIndex < strIndex) {
                    return -1;
                }
                if (lastIndex + 1 < strLength && Character.isLowSurrogate(testStr.charAt(lastIndex + 1))) {
                    --lastIndex;
                    continue;
                }
                if (this.next.matches(lastIndex + 1, testString, matchResult) >= 0) {
                    return lastIndex;
                }
                --lastIndex;
            }
            return -1;
        }
        return super.findBack(strIndex, lastIndex, testString, matchResult);
    }

    @Override
    protected String getName() {
        return "" + this.high;
    }

    protected int getChar() {
        return this.high;
    }

    @Override
    public boolean first(TAbstractSet set) {
        if (set instanceof TCharSet) {
            return false;
        }
        if (set instanceof TRangeSet) {
            return false;
        }
        if (set instanceof TSupplRangeSet) {
            return false;
        }
        if (set instanceof TSupplCharSet) {
            return false;
        }
        if (set instanceof TLowSurrogateCharSet) {
            return false;
        }
        if (set instanceof THighSurrogateCharSet) {
            return ((THighSurrogateCharSet)set).high == this.high;
        }
        return true;
    }

    @Override
    public boolean hasConsumed(TMatchResultImpl matchResult) {
        return true;
    }
}

