/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util;

import com.antgroup.antchain.myjava.classlib.java.util.TAbstractSet;
import com.antgroup.antchain.myjava.classlib.java.util.TCollection;
import com.antgroup.antchain.myjava.classlib.java.util.TComparator;
import com.antgroup.antchain.myjava.classlib.java.util.TIterator;
import com.antgroup.antchain.myjava.classlib.java.util.TMap;
import com.antgroup.antchain.myjava.classlib.java.util.TNavigableSet;
import com.antgroup.antchain.myjava.classlib.java.util.TSortedSet;
import com.antgroup.antchain.myjava.classlib.java.util.TTreeMap;
import com.antgroup.antchain.myjava.interop.NoMetadata;

@NoMetadata
public class TTreeSet<E>
extends TAbstractSet<E>
implements TNavigableSet<E> {
    private static final Object VALUE = new Object();
    private TTreeMap<E, Object> map;

    public TTreeSet() {
        this.map = new TTreeMap();
    }

    public TTreeSet(TComparator<? super E> comparator) {
        this.map = new TTreeMap(comparator);
    }

    public TTreeSet(TCollection<? extends E> coll) {
        this.map = new TTreeMap();
        TIterator iter = coll.iterator();
        while (iter.hasNext()) {
            this.map.put(iter.next(), VALUE);
        }
    }

    public TTreeSet(TSortedSet<E> s) {
        this.map = new TTreeMap(s.comparator());
        TIterator iter = s.iterator();
        while (iter.hasNext()) {
            this.map.put(iter.next(), VALUE);
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public TIterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, e) != VALUE;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == VALUE;
    }

    @Override
    public TComparator<? super E> comparator() {
        return this.map.comparator();
    }

    @Override
    public TSortedSet<E> subSet(E fromElement, E toElement) {
        return this.map.subMap(fromElement, true, toElement, false).navigableKeySet();
    }

    @Override
    public TSortedSet<E> headSet(E toElement) {
        return this.map.headMap(toElement, false).navigableKeySet();
    }

    @Override
    public TSortedSet<E> tailSet(E fromElement) {
        return this.map.tailMap(fromElement, true).navigableKeySet();
    }

    @Override
    public E first() {
        return this.map.firstKey();
    }

    @Override
    public E last() {
        return this.map.lastKey();
    }

    @Override
    public E pollFirst() {
        TMap.Entry<E, Object> entry = this.map.pollFirstEntry();
        return entry != null ? (E)entry.getKey() : null;
    }

    @Override
    public E pollLast() {
        TMap.Entry<E, Object> entry = this.map.pollLastEntry();
        return entry != null ? (E)entry.getKey() : null;
    }

    @Override
    public TNavigableSet<E> descendingSet() {
        return this.map.descendingKeySet();
    }

    @Override
    public TIterator<E> descendingIterator() {
        return this.map.descendingKeySet().iterator();
    }

    @Override
    public TNavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return this.map.subMap(fromElement, true, toElement, false).navigableKeySet();
    }

    @Override
    public TNavigableSet<E> headSet(E toElement, boolean inclusive) {
        return this.map.headMap(toElement, inclusive).navigableKeySet();
    }

    @Override
    public TNavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return this.map.tailMap(fromElement, inclusive).navigableKeySet();
    }
}

