/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util;

import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;

public interface TSpliterator<T> {
    public static final int ORDERED = 16;
    public static final int DISTINCT = 1;
    public static final int SORTED = 4;
    public static final int SIZED = 64;
    public static final int NONNULL = 256;
    public static final int IMMUTABLE = 1024;
    public static final int CONCURRENT = 4096;
    public static final int SUBSIZED = 16384;

    public boolean tryAdvance(Consumer<? super T> var1);

    default public void forEachRemaining(Consumer<? super T> action) {
        while (this.tryAdvance(action)) {
        }
    }

    public TSpliterator<T> trySplit();

    public long estimateSize();

    default public long getExactSizeIfKnown() {
        return (this.characteristics() & 0x40) != 0 ? this.estimateSize() : -1L;
    }

    public int characteristics();

    default public boolean hasCharacteristics(int characteristics) {
        return (this.characteristics() & characteristics) == characteristics;
    }

    default public Comparator<? super T> getComparator() {
        throw new IllegalStateException();
    }

    public static interface OfDouble
    extends OfPrimitive<Double, DoubleConsumer, OfDouble> {
        @Override
        public boolean tryAdvance(DoubleConsumer var1);

        @Override
        default public boolean tryAdvance(Consumer<? super Double> action) {
            return this.tryAdvance(action::accept);
        }

        @Override
        default public void forEachRemaining(Consumer<? super Double> action) {
            while (this.tryAdvance(action)) {
            }
        }

        @Override
        default public void forEachRemaining(DoubleConsumer action) {
            while (this.tryAdvance(action)) {
            }
        }
    }

    public static interface OfLong
    extends OfPrimitive<Long, LongConsumer, OfLong> {
        @Override
        public boolean tryAdvance(LongConsumer var1);

        @Override
        default public boolean tryAdvance(Consumer<? super Long> action) {
            return this.tryAdvance(action::accept);
        }

        @Override
        default public void forEachRemaining(Consumer<? super Long> action) {
            while (this.tryAdvance(action)) {
            }
        }

        @Override
        default public void forEachRemaining(LongConsumer action) {
            while (this.tryAdvance(action)) {
            }
        }
    }

    public static interface OfInt
    extends OfPrimitive<Integer, IntConsumer, OfInt> {
        @Override
        public boolean tryAdvance(IntConsumer var1);

        @Override
        default public boolean tryAdvance(Consumer<? super Integer> action) {
            if (action instanceof IntConsumer) {
                return this.tryAdvance((IntConsumer)((Object)action));
            }
            return this.tryAdvance(action::accept);
        }

        @Override
        default public void forEachRemaining(Consumer<? super Integer> action) {
            while (this.tryAdvance(action)) {
            }
        }

        @Override
        default public void forEachRemaining(IntConsumer action) {
            while (this.tryAdvance(action)) {
            }
        }
    }

    public static interface OfPrimitive<T, C, S extends OfPrimitive<T, C, S>>
    extends TSpliterator<T> {
        public S trySplit();

        public boolean tryAdvance(C var1);

        default public void forEachRemaining(C action) {
            while (this.tryAdvance(action)) {
            }
        }
    }
}

