/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util;

import com.antgroup.antchain.myjava.classlib.java.io.TSerializable;
import com.antgroup.antchain.myjava.classlib.java.lang.TObject;
import com.antgroup.antchain.myjava.classlib.java.util.stream.TDoubleStream;
import com.antgroup.antchain.myjava.classlib.java.util.stream.TIntStream;
import com.antgroup.antchain.myjava.classlib.java.util.stream.TLongStream;
import com.antgroup.antchain.myjava.classlib.java.util.stream.doubleimpl.TSimpleDoubleStreamImpl;
import com.antgroup.antchain.myjava.classlib.java.util.stream.intimpl.TSimpleIntStreamImpl;
import com.antgroup.antchain.myjava.classlib.java.util.stream.longimpl.TSimpleLongStreamImpl;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;

public class TRandom
extends TObject
implements TSerializable {
    private double storedGaussian;
    private boolean haveStoredGaussian;
    private long seed;
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;

    public TRandom() {
        this.seed = 0L;
    }

    public TRandom(long seed) {
        this.seed = seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    protected int next(int bits) {
        long nextseed;
        long seed;
        long oldseed = seed = this.seed;
        seed = nextseed = oldseed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(nextseed >>> 48 - bits);
    }

    public void nextBytes(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)this.next(8);
        }
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        return (int)(this.nextDouble() * (double)n);
    }

    public long nextLong() {
        return (long)this.nextInt() << 32 | (long)this.nextInt();
    }

    public boolean nextBoolean() {
        return this.nextInt() % 2 == 0;
    }

    public float nextFloat() {
        return (float)this.nextDouble();
    }

    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) * (double)1.110223E-16f;
    }

    public double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.haveStoredGaussian) {
            this.haveStoredGaussian = false;
            return this.storedGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double m = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        this.storedGaussian = v2 * m;
        this.haveStoredGaussian = true;
        return v1 * m;
    }

    public TIntStream ints(final long streamSize) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException();
        }
        return new TSimpleIntStreamImpl(){
            private long remaining;
            {
                this.remaining = streamSize;
            }

            @Override
            public boolean next(IntPredicate consumer) {
                while (this.remaining > 0L) {
                    --this.remaining;
                    if (consumer.test(TRandom.this.nextInt())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public TIntStream ints() {
        return new TSimpleIntStreamImpl(){

            @Override
            public boolean next(IntPredicate consumer) {
                while (consumer.test(TRandom.this.nextInt())) {
                }
                return true;
            }
        };
    }

    public TIntStream ints(final long streamSize, final int randomNumberOrigin, final int randomNumberBound) {
        if (streamSize < 0L || randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException();
        }
        final int range = randomNumberBound - randomNumberOrigin;
        if (range > 0) {
            return new TSimpleIntStreamImpl(){
                long remaining;
                {
                    this.remaining = streamSize;
                }

                @Override
                public boolean next(IntPredicate consumer) {
                    while (this.remaining > 0L) {
                        --this.remaining;
                        if (consumer.test(TRandom.this.nextInt(range) + randomNumberOrigin)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        return new TSimpleIntStreamImpl(){
            long remaining;
            {
                this.remaining = streamSize;
            }

            @Override
            public boolean next(IntPredicate consumer) {
                while (this.remaining > 0L) {
                    int n;
                    --this.remaining;
                    while ((n = TRandom.this.nextInt()) < randomNumberOrigin || n >= randomNumberBound) {
                    }
                    if (consumer.test(n)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public TIntStream ints(final int randomNumberOrigin, final int randomNumberBound) {
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException();
        }
        final int range = randomNumberBound - randomNumberOrigin;
        if (range > 0) {
            return new TSimpleIntStreamImpl(){

                @Override
                public boolean next(IntPredicate consumer) {
                    while (consumer.test(TRandom.this.nextInt(range) + randomNumberOrigin)) {
                    }
                    return true;
                }
            };
        }
        return new TSimpleIntStreamImpl(){

            @Override
            public boolean next(IntPredicate consumer) {
                int n;
                while ((n = TRandom.this.nextInt()) < randomNumberOrigin || n >= randomNumberBound || consumer.test(n)) {
                }
                return true;
            }
        };
    }

    public TLongStream longs(final long streamSize) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException();
        }
        return new TSimpleLongStreamImpl(){
            private long remaining;
            {
                this.remaining = streamSize;
            }

            @Override
            public boolean next(LongPredicate consumer) {
                while (this.remaining > 0L) {
                    --this.remaining;
                    if (consumer.test(TRandom.this.nextLong())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public TLongStream longs() {
        return new TSimpleLongStreamImpl(){

            @Override
            public boolean next(LongPredicate consumer) {
                while (consumer.test(TRandom.this.nextLong())) {
                }
                return true;
            }
        };
    }

    private long nextLong(long limit) {
        long result;
        long value;
        while ((value = this.nextLong()) - (result = value % limit) + (limit - 1L) >= 0L) {
        }
        return result;
    }

    public TLongStream longs(final long streamSize, final long randomNumberOrigin, final long randomNumberBound) {
        if (streamSize < 0L || randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException();
        }
        final long range = randomNumberBound - randomNumberOrigin;
        if (range > 0L) {
            return new TSimpleLongStreamImpl(){
                long remaining;
                {
                    this.remaining = streamSize;
                }

                @Override
                public boolean next(LongPredicate consumer) {
                    while (this.remaining > 0L) {
                        --this.remaining;
                        if (consumer.test(TRandom.this.nextLong(range) + randomNumberOrigin)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        return new TSimpleLongStreamImpl(){
            long remaining;
            {
                this.remaining = streamSize;
            }

            @Override
            public boolean next(LongPredicate consumer) {
                while (this.remaining > 0L) {
                    long n;
                    --this.remaining;
                    while ((n = TRandom.this.nextLong()) < randomNumberOrigin || n >= randomNumberBound) {
                    }
                    if (consumer.test(n)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public TLongStream longs(final long randomNumberOrigin, final long randomNumberBound) {
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException();
        }
        final long range = randomNumberBound - randomNumberOrigin;
        if (range > 0L) {
            return new TSimpleLongStreamImpl(){

                @Override
                public boolean next(LongPredicate consumer) {
                    while (consumer.test(TRandom.this.nextLong(range) + randomNumberOrigin)) {
                    }
                    return true;
                }
            };
        }
        return new TSimpleLongStreamImpl(){

            @Override
            public boolean next(LongPredicate consumer) {
                long n;
                while ((n = TRandom.this.nextLong()) < randomNumberOrigin || n >= randomNumberBound || consumer.test(n)) {
                }
                return true;
            }
        };
    }

    public TDoubleStream doubles(final long streamSize) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException();
        }
        return new TSimpleDoubleStreamImpl(){
            private long remaining;
            {
                this.remaining = streamSize;
            }

            @Override
            public boolean next(DoublePredicate consumer) {
                while (this.remaining > 0L) {
                    --this.remaining;
                    if (consumer.test(TRandom.this.nextDouble())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public TDoubleStream doubles() {
        return new TSimpleDoubleStreamImpl(){

            @Override
            public boolean next(DoublePredicate consumer) {
                while (consumer.test(TRandom.this.nextDouble())) {
                }
                return true;
            }
        };
    }

    public TDoubleStream doubles(final long streamSize, final double randomNumberOrigin, double randomNumberBound) {
        if (streamSize < 0L || randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException();
        }
        final double range = randomNumberBound - randomNumberOrigin;
        return new TSimpleDoubleStreamImpl(){
            long remaining;
            {
                this.remaining = streamSize;
            }

            @Override
            public boolean next(DoublePredicate consumer) {
                while (this.remaining > 0L) {
                    --this.remaining;
                    if (consumer.test(TRandom.this.nextDouble() * range + randomNumberOrigin)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public TDoubleStream doubles(final double randomNumberOrigin, double randomNumberBound) {
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException();
        }
        final double range = randomNumberBound - randomNumberOrigin;
        return new TSimpleDoubleStreamImpl(){

            @Override
            public boolean next(DoublePredicate consumer) {
                while (consumer.test(TRandom.this.nextDouble() * range + randomNumberOrigin)) {
                }
                return true;
            }
        };
    }
}

