/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util;

import com.antgroup.antchain.myjava.classlib.java.io.TSerializable;
import com.antgroup.antchain.myjava.classlib.java.lang.TCloneable;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import java.util.Arrays;

@NoMetadata
public final class TLocale
implements TCloneable,
TSerializable {
    private static TLocale defaultLocale;
    public static final TLocale CHINA;
    public static final TLocale CHINESE;
    public static final TLocale ENGLISH;
    public static final TLocale US;
    public static final TLocale ROOT;
    private static TLocale[] availableLocales;
    private transient String countryCode;
    private transient String languageCode;
    private transient String variantCode;

    public TLocale(String language) {
        this(language, "", "");
    }

    public TLocale(String language, String country) {
        this(language, country, "");
    }

    public TLocale(String language, String country, String variant) {
        if (language == null || country == null || variant == null) {
            throw new NullPointerException();
        }
        if (language.length() == 0 && country.length() == 0) {
            this.languageCode = "";
            this.countryCode = "";
            this.variantCode = variant;
            return;
        }
        this.languageCode = language;
        this.countryCode = country;
        this.variantCode = variant;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TLocale) {
            TLocale o = (TLocale)object;
            return this.languageCode.equals(o.languageCode) && this.countryCode.equals(o.countryCode) && this.variantCode.equals(o.variantCode);
        }
        return false;
    }

    public static TLocale[] getAvailableLocales() {
        if (availableLocales == null) {
            availableLocales = new TLocale[]{new TLocale("en", "US"), new TLocale("zh", "CN")};
        }
        return Arrays.copyOf(availableLocales, availableLocales.length);
    }

    public String getCountry() {
        return this.countryCode;
    }

    public static TLocale getDefault() {
        return defaultLocale;
    }

    public String getDisplayCountry() {
        return this.getDisplayCountry(TLocale.getDefault());
    }

    public String getDisplayCountry(TLocale locale) {
        String result = TLocale.getDisplayCountry(locale.getLanguage() + "-" + locale.getCountry(), this.countryCode);
        if (result == null) {
            result = TLocale.getDisplayCountry(locale.getLanguage(), this.countryCode);
        }
        return result != null ? result : this.countryCode;
    }

    private static String getDisplayCountry(String localeName, String country) {
        if ("zh".equals(localeName) || localeName.startsWith("zh-")) {
            switch (country) {
                case "US": {
                    return "\u7f8e\u56fd";
                }
                case "GB": {
                    return "\u82f1\u56fd";
                }
                case "CN": {
                    return "\u4e2d\u56fd";
                }
            }
        } else if ("en".equals(localeName) || localeName.startsWith("en-")) {
            switch (country) {
                case "US": {
                    return "United States";
                }
                case "GB": {
                    return "United Kingdom";
                }
                case "CN": {
                    return "China";
                }
            }
        }
        return country;
    }

    public String getDisplayLanguage() {
        return this.getDisplayLanguage(TLocale.getDefault());
    }

    public String getDisplayLanguage(TLocale locale) {
        String result = TLocale.getDisplayLanguage(locale.getLanguage() + "-" + locale.getCountry(), this.languageCode);
        if (result == null) {
            result = TLocale.getDisplayLanguage(locale.getLanguage(), this.languageCode);
        }
        return result != null ? result : this.languageCode;
    }

    private static String getDisplayLanguage(String localeName, String language) {
        if ("zh".equals(localeName) || localeName.startsWith("zh-")) {
            switch (language) {
                case "en": {
                    return "\u82f1\u8bed";
                }
                case "zh": {
                    return "\u4e2d\u6587";
                }
            }
        } else if ("en".equals(localeName) || localeName.startsWith("en-")) {
            switch (language) {
                case "en": {
                    return "English";
                }
                case "zh": {
                    return "Chinese";
                }
            }
        }
        return language;
    }

    public String getDisplayName() {
        return this.getDisplayName(TLocale.getDefault());
    }

    public String getDisplayName(TLocale locale) {
        int count = 0;
        StringBuilder buffer = new StringBuilder();
        if (this.languageCode.length() > 0) {
            buffer.append(this.getDisplayLanguage(locale));
            ++count;
        }
        if (this.countryCode.length() > 0) {
            if (count == 1) {
                buffer.append(" (");
            }
            buffer.append(this.getDisplayCountry(locale));
            ++count;
        }
        if (this.variantCode.length() > 0) {
            if (count == 1) {
                buffer.append(" (");
            } else if (count == 2) {
                buffer.append(",");
            }
            buffer.append(this.getDisplayVariant(locale));
            ++count;
        }
        if (count > 1) {
            buffer.append(")");
        }
        return buffer.toString();
    }

    public String getDisplayVariant() {
        return this.getDisplayVariant(TLocale.getDefault());
    }

    public String getDisplayVariant(TLocale locale) {
        return locale.getVariant();
    }

    public String getLanguage() {
        return this.languageCode;
    }

    public String getVariant() {
        return this.variantCode;
    }

    public int hashCode() {
        return this.countryCode.hashCode() + this.languageCode.hashCode() + this.variantCode.hashCode();
    }

    public static void setDefault(TLocale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        defaultLocale = locale;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.languageCode);
        if (this.countryCode.length() > 0) {
            result.append('_');
            result.append(this.countryCode);
        }
        if (this.variantCode.length() > 0 && result.length() > 0) {
            if (0 == this.countryCode.length()) {
                result.append("__");
            } else {
                result.append('_');
            }
            result.append(this.variantCode);
        }
        return result.toString();
    }

    static {
        CHINA = new TLocale("zh", "CN");
        CHINESE = new TLocale("zh", "");
        ENGLISH = new TLocale("en", "");
        US = new TLocale("en", "US");
        ROOT = new TLocale("", "");
        defaultLocale = US;
    }
}

