/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.nio.charset.impl;

import com.antgroup.antchain.myjava.classlib.java.nio.charset.TCharset;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.TCoderResult;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.impl.TBufferedDecoder;
import com.antgroup.antchain.myjava.interop.NoMetadata;

@NoMetadata
public class TUTF8Decoder
extends TBufferedDecoder {
    public TUTF8Decoder(TCharset cs) {
        super(cs, 0.33333334f, 0.5f);
    }

    @Override
    protected TCoderResult arrayDecode(byte[] inArray, int inPos, int inSize, char[] outArray, int outPos, int outSize, TBufferedDecoder.Controller controller) {
        TCoderResult result = null;
        while (inPos < inSize && outPos < outSize) {
            byte b3;
            byte b2;
            int b;
            if (((b = inArray[inPos++] & 0xFF) & 0x80) == 0) {
                outArray[outPos++] = (char)b;
                continue;
            }
            if ((b & 0xE0) == 192) {
                if (inPos >= inSize) {
                    --inPos;
                    if (controller.hasMoreInput(2)) break;
                    result = TCoderResult.UNDERFLOW;
                    break;
                }
                if (!this.checkMidByte(b2 = inArray[inPos++])) {
                    inPos -= 2;
                    result = TCoderResult.malformedForLength(1);
                    break;
                }
                outArray[outPos++] = (char)((b & 0x1F) << 6 | b2 & 0x3F);
                continue;
            }
            if ((b & 0xF0) == 224) {
                if (inPos + 2 > inSize) {
                    --inPos;
                    if (controller.hasMoreInput(3)) break;
                    result = TCoderResult.UNDERFLOW;
                    break;
                }
                b2 = inArray[inPos++];
                b3 = inArray[inPos++];
                if (!this.checkMidByte(b2) || !this.checkMidByte(b3)) {
                    inPos -= 3;
                    result = TCoderResult.malformedForLength(1);
                    break;
                }
                char c = (char)((b & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                if (Character.isSurrogate(c)) {
                    inPos -= 3;
                    result = TCoderResult.malformedForLength(3);
                    break;
                }
                outArray[outPos++] = c;
                continue;
            }
            if ((b & 0xF8) == 240) {
                if (inPos + 3 > inSize) {
                    --inPos;
                    if (controller.hasMoreInput(4)) break;
                    result = TCoderResult.UNDERFLOW;
                    break;
                }
                if (outPos + 2 > outSize) {
                    --inPos;
                    if (controller.hasMoreOutput(2)) break;
                    result = TCoderResult.OVERFLOW;
                    break;
                }
                b2 = inArray[inPos++];
                b3 = inArray[inPos++];
                byte b4 = inArray[inPos++];
                if (!(this.checkMidByte(b2) && this.checkMidByte(b3) && this.checkMidByte(b4))) {
                    inPos -= 3;
                    result = TCoderResult.malformedForLength(1);
                    break;
                }
                int code = (b & 7) << 18 | (b2 & 0x3F) << 12 | (b3 & 0x3F) << 6 | b4 & 0x3F;
                outArray[outPos++] = Character.highSurrogate(code);
                outArray[outPos++] = Character.lowSurrogate(code);
                continue;
            }
            --inPos;
            result = TCoderResult.malformedForLength(1);
            break;
        }
        controller.setInPosition(inPos);
        controller.setOutPosition(outPos);
        return result;
    }

    private boolean checkMidByte(byte b) {
        return (b & 0xC0) == 128;
    }
}

