/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.nio;

import com.antgroup.antchain.myjava.classlib.java.nio.TByteOrder;
import com.antgroup.antchain.myjava.classlib.java.nio.TShortBuffer;
import com.antgroup.antchain.myjava.classlib.java.nio.TShortBufferImpl;

class TShortBufferOverArray
extends TShortBufferImpl {
    boolean readOnly;
    int start;
    short[] array;

    public TShortBufferOverArray(int capacity) {
        this(0, capacity, new short[capacity], 0, capacity, false);
    }

    public TShortBufferOverArray(int start, int capacity, short[] array, int position, int limit, boolean readOnly) {
        super(capacity, position, limit);
        this.start = start;
        this.readOnly = readOnly;
        this.array = array;
    }

    @Override
    TShortBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        return new TShortBufferOverArray(this.start + start, capacity, this.array, position, limit, readOnly);
    }

    @Override
    short getElement(int index) {
        return this.array[index + this.start];
    }

    @Override
    void putElement(int index, short value) {
        this.array[index + this.start] = value;
    }

    @Override
    boolean isArrayPresent() {
        return true;
    }

    @Override
    short[] getArray() {
        return this.array;
    }

    @Override
    int getArrayOffset() {
        return this.start;
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public TByteOrder order() {
        return TByteOrder.BIG_ENDIAN;
    }
}

