/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.nio;

import com.antgroup.antchain.myjava.classlib.java.nio.TByteOrder;
import com.antgroup.antchain.myjava.classlib.java.nio.TLongBuffer;
import com.antgroup.antchain.myjava.classlib.java.nio.TLongBufferImpl;

class TLongBufferOverArray
extends TLongBufferImpl {
    boolean readOnly;
    int start;
    long[] array;

    public TLongBufferOverArray(int capacity) {
        this(0, capacity, new long[capacity], 0, capacity, false);
    }

    public TLongBufferOverArray(int start, int capacity, long[] array, int position, int limit, boolean readOnly) {
        super(capacity, position, limit);
        this.start = start;
        this.readOnly = readOnly;
        this.array = array;
    }

    @Override
    TLongBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        return new TLongBufferOverArray(this.start + start, capacity, this.array, position, limit, readOnly);
    }

    @Override
    long getElement(int index) {
        return this.array[index + this.start];
    }

    @Override
    void putElement(int index, long value) {
        this.array[index + this.start] = value;
    }

    @Override
    boolean isArrayPresent() {
        return true;
    }

    @Override
    long[] getArray() {
        return this.array;
    }

    @Override
    int getArrayOffset() {
        return this.start;
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public TByteOrder order() {
        return TByteOrder.BIG_ENDIAN;
    }
}

