/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.math;

import com.antgroup.antchain.myjava.classlib.java.math.TBitLevel;
import com.antgroup.antchain.myjava.classlib.java.math.TConversion;
import com.antgroup.antchain.myjava.classlib.java.math.TDivision;
import com.antgroup.antchain.myjava.classlib.java.math.TElementary;
import com.antgroup.antchain.myjava.classlib.java.math.TLogical;
import com.antgroup.antchain.myjava.classlib.java.math.TMultiplication;
import com.antgroup.antchain.myjava.classlib.java.math.TPrimality;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import java.io.Serializable;
import java.util.Random;

@NoMetadata
public class TBigInteger
extends Number
implements Comparable<TBigInteger>,
Serializable {
    private static final long serialVersionUID = -8287574255936472291L;
    transient int[] digits;
    transient int numberLength;
    transient int sign;
    public static final TBigInteger ZERO = new TBigInteger(0, 0);
    public static final TBigInteger ONE = new TBigInteger(1, 1);
    public static final TBigInteger TEN = new TBigInteger(1, 10);
    static final TBigInteger MINUS_ONE = new TBigInteger(-1, 1);
    static final int EQUALS = 0;
    static final int GREATER = 1;
    static final int LESS = -1;
    static final TBigInteger[] SMALL_VALUES = new TBigInteger[]{ZERO, ONE, new TBigInteger(1, 2), new TBigInteger(1, 3), new TBigInteger(1, 4), new TBigInteger(1, 5), new TBigInteger(1, 6), new TBigInteger(1, 7), new TBigInteger(1, 8), new TBigInteger(1, 9), TEN};
    static final TBigInteger[] TWO_POWS = new TBigInteger[32];
    private transient int firstNonzeroDigit = -2;
    private transient int hashCode;

    public TBigInteger(int numBits, Random rnd) {
        if (numBits < 0) {
            throw new IllegalArgumentException("numBits must be non-negative");
        }
        if (numBits == 0) {
            this.sign = 0;
            this.numberLength = 1;
            this.digits = new int[]{0};
        } else {
            this.sign = 1;
            this.numberLength = numBits + 31 >> 5;
            this.digits = new int[this.numberLength];
            for (int i = 0; i < this.numberLength; ++i) {
                this.digits[i] = rnd.nextInt();
            }
            int n = this.numberLength - 1;
            this.digits[n] = this.digits[n] >>> (-numBits & 0x1F);
            this.cutOffLeadingZeroes();
        }
    }

    public TBigInteger(int bitLength, int certainty, Random rnd) {
        if (bitLength < 2) {
            throw new ArithmeticException("bitLength < 2");
        }
        TBigInteger me = TPrimality.consBigInteger(bitLength, certainty, rnd);
        this.sign = me.sign;
        this.numberLength = me.numberLength;
        this.digits = me.digits;
    }

    public TBigInteger(String val) {
        this(val, 10);
    }

    public TBigInteger(String val, int radix) {
        if (val == null) {
            throw new NullPointerException();
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("Radix out of range");
        }
        if (val.length() == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        TBigInteger.setFromString(this, val, radix);
    }

    public TBigInteger(int signum, byte[] magnitude) {
        if (magnitude == null) {
            throw new NullPointerException();
        }
        if (signum < -1 || signum > 1) {
            throw new NumberFormatException("Invalid signum value");
        }
        if (signum == 0) {
            for (byte element : magnitude) {
                if (element == 0) continue;
                throw new NumberFormatException("signum-magnitude mismatch");
            }
        }
        if (magnitude.length == 0) {
            this.sign = 0;
            this.numberLength = 1;
            this.digits = new int[]{0};
        } else {
            this.sign = signum;
            this.putBytesPositiveToIntegers(magnitude);
            this.cutOffLeadingZeroes();
        }
    }

    public TBigInteger(byte[] val) {
        if (val.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (val[0] < 0) {
            this.sign = -1;
            this.putBytesNegativeToIntegers(val);
        } else {
            this.sign = 1;
            this.putBytesPositiveToIntegers(val);
        }
        this.cutOffLeadingZeroes();
    }

    TBigInteger(int sign, int value) {
        this.sign = sign;
        this.numberLength = 1;
        this.digits = new int[]{value};
    }

    TBigInteger(int sign, int numberLength, int[] digits) {
        this.sign = sign;
        this.numberLength = numberLength;
        this.digits = digits;
    }

    TBigInteger(int sign, long val) {
        this.sign = sign;
        if ((val & 0xFFFFFFFF00000000L) == 0L) {
            this.numberLength = 1;
            this.digits = new int[]{(int)val};
        } else {
            this.numberLength = 2;
            this.digits = new int[]{(int)val, (int)(val >> 32)};
        }
    }

    TBigInteger(int signum, int[] digits) {
        if (digits.length == 0) {
            this.sign = 0;
            this.numberLength = 1;
            this.digits = new int[]{0};
        } else {
            this.sign = signum;
            this.numberLength = digits.length;
            this.digits = digits;
            this.cutOffLeadingZeroes();
        }
    }

    public static TBigInteger valueOf(long val) {
        if (val < 0L) {
            if (val != -1L) {
                return new TBigInteger(-1, -val);
            }
            return MINUS_ONE;
        }
        if (val <= 10L) {
            return SMALL_VALUES[(int)val];
        }
        return new TBigInteger(1, val);
    }

    public byte[] toByteArray() {
        int highBytes;
        if (this.sign == 0) {
            return new byte[]{0};
        }
        TBigInteger temp = this;
        int bitLen = this.bitLength();
        int iThis = this.getFirstNonzeroDigit();
        int bytesLen = (bitLen >> 3) + 1;
        byte[] bytes = new byte[bytesLen];
        int firstByteNumber = 0;
        int digitIndex = 0;
        int bytesInInteger = 4;
        if (bytesLen - (this.numberLength << 2) == 1) {
            bytes[0] = (byte)(this.sign < 0 ? -1 : 0);
            highBytes = 4;
            ++firstByteNumber;
        } else {
            int hB = bytesLen & 3;
            highBytes = hB == 0 ? 4 : hB;
        }
        digitIndex = iThis;
        bytesLen -= iThis << 2;
        if (this.sign < 0) {
            int digit = -temp.digits[digitIndex];
            if (++digitIndex == this.numberLength) {
                bytesInInteger = highBytes;
            }
            int i = 0;
            while (i < bytesInInteger) {
                bytes[--bytesLen] = (byte)digit;
                ++i;
                digit >>= 8;
            }
            while (bytesLen > firstByteNumber) {
                digit = ~temp.digits[digitIndex];
                if (++digitIndex == this.numberLength) {
                    bytesInInteger = highBytes;
                }
                i = 0;
                while (i < bytesInInteger) {
                    bytes[--bytesLen] = (byte)digit;
                    ++i;
                    digit >>= 8;
                }
            }
        } else {
            while (bytesLen > firstByteNumber) {
                int digit = temp.digits[digitIndex];
                if (++digitIndex == this.numberLength) {
                    bytesInInteger = highBytes;
                }
                int i = 0;
                while (i < bytesInInteger) {
                    bytes[--bytesLen] = (byte)digit;
                    ++i;
                    digit >>= 8;
                }
            }
        }
        return bytes;
    }

    private static void setFromString(TBigInteger bi, String val, int radix) {
        int startChar;
        int sign;
        int stringLength = val.length();
        int endChar = stringLength--;
        if (val.charAt(0) == '-') {
            sign = -1;
            startChar = 1;
        } else {
            sign = 1;
            startChar = 0;
        }
        int charsPerInt = TConversion.digitFitInInt[radix];
        int bigRadixDigitsLength = stringLength / charsPerInt;
        int topChars = stringLength % charsPerInt;
        if (topChars != 0) {
            ++bigRadixDigitsLength;
        }
        int[] digits = new int[bigRadixDigitsLength];
        int bigRadix = TConversion.bigRadices[radix - 2];
        int digitIndex = 0;
        int substrEnd = startChar + (topChars == 0 ? charsPerInt : topChars);
        int substrStart = startChar;
        while (substrStart < endChar) {
            int bigRadixDigit = Integer.parseInt(val.substring(substrStart, substrEnd), radix);
            int newDigit = TMultiplication.multiplyByInt(digits, digitIndex, bigRadix);
            digits[digitIndex++] = newDigit += TElementary.inplaceAdd(digits, digitIndex, bigRadixDigit);
            substrStart = substrEnd;
            substrEnd = substrStart + charsPerInt;
        }
        int numberLength = digitIndex;
        bi.sign = sign;
        bi.numberLength = numberLength;
        bi.digits = digits;
        bi.cutOffLeadingZeroes();
    }

    public TBigInteger abs() {
        return this.sign < 0 ? new TBigInteger(1, this.numberLength, this.digits) : this;
    }

    public TBigInteger negate() {
        return this.sign == 0 ? this : new TBigInteger(-this.sign, this.numberLength, this.digits);
    }

    public TBigInteger add(TBigInteger val) {
        return TElementary.add(this, val);
    }

    public TBigInteger subtract(TBigInteger val) {
        return TElementary.subtract(this, val);
    }

    public int signum() {
        return this.sign;
    }

    public TBigInteger shiftRight(int n) {
        if (n == 0 || this.sign == 0) {
            return this;
        }
        return n > 0 ? TBitLevel.shiftRight(this, n) : TBitLevel.shiftLeft(this, -n);
    }

    public TBigInteger shiftLeft(int n) {
        if (n == 0 || this.sign == 0) {
            return this;
        }
        return n > 0 ? TBitLevel.shiftLeft(this, n) : TBitLevel.shiftRight(this, -n);
    }

    TBigInteger shiftLeftOneBit() {
        return this.sign == 0 ? this : TBitLevel.shiftLeftOneBit(this);
    }

    public int bitLength() {
        return TBitLevel.bitLength(this);
    }

    public boolean testBit(int n) {
        if (n == 0) {
            return (this.digits[0] & 1) != 0;
        }
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int intCount = n >> 5;
        if (intCount >= this.numberLength) {
            return this.sign < 0;
        }
        int digit = this.digits[intCount];
        n = 1 << (n & 0x1F);
        if (this.sign < 0) {
            int firstNonZeroDigit = this.getFirstNonzeroDigit();
            if (intCount < firstNonZeroDigit) {
                return false;
            }
            digit = firstNonZeroDigit == intCount ? -digit : (digit ^= 0xFFFFFFFF);
        }
        return (digit & n) != 0;
    }

    public TBigInteger setBit(int n) {
        if (!this.testBit(n)) {
            return TBitLevel.flipBit(this, n);
        }
        return this;
    }

    public TBigInteger clearBit(int n) {
        if (this.testBit(n)) {
            return TBitLevel.flipBit(this, n);
        }
        return this;
    }

    public TBigInteger flipBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        return TBitLevel.flipBit(this, n);
    }

    public int getLowestSetBit() {
        if (this.sign == 0) {
            return -1;
        }
        int i = this.getFirstNonzeroDigit();
        return (i << 5) + Integer.numberOfTrailingZeros(this.digits[i]);
    }

    public int bitCount() {
        return TBitLevel.bitCount(this);
    }

    public TBigInteger not() {
        return TLogical.not(this);
    }

    public TBigInteger and(TBigInteger val) {
        return TLogical.and(this, val);
    }

    public TBigInteger or(TBigInteger val) {
        return TLogical.or(this, val);
    }

    public TBigInteger xor(TBigInteger val) {
        return TLogical.xor(this, val);
    }

    public TBigInteger andNot(TBigInteger val) {
        return TLogical.andNot(this, val);
    }

    @Override
    public int intValue() {
        return this.sign * this.digits[0];
    }

    @Override
    public long longValue() {
        long value = this.numberLength > 1 ? (long)this.digits[1] << 32 | (long)this.digits[0] & 0xFFFFFFFFL : (long)this.digits[0] & 0xFFFFFFFFL;
        return (long)this.sign * value;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        return TConversion.bigInteger2Double(this);
    }

    @Override
    public int compareTo(TBigInteger val) {
        if (this.sign > val.sign) {
            return 1;
        }
        if (this.sign < val.sign) {
            return -1;
        }
        if (this.numberLength > val.numberLength) {
            return this.sign;
        }
        if (this.numberLength < val.numberLength) {
            return -val.sign;
        }
        return this.sign * TElementary.compareArrays(this.digits, val.digits, this.numberLength);
    }

    public TBigInteger min(TBigInteger val) {
        return this.compareTo(val) == -1 ? this : val;
    }

    public TBigInteger max(TBigInteger val) {
        return this.compareTo(val) == 1 ? this : val;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        for (int i = 0; i < this.digits.length; ++i) {
            this.hashCode = this.hashCode * 33 + this.digits[i];
        }
        this.hashCode *= this.sign;
        return this.hashCode;
    }

    public boolean equals(Object x) {
        if (this == x) {
            return true;
        }
        if (x instanceof TBigInteger) {
            TBigInteger x1 = (TBigInteger)x;
            return this.sign == x1.sign && this.numberLength == x1.numberLength && this.equalsArrays(x1.digits);
        }
        return false;
    }

    boolean equalsArrays(int[] b) {
        int i;
        for (i = this.numberLength - 1; i >= 0 && this.digits[i] == b[i]; --i) {
        }
        return i < 0;
    }

    public String toString() {
        return TConversion.toDecimalScaledString(this, 0);
    }

    public String toString(int radix) {
        return TConversion.bigInteger2String(this, radix);
    }

    public TBigInteger gcd(TBigInteger val) {
        TBigInteger val1 = this.abs();
        TBigInteger val2 = val.abs();
        if (val1.signum() == 0) {
            return val2;
        }
        if (val2.signum() == 0) {
            return val1;
        }
        if ((val1.numberLength == 1 || val1.numberLength == 2 && val1.digits[1] > 0) && (val2.numberLength == 1 || val2.numberLength == 2 && val2.digits[1] > 0)) {
            return TBigInteger.valueOf(TDivision.gcdBinary(val1.longValue(), val2.longValue()));
        }
        return TDivision.gcdBinary(val1.copy(), val2.copy());
    }

    public TBigInteger multiply(TBigInteger val) {
        if (val.sign == 0) {
            return ZERO;
        }
        if (this.sign == 0) {
            return ZERO;
        }
        return TMultiplication.multiply(this, val);
    }

    public TBigInteger pow(int exp) {
        if (exp < 0) {
            throw new ArithmeticException("Negative exponent");
        }
        if (exp == 0) {
            return ONE;
        }
        if (exp == 1 || this.equals(ONE) || this.equals(ZERO)) {
            return this;
        }
        if (!this.testBit(0)) {
            int x = 1;
            while (!this.testBit(x)) {
                ++x;
            }
            return TBigInteger.getPowerOfTwo(x * exp).multiply(this.shiftRight(x).pow(exp));
        }
        return TMultiplication.pow(this, exp);
    }

    public TBigInteger[] divideAndRemainder(TBigInteger divisor) {
        int cmp;
        int divisorSign = divisor.sign;
        if (divisorSign == 0) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        int divisorLen = divisor.numberLength;
        int[] divisorDigits = divisor.digits;
        if (divisorLen == 1) {
            return TDivision.divideAndRemainderByInteger(this, divisorDigits[0], divisorSign);
        }
        int[] thisDigits = this.digits;
        int thisLen = this.numberLength;
        int n = thisLen != divisorLen ? (thisLen > divisorLen ? 1 : -1) : (cmp = TElementary.compareArrays(thisDigits, divisorDigits, thisLen));
        if (cmp < 0) {
            return new TBigInteger[]{ZERO, this};
        }
        int thisSign = this.sign;
        int quotientLength = thisLen - divisorLen + 1;
        int remainderLength = divisorLen;
        int quotientSign = thisSign == divisorSign ? 1 : -1;
        int[] quotientDigits = new int[quotientLength];
        int[] remainderDigits = TDivision.divide(quotientDigits, quotientLength, thisDigits, thisLen, divisorDigits, divisorLen);
        TBigInteger result0 = new TBigInteger(quotientSign, quotientLength, quotientDigits);
        TBigInteger result1 = new TBigInteger(thisSign, remainderLength, remainderDigits);
        result0.cutOffLeadingZeroes();
        result1.cutOffLeadingZeroes();
        return new TBigInteger[]{result0, result1};
    }

    public TBigInteger divide(TBigInteger divisor) {
        int resSign;
        int cmp;
        if (divisor.sign == 0) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        int divisorSign = divisor.sign;
        if (divisor.isOne()) {
            return divisor.sign > 0 ? this : this.negate();
        }
        int thisSign = this.sign;
        int thisLen = this.numberLength;
        int divisorLen = divisor.numberLength;
        if (thisLen + divisorLen == 2) {
            long val = ((long)this.digits[0] & 0xFFFFFFFFL) / ((long)divisor.digits[0] & 0xFFFFFFFFL);
            if (thisSign != divisorSign) {
                val = -val;
            }
            return TBigInteger.valueOf(val);
        }
        int n = thisLen != divisorLen ? (thisLen > divisorLen ? 1 : -1) : (cmp = TElementary.compareArrays(this.digits, divisor.digits, thisLen));
        if (cmp == 0) {
            return thisSign == divisorSign ? ONE : MINUS_ONE;
        }
        if (cmp == -1) {
            return ZERO;
        }
        int resLength = thisLen - divisorLen + 1;
        int[] resDigits = new int[resLength];
        int n2 = resSign = thisSign == divisorSign ? 1 : -1;
        if (divisorLen == 1) {
            TDivision.divideArrayByInt(resDigits, this.digits, thisLen, divisor.digits[0]);
        } else {
            TDivision.divide(resDigits, resLength, this.digits, thisLen, divisor.digits, divisorLen);
        }
        TBigInteger result = new TBigInteger(resSign, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    public TBigInteger remainder(TBigInteger divisor) {
        if (divisor.sign == 0) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        int thisLen = this.numberLength;
        int divisorLen = divisor.numberLength;
        if ((thisLen != divisorLen ? (thisLen > divisorLen ? 1 : -1) : TElementary.compareArrays(this.digits, divisor.digits, thisLen)) == -1) {
            return this;
        }
        int resLength = divisorLen;
        int[] resDigits = new int[resLength];
        if (resLength == 1) {
            resDigits[0] = TDivision.remainderArrayByInt(this.digits, thisLen, divisor.digits[0]);
        } else {
            int qLen = thisLen - divisorLen + 1;
            resDigits = TDivision.divide(null, qLen, this.digits, thisLen, divisor.digits, divisorLen);
        }
        TBigInteger result = new TBigInteger(this.sign, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    public TBigInteger modInverse(TBigInteger m) {
        if (m.sign <= 0) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        if (!this.testBit(0) && !m.testBit(0)) {
            throw new ArithmeticException("BigInteger not invertible.");
        }
        if (m.isOne()) {
            return ZERO;
        }
        TBigInteger res = TDivision.modInverseMontgomery(this.abs().mod(m), m);
        if (res.sign == 0) {
            throw new ArithmeticException("BigInteger not invertible.");
        }
        res = this.sign < 0 ? m.subtract(res) : res;
        return res;
    }

    public TBigInteger modPow(TBigInteger exponent, TBigInteger m) {
        TBigInteger res;
        if (m.sign <= 0) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        TBigInteger base = this;
        if (m.isOne() | exponent.sign > 0 & base.sign == 0) {
            return ZERO;
        }
        if (exponent.sign == 0) {
            return ONE.mod(m);
        }
        if (exponent.sign < 0) {
            base = this.modInverse(m);
            exponent = exponent.negate();
        }
        TBigInteger tBigInteger = res = m.testBit(0) ? TDivision.oddModPow(base.abs(), exponent, m) : TDivision.evenModPow(base.abs(), exponent, m);
        if (base.sign < 0 && exponent.testBit(0)) {
            res = m.subtract(ONE).multiply(res).mod(m);
        }
        return res;
    }

    public TBigInteger mod(TBigInteger m) {
        if (m.sign <= 0) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        TBigInteger rem = this.remainder(m);
        return rem.sign < 0 ? rem.add(m) : rem;
    }

    public boolean isProbablePrime(int certainty) {
        return TPrimality.isProbablePrime(this.abs(), certainty);
    }

    public TBigInteger nextProbablePrime() {
        if (this.sign < 0) {
            throw new ArithmeticException("start < 0: " + this);
        }
        return TPrimality.nextProbablePrime(this);
    }

    public static TBigInteger probablePrime(int bitLength, Random rnd) {
        return new TBigInteger(bitLength, 100, rnd);
    }

    final void cutOffLeadingZeroes() {
        while (this.numberLength > 0 && this.digits[--this.numberLength] == 0) {
        }
        if (this.digits[this.numberLength++] == 0) {
            this.sign = 0;
        }
    }

    boolean isOne() {
        return this.numberLength == 1 && this.digits[0] == 1;
    }

    private void putBytesPositiveToIntegers(byte[] byteValues) {
        int bytesLen;
        int highBytes = (bytesLen = byteValues.length) & 3;
        this.numberLength = (bytesLen >> 2) + (highBytes == 0 ? 0 : 1);
        this.digits = new int[this.numberLength];
        int i = 0;
        while (bytesLen > highBytes) {
            this.digits[i++] = byteValues[--bytesLen] & 0xFF | (byteValues[--bytesLen] & 0xFF) << 8 | (byteValues[--bytesLen] & 0xFF) << 16 | (byteValues[--bytesLen] & 0xFF) << 24;
        }
        for (int j = 0; j < bytesLen; ++j) {
            this.digits[i] = this.digits[i] << 8 | byteValues[j] & 0xFF;
        }
    }

    private void putBytesNegativeToIntegers(byte[] byteValues) {
        int bytesLen;
        int highBytes = (bytesLen = byteValues.length) & 3;
        this.numberLength = (bytesLen >> 2) + (highBytes == 0 ? 0 : 1);
        this.digits = new int[this.numberLength];
        int i = 0;
        this.digits[this.numberLength - 1] = -1;
        while (bytesLen > highBytes) {
            this.digits[i] = byteValues[--bytesLen] & 0xFF | (byteValues[--bytesLen] & 0xFF) << 8 | (byteValues[--bytesLen] & 0xFF) << 16 | (byteValues[--bytesLen] & 0xFF) << 24;
            if (this.digits[i] != 0) {
                this.digits[i] = -this.digits[i];
                this.firstNonzeroDigit = i++;
                while (bytesLen > highBytes) {
                    this.digits[i] = byteValues[--bytesLen] & 0xFF | (byteValues[--bytesLen] & 0xFF) << 8 | (byteValues[--bytesLen] & 0xFF) << 16 | (byteValues[--bytesLen] & 0xFF) << 24;
                    this.digits[i] = ~this.digits[i];
                    ++i;
                }
                break;
            }
            ++i;
        }
        if (highBytes != 0) {
            if (this.firstNonzeroDigit != -2) {
                for (int j = 0; j < bytesLen; ++j) {
                    this.digits[i] = this.digits[i] << 8 | byteValues[j] & 0xFF;
                }
                this.digits[i] = ~this.digits[i];
            } else {
                for (int j = 0; j < bytesLen; ++j) {
                    this.digits[i] = this.digits[i] << 8 | byteValues[j] & 0xFF;
                }
                this.digits[i] = -this.digits[i];
            }
        }
    }

    int getFirstNonzeroDigit() {
        if (this.firstNonzeroDigit == -2) {
            int i;
            if (this.sign == 0) {
                i = -1;
            } else {
                i = 0;
                while (this.digits[i] == 0) {
                    ++i;
                }
            }
            this.firstNonzeroDigit = i;
        }
        return this.firstNonzeroDigit;
    }

    TBigInteger copy() {
        int[] copyDigits = new int[this.numberLength];
        System.arraycopy(this.digits, 0, copyDigits, 0, this.numberLength);
        return new TBigInteger(this.sign, this.numberLength, copyDigits);
    }

    void unCache() {
        this.firstNonzeroDigit = -2;
    }

    static TBigInteger getPowerOfTwo(int exp) {
        if (exp < TWO_POWS.length) {
            return TWO_POWS[exp];
        }
        int intCount = exp >> 5;
        int bitN = exp & 0x1F;
        int[] resDigits = new int[intCount + 1];
        resDigits[intCount] = 1 << bitN;
        return new TBigInteger(1, intCount + 1, resDigits);
    }

    static {
        for (int i = 0; i < TWO_POWS.length; ++i) {
            TBigInteger.TWO_POWS[i] = TBigInteger.valueOf(1L << i);
        }
    }
}

