/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.math;

import com.antgroup.antchain.myjava.classlib.java.lang.TMath;
import com.antgroup.antchain.myjava.classlib.java.math.TBigInteger;
import com.antgroup.antchain.myjava.classlib.java.math.TConversion;
import com.antgroup.antchain.myjava.classlib.java.math.TMathContext;
import com.antgroup.antchain.myjava.classlib.java.math.TMultiplication;
import com.antgroup.antchain.myjava.classlib.java.math.TRoundingMode;
import java.io.Serializable;

public class TBigDecimal
extends Number
implements Comparable<TBigDecimal>,
Serializable {
    public static final TBigDecimal ZERO;
    public static final TBigDecimal ONE;
    public static final TBigDecimal TEN;
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    private static final long serialVersionUID = 6108874887143696463L;
    private static final double LOG10_2 = 0.3010299956639812;
    private transient String toStringImage;
    private transient int hashCode;
    private static final TBigInteger[] FIVE_POW;
    private static final TBigInteger[] TEN_POW;
    private static final long[] LONG_TEN_POW;
    private static final long[] LONG_FIVE_POW;
    private static final int[] LONG_FIVE_POW_BIT_LENGTH;
    private static final int[] LONG_TEN_POW_BIT_LENGTH;
    private static final int BI_SCALED_BY_ZERO_LENGTH = 11;
    private static final TBigDecimal[] BI_SCALED_BY_ZERO;
    private static final TBigDecimal[] ZERO_SCALED_BY;
    private static final char[] CH_ZEROS;
    private TBigInteger intVal;
    private transient int bitLength;
    private transient long smallValue;
    private int scale;
    private transient int precision;

    private TBigDecimal(long smallValue, int scale) {
        this.smallValue = smallValue;
        this.scale = scale;
        this.bitLength = TBigDecimal.bitLength(smallValue);
    }

    private TBigDecimal(int smallValue, int scale) {
        this.smallValue = smallValue;
        this.scale = scale;
        this.bitLength = TBigDecimal.bitLength(smallValue);
    }

    public TBigDecimal(char[] in, int offset, int len) {
        int begin = offset;
        int last = offset + (len - 1);
        String scaleString = null;
        if (in == null) {
            throw new NullPointerException();
        }
        if (last >= in.length || offset < 0 || len <= 0 || last < 0) {
            throw new NumberFormatException();
        }
        StringBuilder unscaledBuffer = new StringBuilder(len);
        int bufLength = 0;
        if (offset <= last && in[offset] == '+') {
            ++offset;
            ++begin;
        }
        int counter = 0;
        boolean wasNonZero = false;
        while (offset <= last && in[offset] != '.' && in[offset] != 'e' && in[offset] != 'E') {
            if (!wasNonZero) {
                if (in[offset] == '0') {
                    ++counter;
                } else {
                    wasNonZero = true;
                }
            }
            ++offset;
        }
        unscaledBuffer.append(in, begin, offset - begin);
        bufLength += offset - begin;
        if (offset <= last && in[offset] == '.') {
            begin = ++offset;
            while (offset <= last && in[offset] != 'e' && in[offset] != 'E') {
                if (!wasNonZero) {
                    if (in[offset] == '0') {
                        ++counter;
                    } else {
                        wasNonZero = true;
                    }
                }
                ++offset;
            }
            this.scale = offset - begin;
            bufLength += this.scale;
            unscaledBuffer.append(in, begin, this.scale);
        } else {
            this.scale = 0;
        }
        if (offset <= last && (in[offset] == 'e' || in[offset] == 'E')) {
            begin = ++offset;
            if (offset <= last && in[offset] == '+' && ++offset <= last && in[offset] != '-') {
                ++begin;
            }
            scaleString = String.valueOf(in, begin, last + 1 - begin);
            long newScale = (long)this.scale - (long)Integer.parseInt(scaleString);
            this.scale = (int)newScale;
            if (newScale != (long)this.scale) {
                throw new NumberFormatException("Scale out of range.");
            }
        }
        if (bufLength < 19) {
            this.smallValue = Long.parseLong(unscaledBuffer.toString());
            this.bitLength = TBigDecimal.bitLength(this.smallValue);
        } else {
            this.setUnscaledValue(new TBigInteger(unscaledBuffer.toString()));
        }
        this.precision = unscaledBuffer.length() - counter;
        if (unscaledBuffer.charAt(0) == '-') {
            --this.precision;
        }
    }

    public TBigDecimal(char[] in, int offset, int len, TMathContext mc) {
        this(in, offset, len);
        this.inplaceRound(mc);
    }

    public TBigDecimal(char[] in) {
        this(in, 0, in.length);
    }

    public TBigDecimal(char[] in, TMathContext mc) {
        this(in, 0, in.length);
        this.inplaceRound(mc);
    }

    public TBigDecimal(String val) {
        this(val.toCharArray(), 0, val.length());
    }

    public TBigDecimal(String val, TMathContext mc) {
        this(val.toCharArray(), 0, val.length());
        this.inplaceRound(mc);
    }

    public TBigDecimal(double val) {
        long mantisa;
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            throw new NumberFormatException("Infinite or NaN");
        }
        long bits = Double.doubleToLongBits(val);
        this.scale = 1075 - (int)(bits >> 52 & 0x7FFL);
        long l = mantisa = this.scale == 1075 ? (bits & 0xFFFFFFFFFFFFFL) << 1 : bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        if (mantisa == 0L) {
            this.scale = 0;
            this.precision = 1;
        }
        if (this.scale > 0) {
            int trailingZeros = Math.min(this.scale, Long.numberOfTrailingZeros(mantisa));
            mantisa >>>= trailingZeros;
            this.scale -= trailingZeros;
        }
        if (bits >> 63 != 0L) {
            mantisa = -mantisa;
        }
        int mantisaBits = TBigDecimal.bitLength(mantisa);
        if (this.scale < 0) {
            int n = this.bitLength = mantisaBits == 0 ? 0 : mantisaBits - this.scale;
            if (this.bitLength < 64) {
                this.smallValue = mantisa << -this.scale;
            } else {
                this.intVal = TBigInteger.valueOf(mantisa).shiftLeft(-this.scale);
            }
            this.scale = 0;
        } else if (this.scale > 0) {
            if (this.scale < LONG_FIVE_POW.length && mantisaBits + LONG_FIVE_POW_BIT_LENGTH[this.scale] < 64) {
                this.smallValue = mantisa * LONG_FIVE_POW[this.scale];
                this.bitLength = TBigDecimal.bitLength(this.smallValue);
            } else {
                this.setUnscaledValue(TMultiplication.multiplyByFivePow(TBigInteger.valueOf(mantisa), this.scale));
            }
        } else {
            this.smallValue = mantisa;
            this.bitLength = mantisaBits;
        }
    }

    public TBigDecimal(double val, TMathContext mc) {
        this(val);
        this.inplaceRound(mc);
    }

    public TBigDecimal(TBigInteger val) {
        this(val, 0);
    }

    public TBigDecimal(TBigInteger val, TMathContext mc) {
        this(val);
        this.inplaceRound(mc);
    }

    public TBigDecimal(TBigInteger unscaledVal, int scale) {
        if (unscaledVal == null) {
            throw new NullPointerException();
        }
        this.scale = scale;
        this.setUnscaledValue(unscaledVal);
    }

    public TBigDecimal(TBigInteger unscaledVal, int scale, TMathContext mc) {
        this(unscaledVal, scale);
        this.inplaceRound(mc);
    }

    public TBigDecimal(int val) {
        this(val, 0);
    }

    public TBigDecimal(int val, TMathContext mc) {
        this(val, 0);
        this.inplaceRound(mc);
    }

    public TBigDecimal(long val) {
        this(val, 0);
    }

    public TBigDecimal(long val, TMathContext mc) {
        this(val);
        this.inplaceRound(mc);
    }

    public static TBigDecimal valueOf(long unscaledVal, int scale) {
        if (scale == 0) {
            return TBigDecimal.valueOf(unscaledVal);
        }
        if (unscaledVal == 0L && scale >= 0 && scale < ZERO_SCALED_BY.length) {
            return ZERO_SCALED_BY[scale];
        }
        return new TBigDecimal(unscaledVal, scale);
    }

    public static TBigDecimal valueOf(long unscaledVal) {
        if (unscaledVal >= 0L && unscaledVal < 11L) {
            return BI_SCALED_BY_ZERO[(int)unscaledVal];
        }
        return new TBigDecimal(unscaledVal, 0);
    }

    public static TBigDecimal valueOf(double val) {
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            throw new NumberFormatException("Infinity or NaN");
        }
        return new TBigDecimal(Double.toString(val));
    }

    public TBigDecimal add(TBigDecimal augend) {
        int diffScale = this.scale - augend.scale;
        if (this.isZero()) {
            if (diffScale <= 0) {
                return augend;
            }
            if (augend.isZero()) {
                return this;
            }
        } else if (augend.isZero() && diffScale >= 0) {
            return this;
        }
        if (diffScale == 0) {
            if (Math.max(this.bitLength, augend.bitLength) + 1 < 64) {
                return TBigDecimal.valueOf(this.smallValue + augend.smallValue, this.scale);
            }
            return new TBigDecimal(this.getUnscaledValue().add(augend.getUnscaledValue()), this.scale);
        }
        if (diffScale > 0) {
            return TBigDecimal.addAndMult10(this, augend, diffScale);
        }
        return TBigDecimal.addAndMult10(augend, this, -diffScale);
    }

    private static TBigDecimal addAndMult10(TBigDecimal thisValue, TBigDecimal augend, int diffScale) {
        if (diffScale < LONG_TEN_POW.length && Math.max(thisValue.bitLength, augend.bitLength + LONG_TEN_POW_BIT_LENGTH[diffScale]) + 1 < 64) {
            return TBigDecimal.valueOf(thisValue.smallValue + augend.smallValue * LONG_TEN_POW[diffScale], thisValue.scale);
        }
        return new TBigDecimal(thisValue.getUnscaledValue().add(TMultiplication.multiplyByTenPow(augend.getUnscaledValue(), diffScale)), thisValue.scale);
    }

    public TBigDecimal add(TBigDecimal augend, TMathContext mc) {
        TBigInteger tempBI;
        TBigDecimal smaller;
        TBigDecimal larger;
        long diffScale = (long)this.scale - (long)augend.scale;
        if (augend.isZero() || this.isZero() || mc.getPrecision() == 0) {
            return this.add(augend).round(mc);
        }
        if ((long)this.aproxPrecision() < diffScale - 1L) {
            larger = augend;
            smaller = this;
        } else if ((long)augend.aproxPrecision() < -diffScale - 1L) {
            larger = this;
            smaller = augend;
        } else {
            return this.add(augend).round(mc);
        }
        if (mc.getPrecision() >= larger.aproxPrecision()) {
            return this.add(augend).round(mc);
        }
        int largerSignum = larger.signum();
        if (largerSignum == smaller.signum()) {
            tempBI = TMultiplication.multiplyByPositiveInt(larger.getUnscaledValue(), 10).add(TBigInteger.valueOf(largerSignum));
        } else {
            tempBI = larger.getUnscaledValue().subtract(TBigInteger.valueOf(largerSignum));
            tempBI = TMultiplication.multiplyByPositiveInt(tempBI, 10).add(TBigInteger.valueOf(largerSignum * 9));
        }
        larger = new TBigDecimal(tempBI, larger.scale + 1);
        return larger.round(mc);
    }

    public TBigDecimal subtract(TBigDecimal subtrahend) {
        int diffScale = this.scale - subtrahend.scale;
        if (this.isZero()) {
            if (diffScale <= 0) {
                return subtrahend.negate();
            }
            if (subtrahend.isZero()) {
                return this;
            }
        } else if (subtrahend.isZero() && diffScale >= 0) {
            return this;
        }
        if (diffScale == 0) {
            if (Math.max(this.bitLength, subtrahend.bitLength) + 1 < 64) {
                return TBigDecimal.valueOf(this.smallValue - subtrahend.smallValue, this.scale);
            }
            return new TBigDecimal(this.getUnscaledValue().subtract(subtrahend.getUnscaledValue()), this.scale);
        }
        if (diffScale > 0) {
            if (diffScale < LONG_TEN_POW.length && Math.max(this.bitLength, subtrahend.bitLength + LONG_TEN_POW_BIT_LENGTH[diffScale]) + 1 < 64) {
                return TBigDecimal.valueOf(this.smallValue - subtrahend.smallValue * LONG_TEN_POW[diffScale], this.scale);
            }
            return new TBigDecimal(this.getUnscaledValue().subtract(TMultiplication.multiplyByTenPow(subtrahend.getUnscaledValue(), diffScale)), this.scale);
        }
        if ((diffScale = -diffScale) < LONG_TEN_POW.length && Math.max(this.bitLength + LONG_TEN_POW_BIT_LENGTH[diffScale], subtrahend.bitLength) + 1 < 64) {
            return TBigDecimal.valueOf(this.smallValue * LONG_TEN_POW[diffScale] - subtrahend.smallValue, subtrahend.scale);
        }
        return new TBigDecimal(TMultiplication.multiplyByTenPow(this.getUnscaledValue(), diffScale).subtract(subtrahend.getUnscaledValue()), subtrahend.scale);
    }

    public TBigDecimal subtract(TBigDecimal subtrahend, TMathContext mc) {
        long diffScale = (long)subtrahend.scale - (long)this.scale;
        if (subtrahend.isZero() || this.isZero() || mc.getPrecision() == 0) {
            return this.subtract(subtrahend).round(mc);
        }
        if ((long)subtrahend.aproxPrecision() < diffScale - 1L && mc.getPrecision() < this.aproxPrecision()) {
            TBigInteger tempBI;
            int thisSignum = this.signum();
            if (thisSignum != subtrahend.signum()) {
                tempBI = TMultiplication.multiplyByPositiveInt(this.getUnscaledValue(), 10).add(TBigInteger.valueOf(thisSignum));
            } else {
                tempBI = this.getUnscaledValue().subtract(TBigInteger.valueOf(thisSignum));
                tempBI = TMultiplication.multiplyByPositiveInt(tempBI, 10).add(TBigInteger.valueOf(thisSignum * 9));
            }
            TBigDecimal leftOperand = new TBigDecimal(tempBI, this.scale + 1);
            return leftOperand.round(mc);
        }
        return this.subtract(subtrahend).round(mc);
    }

    public TBigDecimal multiply(TBigDecimal multiplicand) {
        long newScale = (long)this.scale + (long)multiplicand.scale;
        if (this.isZero() || multiplicand.isZero()) {
            return TBigDecimal.zeroScaledBy(newScale);
        }
        if (this.bitLength + multiplicand.bitLength < 64) {
            return TBigDecimal.valueOf(this.smallValue * multiplicand.smallValue, TBigDecimal.toIntScale(newScale));
        }
        return new TBigDecimal(this.getUnscaledValue().multiply(multiplicand.getUnscaledValue()), TBigDecimal.toIntScale(newScale));
    }

    public TBigDecimal multiply(TBigDecimal multiplicand, TMathContext mc) {
        TBigDecimal result = this.multiply(multiplicand);
        result.inplaceRound(mc);
        return result;
    }

    public TBigDecimal divide(TBigDecimal divisor, int scale, int roundingMode) {
        return this.divide(divisor, scale, TRoundingMode.valueOf(roundingMode));
    }

    public TBigDecimal divide(TBigDecimal divisor, int scale, TRoundingMode roundingMode) {
        if (roundingMode == null) {
            throw new NullPointerException();
        }
        if (divisor.isZero()) {
            throw new ArithmeticException("Division by zero");
        }
        long diffScale = (long)this.scale - (long)divisor.scale - (long)scale;
        if (this.bitLength < 64 && divisor.bitLength < 64) {
            if (diffScale == 0L) {
                return TBigDecimal.dividePrimitiveLongs(this.smallValue, divisor.smallValue, scale, roundingMode);
            }
            if (diffScale > 0L) {
                if (diffScale < (long)LONG_TEN_POW.length && divisor.bitLength + LONG_TEN_POW_BIT_LENGTH[(int)diffScale] < 64) {
                    return TBigDecimal.dividePrimitiveLongs(this.smallValue, divisor.smallValue * LONG_TEN_POW[(int)diffScale], scale, roundingMode);
                }
            } else if (-diffScale < (long)LONG_TEN_POW.length && this.bitLength + LONG_TEN_POW_BIT_LENGTH[(int)(-diffScale)] < 64) {
                return TBigDecimal.dividePrimitiveLongs(this.smallValue * LONG_TEN_POW[(int)(-diffScale)], divisor.smallValue, scale, roundingMode);
            }
        }
        TBigInteger scaledDividend = this.getUnscaledValue();
        TBigInteger scaledDivisor = divisor.getUnscaledValue();
        if (diffScale > 0L) {
            scaledDivisor = TMultiplication.multiplyByTenPow(scaledDivisor, (int)diffScale);
        } else if (diffScale < 0L) {
            scaledDividend = TMultiplication.multiplyByTenPow(scaledDividend, (int)(-diffScale));
        }
        return TBigDecimal.divideBigIntegers(scaledDividend, scaledDivisor, scale, roundingMode);
    }

    private static TBigDecimal divideBigIntegers(TBigInteger scaledDividend, TBigInteger scaledDivisor, int scale, TRoundingMode roundingMode) {
        int compRem;
        TBigInteger[] quotAndRem = scaledDividend.divideAndRemainder(scaledDivisor);
        TBigInteger quotient = quotAndRem[0];
        TBigInteger remainder = quotAndRem[1];
        if (remainder.signum() == 0) {
            return new TBigDecimal(quotient, scale);
        }
        int sign = scaledDividend.signum() * scaledDivisor.signum();
        if (scaledDivisor.bitLength() < 63) {
            long rem = remainder.longValue();
            long divisor = scaledDivisor.longValue();
            compRem = TBigDecimal.longCompareTo(Math.abs(rem) << 1, Math.abs(divisor));
            compRem = TBigDecimal.roundingBehavior(quotient.testBit(0) ? 1 : 0, sign * (5 + compRem), roundingMode);
        } else {
            compRem = remainder.abs().shiftLeftOneBit().compareTo(scaledDivisor.abs());
            compRem = TBigDecimal.roundingBehavior(quotient.testBit(0) ? 1 : 0, sign * (5 + compRem), roundingMode);
        }
        if (compRem != 0) {
            if (quotient.bitLength() < 63) {
                return TBigDecimal.valueOf(quotient.longValue() + (long)compRem, scale);
            }
            quotient = quotient.add(TBigInteger.valueOf(compRem));
            return new TBigDecimal(quotient, scale);
        }
        return new TBigDecimal(quotient, scale);
    }

    private static TBigDecimal dividePrimitiveLongs(long scaledDividend, long scaledDivisor, int scale, TRoundingMode roundingMode) {
        long quotient = scaledDividend / scaledDivisor;
        long remainder = scaledDividend % scaledDivisor;
        int sign = Long.signum(scaledDividend) * Long.signum(scaledDivisor);
        if (remainder != 0L) {
            int compRem = TBigDecimal.longCompareTo(Math.abs(remainder) << 1, Math.abs(scaledDivisor));
            quotient += (long)TBigDecimal.roundingBehavior((int)quotient & 1, sign * (5 + compRem), roundingMode);
        }
        return TBigDecimal.valueOf(quotient, scale);
    }

    public TBigDecimal divide(TBigDecimal divisor, int roundingMode) {
        return this.divide(divisor, this.scale, TRoundingMode.valueOf(roundingMode));
    }

    public TBigDecimal divide(TBigDecimal divisor, TRoundingMode roundingMode) {
        return this.divide(divisor, this.scale, roundingMode);
    }

    public TBigDecimal divide(TBigDecimal divisor) {
        TBigInteger p = this.getUnscaledValue();
        TBigInteger q = divisor.getUnscaledValue();
        long diffScale = (long)this.scale - (long)divisor.scale;
        int l = 0;
        int i = 1;
        int lastPow = FIVE_POW.length - 1;
        if (divisor.isZero()) {
            throw new ArithmeticException("Division by zero");
        }
        if (p.signum() == 0) {
            return TBigDecimal.zeroScaledBy(diffScale);
        }
        TBigInteger gcd = p.gcd(q);
        p = p.divide(gcd);
        q = q.divide(gcd);
        int k = q.getLowestSetBit();
        q = q.shiftRight(k);
        while (true) {
            TBigInteger[] quotAndRem;
            if ((quotAndRem = q.divideAndRemainder(FIVE_POW[i]))[1].signum() == 0) {
                l += i;
                if (i < lastPow) {
                    ++i;
                }
                q = quotAndRem[0];
                continue;
            }
            if (i == 1) break;
            i = 1;
        }
        if (!q.abs().equals(TBigInteger.ONE)) {
            throw new ArithmeticException("Non-terminating decimal expansion; no exact representable decimal result.");
        }
        if (q.signum() < 0) {
            p = p.negate();
        }
        int newScale = TBigDecimal.toIntScale(diffScale + (long)Math.max(k, l));
        i = k - l;
        p = i > 0 ? TMultiplication.multiplyByFivePow(p, i) : p.shiftLeft(-i);
        return new TBigDecimal(p, newScale);
    }

    public TBigDecimal divide(TBigDecimal divisor, TMathContext mc) {
        long diffScale;
        long traillingZeros = (long)mc.getPrecision() + 2L + (long)divisor.aproxPrecision() - (long)this.aproxPrecision();
        long newScale = diffScale = (long)this.scale - (long)divisor.scale;
        int i = 1;
        int lastPow = TEN_POW.length - 1;
        TBigInteger[] quotAndRem = new TBigInteger[]{this.getUnscaledValue()};
        if (mc.getPrecision() == 0 || this.isZero() || divisor.isZero()) {
            return this.divide(divisor);
        }
        if (traillingZeros > 0L) {
            quotAndRem[0] = this.getUnscaledValue().multiply(TMultiplication.powerOf10(traillingZeros));
            newScale += traillingZeros;
        }
        quotAndRem = quotAndRem[0].divideAndRemainder(divisor.getUnscaledValue());
        TBigInteger integerQuot = quotAndRem[0];
        if (quotAndRem[1].signum() != 0) {
            int compRem = quotAndRem[1].shiftLeftOneBit().compareTo(divisor.getUnscaledValue());
            integerQuot = integerQuot.multiply(TBigInteger.TEN).add(TBigInteger.valueOf(quotAndRem[0].signum() * (5 + compRem)));
            ++newScale;
        } else {
            while (!integerQuot.testBit(0)) {
                quotAndRem = integerQuot.divideAndRemainder(TEN_POW[i]);
                if (quotAndRem[1].signum() == 0 && newScale - (long)i >= diffScale) {
                    newScale -= (long)i;
                    if (i < lastPow) {
                        ++i;
                    }
                    integerQuot = quotAndRem[0];
                    continue;
                }
                if (i == 1) break;
                i = 1;
            }
        }
        return new TBigDecimal(integerQuot, TBigDecimal.toIntScale(newScale), mc);
    }

    public TBigDecimal divideToIntegralValue(TBigDecimal divisor) {
        TBigInteger integralValue;
        TBigInteger[] quotAndRem = new TBigInteger[]{this.getUnscaledValue()};
        long newScale = (long)this.scale - (long)divisor.scale;
        long tempScale = 0L;
        int i = 1;
        int lastPow = TEN_POW.length - 1;
        if (divisor.isZero()) {
            throw new ArithmeticException("Division by zero");
        }
        if ((long)divisor.aproxPrecision() + newScale > (long)this.aproxPrecision() + 1L || this.isZero()) {
            integralValue = TBigInteger.ZERO;
        } else if (newScale == 0L) {
            integralValue = this.getUnscaledValue().divide(divisor.getUnscaledValue());
        } else if (newScale > 0L) {
            TBigInteger powerOfTen = TMultiplication.powerOf10(newScale);
            integralValue = this.getUnscaledValue().divide(divisor.getUnscaledValue().multiply(powerOfTen));
            integralValue = integralValue.multiply(powerOfTen);
        } else {
            TBigInteger powerOfTen = TMultiplication.powerOf10(-newScale);
            integralValue = this.getUnscaledValue().multiply(powerOfTen).divide(divisor.getUnscaledValue());
            while (!integralValue.testBit(0)) {
                quotAndRem = integralValue.divideAndRemainder(TEN_POW[i]);
                if (quotAndRem[1].signum() == 0 && tempScale - (long)i >= newScale) {
                    tempScale -= (long)i;
                    if (i < lastPow) {
                        ++i;
                    }
                    integralValue = quotAndRem[0];
                    continue;
                }
                if (i == 1) break;
                i = 1;
            }
            newScale = tempScale;
        }
        return integralValue.signum() == 0 ? TBigDecimal.zeroScaledBy(newScale) : new TBigDecimal(integralValue, TBigDecimal.toIntScale(newScale));
    }

    public TBigDecimal divideToIntegralValue(TBigDecimal divisor, TMathContext mc) {
        long diffScale;
        int mcPrecision = mc.getPrecision();
        int diffPrecision = this.precision() - divisor.precision();
        int lastPow = TEN_POW.length - 1;
        long newScale = diffScale = (long)this.scale - (long)divisor.scale;
        long quotPrecision = (long)diffPrecision - diffScale + 1L;
        TBigInteger[] quotAndRem = new TBigInteger[2];
        if (mcPrecision == 0 || this.isZero() || divisor.isZero()) {
            return this.divideToIntegralValue(divisor);
        }
        if (quotPrecision <= 0L) {
            quotAndRem[0] = TBigInteger.ZERO;
        } else if (diffScale == 0L) {
            quotAndRem[0] = this.getUnscaledValue().divide(divisor.getUnscaledValue());
        } else if (diffScale > 0L) {
            quotAndRem[0] = this.getUnscaledValue().divide(divisor.getUnscaledValue().multiply(TMultiplication.powerOf10(diffScale)));
            newScale = Math.min(diffScale, Math.max((long)mcPrecision - quotPrecision + 1L, 0L));
            quotAndRem[0] = quotAndRem[0].multiply(TMultiplication.powerOf10(newScale));
        } else {
            long exp = Math.min(-diffScale, Math.max((long)mcPrecision - (long)diffPrecision, 0L));
            quotAndRem = this.getUnscaledValue().multiply(TMultiplication.powerOf10(exp)).divideAndRemainder(divisor.getUnscaledValue());
            newScale += exp;
            exp = -newScale;
            if (quotAndRem[1].signum() != 0 && exp > 0L) {
                long compRemDiv = (long)new TBigDecimal(quotAndRem[1]).precision() + exp - (long)divisor.precision();
                if (compRemDiv == 0L) {
                    quotAndRem[1] = quotAndRem[1].multiply(TMultiplication.powerOf10(exp)).divide(divisor.getUnscaledValue());
                    compRemDiv = Math.abs(quotAndRem[1].signum());
                }
                if (compRemDiv > 0L) {
                    throw new ArithmeticException("Division impossible");
                }
            }
        }
        if (quotAndRem[0].signum() == 0) {
            return TBigDecimal.zeroScaledBy(diffScale);
        }
        TBigInteger strippedBI = quotAndRem[0];
        TBigDecimal integralValue = new TBigDecimal(quotAndRem[0]);
        long resultPrecision = integralValue.precision();
        int i = 1;
        while (!strippedBI.testBit(0)) {
            quotAndRem = strippedBI.divideAndRemainder(TEN_POW[i]);
            if (quotAndRem[1].signum() == 0 && (resultPrecision - (long)i >= (long)mcPrecision || newScale - (long)i >= diffScale)) {
                resultPrecision -= (long)i;
                newScale -= (long)i;
                if (i < lastPow) {
                    ++i;
                }
                strippedBI = quotAndRem[0];
                continue;
            }
            if (i == 1) break;
            i = 1;
        }
        if (resultPrecision > (long)mcPrecision) {
            throw new ArithmeticException("Division impossible");
        }
        integralValue.scale = TBigDecimal.toIntScale(newScale);
        integralValue.setUnscaledValue(strippedBI);
        return integralValue;
    }

    public TBigDecimal remainder(TBigDecimal divisor) {
        return this.divideAndRemainder(divisor)[1];
    }

    public TBigDecimal remainder(TBigDecimal divisor, TMathContext mc) {
        return this.divideAndRemainder(divisor, mc)[1];
    }

    public TBigDecimal[] divideAndRemainder(TBigDecimal divisor) {
        TBigDecimal[] quotAndRem;
        quotAndRem = new TBigDecimal[]{this.divideToIntegralValue(divisor), this.subtract(quotAndRem[0].multiply(divisor))};
        return quotAndRem;
    }

    public TBigDecimal[] divideAndRemainder(TBigDecimal divisor, TMathContext mc) {
        TBigDecimal[] quotAndRem;
        quotAndRem = new TBigDecimal[]{this.divideToIntegralValue(divisor, mc), this.subtract(quotAndRem[0].multiply(divisor))};
        return quotAndRem;
    }

    public TBigDecimal pow(int n) {
        if (n == 0) {
            return ONE;
        }
        if (n < 0 || n > 999999999) {
            throw new ArithmeticException("Invalid Operation");
        }
        long newScale = (long)this.scale * (long)n;
        return this.isZero() ? TBigDecimal.zeroScaledBy(newScale) : new TBigDecimal(this.getUnscaledValue().pow(n), TBigDecimal.toIntScale(newScale));
    }

    public TBigDecimal pow(int n, TMathContext mc) {
        int m = Math.abs(n);
        int mcPrecision = mc.getPrecision();
        int elength = TMath.log10Int(m) + 1;
        TMathContext newPrecision = mc;
        if (n == 0 || this.isZero() && n > 0) {
            return this.pow(n);
        }
        if (m > 999999999 || mcPrecision == 0 && n < 0 || mcPrecision > 0 && elength > mcPrecision) {
            throw new ArithmeticException("Invalid Operation");
        }
        if (mcPrecision > 0) {
            newPrecision = new TMathContext(mcPrecision + elength + 1, mc.getRoundingMode());
        }
        TBigDecimal accum = this.round(newPrecision);
        for (int oneBitMask = Integer.highestOneBit(m) >> 1; oneBitMask > 0; oneBitMask >>= 1) {
            accum = accum.multiply(accum, newPrecision);
            if ((m & oneBitMask) != oneBitMask) continue;
            accum = accum.multiply(this, newPrecision);
        }
        if (n < 0) {
            accum = ONE.divide(accum, newPrecision);
        }
        accum.inplaceRound(mc);
        return accum;
    }

    public TBigDecimal abs() {
        return this.signum() < 0 ? this.negate() : this;
    }

    public TBigDecimal abs(TMathContext mc) {
        return this.round(mc).abs();
    }

    public TBigDecimal negate() {
        if (this.bitLength < 63 || this.bitLength == 63 && this.smallValue != Long.MIN_VALUE) {
            return TBigDecimal.valueOf(-this.smallValue, this.scale);
        }
        return new TBigDecimal(this.getUnscaledValue().negate(), this.scale);
    }

    public TBigDecimal negate(TMathContext mc) {
        return this.round(mc).negate();
    }

    public TBigDecimal plus() {
        return this;
    }

    public TBigDecimal plus(TMathContext mc) {
        return this.round(mc);
    }

    public int signum() {
        if (this.bitLength < 64) {
            return Long.signum(this.smallValue);
        }
        return this.getUnscaledValue().signum();
    }

    private boolean isZero() {
        return this.bitLength == 0 && this.smallValue != -1L;
    }

    public int scale() {
        return this.scale;
    }

    public int precision() {
        if (this.precision > 0) {
            return this.precision;
        }
        int bitLength = this.bitLength;
        int decimalDigits = 1;
        double doubleUnsc = 1.0;
        if (bitLength < 1024) {
            if (bitLength >= 64) {
                doubleUnsc = this.getUnscaledValue().doubleValue();
            } else if (bitLength >= 1) {
                doubleUnsc = this.smallValue;
            }
            decimalDigits += TMath.log10Int(Math.abs(doubleUnsc));
        } else {
            decimalDigits = (int)((double)decimalDigits + (double)(bitLength - 1) * 0.3010299956639812);
            if (this.getUnscaledValue().divide(TMultiplication.powerOf10(decimalDigits)).signum() != 0) {
                ++decimalDigits;
            }
        }
        this.precision = decimalDigits;
        return this.precision;
    }

    public TBigInteger unscaledValue() {
        return this.getUnscaledValue();
    }

    public TBigDecimal round(TMathContext mc) {
        TBigDecimal thisBD = new TBigDecimal(this.getUnscaledValue(), this.scale);
        thisBD.inplaceRound(mc);
        return thisBD;
    }

    public TBigDecimal setScale(int newScale, TRoundingMode roundingMode) {
        if (roundingMode == null) {
            throw new NullPointerException();
        }
        long diffScale = (long)newScale - (long)this.scale;
        if (diffScale == 0L) {
            return this;
        }
        if (diffScale > 0L) {
            if (diffScale < (long)LONG_TEN_POW.length && this.bitLength + LONG_TEN_POW_BIT_LENGTH[(int)diffScale] < 64) {
                return TBigDecimal.valueOf(this.smallValue * LONG_TEN_POW[(int)diffScale], newScale);
            }
            return new TBigDecimal(TMultiplication.multiplyByTenPow(this.getUnscaledValue(), (int)diffScale), newScale);
        }
        if (this.bitLength < 64 && -diffScale < (long)LONG_TEN_POW.length) {
            return TBigDecimal.dividePrimitiveLongs(this.smallValue, LONG_TEN_POW[(int)(-diffScale)], newScale, roundingMode);
        }
        return TBigDecimal.divideBigIntegers(this.getUnscaledValue(), TMultiplication.powerOf10(-diffScale), newScale, roundingMode);
    }

    public TBigDecimal setScale(int newScale, int roundingMode) {
        return this.setScale(newScale, TRoundingMode.valueOf(roundingMode));
    }

    public TBigDecimal setScale(int newScale) {
        return this.setScale(newScale, TRoundingMode.UNNECESSARY);
    }

    public TBigDecimal movePointLeft(int n) {
        return this.movePoint((long)this.scale + (long)n);
    }

    private TBigDecimal movePoint(long newScale) {
        if (this.isZero()) {
            return TBigDecimal.zeroScaledBy(Math.max(newScale, 0L));
        }
        if (newScale >= 0L) {
            if (this.bitLength < 64) {
                return TBigDecimal.valueOf(this.smallValue, TBigDecimal.toIntScale(newScale));
            }
            return new TBigDecimal(this.getUnscaledValue(), TBigDecimal.toIntScale(newScale));
        }
        if (-newScale < (long)LONG_TEN_POW.length && this.bitLength + LONG_TEN_POW_BIT_LENGTH[(int)(-newScale)] < 64) {
            return TBigDecimal.valueOf(this.smallValue * LONG_TEN_POW[(int)(-newScale)], 0);
        }
        return new TBigDecimal(TMultiplication.multiplyByTenPow(this.getUnscaledValue(), (int)(-newScale)), 0);
    }

    public TBigDecimal movePointRight(int n) {
        return this.movePoint((long)this.scale - (long)n);
    }

    public TBigDecimal scaleByPowerOfTen(int n) {
        long newScale = (long)this.scale - (long)n;
        if (this.bitLength < 64) {
            if (this.smallValue == 0L) {
                return TBigDecimal.zeroScaledBy(newScale);
            }
            return TBigDecimal.valueOf(this.smallValue, TBigDecimal.toIntScale(newScale));
        }
        return new TBigDecimal(this.getUnscaledValue(), TBigDecimal.toIntScale(newScale));
    }

    public TBigDecimal stripTrailingZeros() {
        int i = 1;
        int lastPow = TEN_POW.length - 1;
        long newScale = this.scale;
        if (this.isZero()) {
            return new TBigDecimal("0");
        }
        TBigInteger strippedBI = this.getUnscaledValue();
        while (!strippedBI.testBit(0)) {
            TBigInteger[] quotAndRem = strippedBI.divideAndRemainder(TEN_POW[i]);
            if (quotAndRem[1].signum() == 0) {
                newScale -= (long)i;
                if (i < lastPow) {
                    ++i;
                }
                strippedBI = quotAndRem[0];
                continue;
            }
            if (i == 1) break;
            i = 1;
        }
        return new TBigDecimal(strippedBI, TBigDecimal.toIntScale(newScale));
    }

    @Override
    public int compareTo(TBigDecimal val) {
        int valueSign;
        int thisSign = this.signum();
        if (thisSign == (valueSign = val.signum())) {
            if (this.scale == val.scale && this.bitLength < 64 && val.bitLength < 64) {
                return this.smallValue < val.smallValue ? -1 : (this.smallValue > val.smallValue ? 1 : 0);
            }
            long diffScale = (long)this.scale - (long)val.scale;
            int diffPrecision = this.aproxPrecision() - val.aproxPrecision();
            if ((long)diffPrecision > diffScale + 1L) {
                return thisSign;
            }
            if ((long)diffPrecision < diffScale - 1L) {
                return -thisSign;
            }
            TBigInteger thisUnscaled = this.getUnscaledValue();
            TBigInteger valUnscaled = val.getUnscaledValue();
            if (diffScale < 0L) {
                thisUnscaled = thisUnscaled.multiply(TMultiplication.powerOf10(-diffScale));
            } else if (diffScale > 0L) {
                valUnscaled = valUnscaled.multiply(TMultiplication.powerOf10(diffScale));
            }
            return thisUnscaled.compareTo(valUnscaled);
        }
        if (thisSign < valueSign) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object x) {
        if (this == x) {
            return true;
        }
        if (x instanceof TBigDecimal) {
            TBigDecimal x1 = (TBigDecimal)x;
            return x1.scale == this.scale && (this.bitLength < 64 ? x1.smallValue == this.smallValue : this.intVal.equals(x1.intVal));
        }
        return false;
    }

    public TBigDecimal min(TBigDecimal val) {
        return this.compareTo(val) <= 0 ? this : val;
    }

    public TBigDecimal max(TBigDecimal val) {
        return this.compareTo(val) >= 0 ? this : val;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        if (this.bitLength < 64) {
            this.hashCode = (int)this.smallValue;
            this.hashCode = 33 * this.hashCode + (int)(this.smallValue >> 32);
            this.hashCode = 17 * this.hashCode + this.scale;
            return this.hashCode;
        }
        this.hashCode = 17 * this.intVal.hashCode() + this.scale;
        return this.hashCode;
    }

    public String toString() {
        if (this.toStringImage != null) {
            return this.toStringImage;
        }
        if (this.bitLength < 32) {
            this.toStringImage = TConversion.toDecimalScaledString(this.smallValue, this.scale);
            return this.toStringImage;
        }
        String intString = this.getUnscaledValue().toString();
        if (this.scale == 0) {
            return intString;
        }
        int begin = this.getUnscaledValue().signum() < 0 ? 2 : 1;
        int end = intString.length();
        long exponent = -((long)this.scale) + (long)end - (long)begin;
        StringBuilder result = new StringBuilder();
        result.append(intString);
        if (this.scale > 0 && exponent >= -6L) {
            if (exponent >= 0L) {
                result.insert(end - this.scale, '.');
            } else {
                result.insert(begin - 1, "0.");
                result.insert(begin + 1, CH_ZEROS, 0, -((int)exponent) - 1);
            }
        } else {
            if (end - begin >= 1) {
                result.insert(begin, '.');
                ++end;
            }
            result.insert(end, 'E');
            if (exponent > 0L) {
                result.insert(++end, '+');
            }
            result.insert(++end, Long.toString(exponent));
        }
        this.toStringImage = result.toString();
        return this.toStringImage;
    }

    public String toEngineeringString() {
        String intString = this.getUnscaledValue().toString();
        if (this.scale == 0) {
            return intString;
        }
        int begin = this.getUnscaledValue().signum() < 0 ? 2 : 1;
        int end = intString.length();
        long exponent = -((long)this.scale) + (long)end - (long)begin;
        StringBuilder result = new StringBuilder(intString);
        if (this.scale > 0 && exponent >= -6L) {
            if (exponent >= 0L) {
                result.insert(end - this.scale, '.');
            } else {
                result.insert(begin - 1, "0.");
                result.insert(begin + 1, CH_ZEROS, 0, -((int)exponent) - 1);
            }
        } else {
            int delta = end - begin;
            int rem = (int)(exponent % 3L);
            if (rem != 0) {
                if (this.getUnscaledValue().signum() == 0) {
                    rem = rem < 0 ? -rem : 3 - rem;
                    exponent += (long)rem;
                } else {
                    rem = rem < 0 ? rem + 3 : rem;
                    exponent -= (long)rem;
                    begin += rem;
                }
                if (delta < 3) {
                    for (int i = rem - delta; i > 0; --i) {
                        result.insert(end++, '0');
                    }
                }
            }
            if (end - begin >= 1) {
                result.insert(begin, '.');
                ++end;
            }
            if (exponent != 0L) {
                result.insert(end, 'E');
                if (exponent > 0L) {
                    result.insert(++end, '+');
                }
                result.insert(++end, Long.toString(exponent));
            }
        }
        return result.toString();
    }

    public String toPlainString() {
        String intStr = this.getUnscaledValue().toString();
        if (this.scale == 0 || this.isZero() && this.scale < 0) {
            return intStr;
        }
        int begin = this.signum() < 0 ? 1 : 0;
        int delta = this.scale;
        StringBuilder result = new StringBuilder(intStr.length() + 1 + Math.abs(this.scale));
        if (begin == 1) {
            result.append('-');
        }
        if (this.scale > 0) {
            if ((delta -= intStr.length() - begin) >= 0) {
                result.append("0.");
                while (delta > CH_ZEROS.length) {
                    result.append(CH_ZEROS);
                    delta -= CH_ZEROS.length;
                }
                result.append(CH_ZEROS, 0, delta);
                result.append(intStr.substring(begin));
            } else {
                delta = begin - delta;
                result.append(intStr.substring(begin, delta));
                result.append('.');
                result.append(intStr.substring(delta));
            }
        } else {
            result.append(intStr.substring(begin));
            while (delta < -CH_ZEROS.length) {
                result.append(CH_ZEROS);
                delta += CH_ZEROS.length;
            }
            result.append(CH_ZEROS, 0, -delta);
        }
        return result.toString();
    }

    public TBigInteger toBigInteger() {
        if (this.scale == 0 || this.isZero()) {
            return this.getUnscaledValue();
        }
        if (this.scale < 0) {
            return this.getUnscaledValue().multiply(TMultiplication.powerOf10(-((long)this.scale)));
        }
        return this.getUnscaledValue().divide(TMultiplication.powerOf10(this.scale));
    }

    public TBigInteger toBigIntegerExact() {
        if (this.scale == 0 || this.isZero()) {
            return this.getUnscaledValue();
        }
        if (this.scale < 0) {
            return this.getUnscaledValue().multiply(TMultiplication.powerOf10(-((long)this.scale)));
        }
        if (this.scale > this.aproxPrecision() || this.scale > this.getUnscaledValue().getLowestSetBit()) {
            throw new ArithmeticException("Rounding necessary");
        }
        TBigInteger[] integerAndFraction = this.getUnscaledValue().divideAndRemainder(TMultiplication.powerOf10(this.scale));
        if (integerAndFraction[1].signum() != 0) {
            throw new ArithmeticException("Rounding necessary");
        }
        return integerAndFraction[0];
    }

    @Override
    public long longValue() {
        return this.scale <= -64 || this.scale > this.aproxPrecision() ? 0L : this.toBigInteger().longValue();
    }

    public long longValueExact() {
        return this.valueExact(64);
    }

    @Override
    public int intValue() {
        return this.scale <= -32 || this.scale > this.aproxPrecision() ? 0 : this.toBigInteger().intValue();
    }

    public int intValueExact() {
        return (int)this.valueExact(32);
    }

    public short shortValueExact() {
        return (short)this.valueExact(16);
    }

    public byte byteValueExact() {
        return (byte)this.valueExact(8);
    }

    @Override
    public float floatValue() {
        float floatResult = this.signum();
        long powerOfTwo = (long)this.bitLength - (long)((double)this.scale / 0.3010299956639812);
        floatResult = powerOfTwo < -149L || floatResult == 0.0f ? (floatResult *= 0.0f) : (powerOfTwo > 129L ? (floatResult *= Float.POSITIVE_INFINITY) : (float)this.doubleValue());
        return floatResult;
    }

    @Override
    public double doubleValue() {
        long tempBits;
        long bits;
        int sign = this.signum();
        int exponent = 1076;
        long powerOfTwo = (long)this.bitLength - (long)((double)this.scale / 0.3010299956639812);
        if (powerOfTwo < -1074L || sign == 0) {
            return (double)sign * 0.0;
        }
        if (powerOfTwo > 1025L) {
            return (double)sign * Double.POSITIVE_INFINITY;
        }
        TBigInteger mantisa = this.getUnscaledValue().abs();
        if (this.scale <= 0) {
            mantisa = mantisa.multiply(TMultiplication.powerOf10(-this.scale));
        } else {
            TBigInteger powerOfTen = TMultiplication.powerOf10(this.scale);
            int k = 100 - (int)powerOfTwo;
            if (k > 0) {
                mantisa = mantisa.shiftLeft(k);
                exponent -= k;
            }
            TBigInteger[] quotAndRem = mantisa.divideAndRemainder(powerOfTen);
            int compRem = quotAndRem[1].shiftLeftOneBit().compareTo(powerOfTen);
            mantisa = quotAndRem[0].shiftLeft(2).add(TBigInteger.valueOf(compRem * (compRem + 3) / 2 + 1));
            exponent -= 2;
        }
        int lowestSetBit = mantisa.getLowestSetBit();
        int discardedSize = mantisa.bitLength() - 54;
        if (discardedSize > 0) {
            tempBits = bits = mantisa.shiftRight(discardedSize).longValue();
            if ((bits & 1L) == 1L && lowestSetBit < discardedSize || (bits & 3L) == 3L) {
                bits += 2L;
            }
        } else {
            tempBits = bits = mantisa.longValue() << -discardedSize;
            if ((bits & 3L) == 3L) {
                bits += 2L;
            }
        }
        if ((bits & 0x40000000000000L) == 0L) {
            bits >>= 1;
            exponent += discardedSize;
        } else {
            bits >>= 2;
            exponent += discardedSize + 1;
        }
        if (exponent > 2046) {
            return (double)sign * Double.POSITIVE_INFINITY;
        }
        if (exponent <= 0) {
            if (exponent < -53) {
                return (double)sign * 0.0;
            }
            bits = tempBits >> 1;
            tempBits = bits & -1L >>> 63 + exponent;
            if (((bits >>= -exponent) & 3L) == 3L || (bits & 1L) == 1L && tempBits != 0L && lowestSetBit < discardedSize) {
                ++bits;
            }
            exponent = 0;
            bits >>= 1;
        }
        bits = (long)sign & Long.MIN_VALUE | (long)exponent << 52 | bits & 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(bits);
    }

    public TBigDecimal ulp() {
        return TBigDecimal.valueOf(1L, this.scale);
    }

    private void inplaceRound(TMathContext mc) {
        int mcPrecision = mc.getPrecision();
        if (this.aproxPrecision() - mcPrecision <= 0 || mcPrecision == 0) {
            return;
        }
        int discardedPrecision = this.precision() - mcPrecision;
        if (discardedPrecision <= 0) {
            return;
        }
        if (this.bitLength < 64) {
            this.smallRound(mc, discardedPrecision);
            return;
        }
        TBigInteger sizeOfFraction = TMultiplication.powerOf10(discardedPrecision);
        TBigInteger[] integerAndFraction = this.getUnscaledValue().divideAndRemainder(sizeOfFraction);
        long newScale = (long)this.scale - (long)discardedPrecision;
        if (integerAndFraction[1].signum() != 0) {
            TBigDecimal tempBD;
            int compRem = integerAndFraction[1].abs().shiftLeftOneBit().compareTo(sizeOfFraction);
            compRem = TBigDecimal.roundingBehavior(integerAndFraction[0].testBit(0) ? 1 : 0, integerAndFraction[1].signum() * (5 + compRem), mc.getRoundingMode());
            if (compRem != 0) {
                integerAndFraction[0] = integerAndFraction[0].add(TBigInteger.valueOf(compRem));
            }
            if ((tempBD = new TBigDecimal(integerAndFraction[0])).precision() > mcPrecision) {
                integerAndFraction[0] = integerAndFraction[0].divide(TBigInteger.TEN);
                --newScale;
            }
        }
        this.scale = TBigDecimal.toIntScale(newScale);
        this.precision = mcPrecision;
        this.setUnscaledValue(integerAndFraction[0]);
    }

    private static int longCompareTo(long value1, long value2) {
        return value1 > value2 ? 1 : (value1 < value2 ? -1 : 0);
    }

    private void smallRound(TMathContext mc, int discardedPrecision) {
        long sizeOfFraction = LONG_TEN_POW[discardedPrecision];
        long newScale = (long)this.scale - (long)discardedPrecision;
        long unscaledVal = this.smallValue;
        long integer = unscaledVal / sizeOfFraction;
        long fraction = unscaledVal % sizeOfFraction;
        if (fraction != 0L) {
            int compRem = TBigDecimal.longCompareTo(Math.abs(fraction) << 1, sizeOfFraction);
            if (TMath.log10Int(Math.abs(integer += (long)TBigDecimal.roundingBehavior((int)integer & 1, Long.signum(fraction) * (5 + compRem), mc.getRoundingMode()))) >= mc.getPrecision()) {
                integer /= 10L;
                --newScale;
            }
        }
        this.scale = TBigDecimal.toIntScale(newScale);
        this.precision = mc.getPrecision();
        this.smallValue = integer;
        this.bitLength = TBigDecimal.bitLength(integer);
        this.intVal = null;
    }

    private static int roundingBehavior(int parityBit, int fraction, TRoundingMode roundingMode) {
        int increment = 0;
        switch (roundingMode) {
            case UNNECESSARY: {
                if (fraction == 0) break;
                throw new ArithmeticException("Rounding necessary");
            }
            case UP: {
                increment = Integer.signum(fraction);
                break;
            }
            case DOWN: {
                break;
            }
            case CEILING: {
                increment = Math.max(Integer.signum(fraction), 0);
                break;
            }
            case FLOOR: {
                increment = Math.min(Integer.signum(fraction), 0);
                break;
            }
            case HALF_UP: {
                if (Math.abs(fraction) < 5) break;
                increment = Integer.signum(fraction);
                break;
            }
            case HALF_DOWN: {
                if (Math.abs(fraction) <= 5) break;
                increment = Integer.signum(fraction);
                break;
            }
            case HALF_EVEN: {
                if (Math.abs(fraction) + parityBit <= 5) break;
                increment = Integer.signum(fraction);
            }
        }
        return increment;
    }

    private long valueExact(int bitLengthOfType) {
        TBigInteger bigInteger = this.toBigIntegerExact();
        if (bigInteger.bitLength() < bitLengthOfType) {
            return bigInteger.longValue();
        }
        throw new ArithmeticException("Rounding necessary");
    }

    private int aproxPrecision() {
        return this.precision > 0 ? this.precision : (int)((double)(this.bitLength - 1) * 0.3010299956639812) + 1;
    }

    private static int toIntScale(long longScale) {
        if (longScale < Integer.MIN_VALUE) {
            throw new ArithmeticException("Overflow");
        }
        if (longScale > Integer.MAX_VALUE) {
            throw new ArithmeticException("Underflow");
        }
        return (int)longScale;
    }

    private static TBigDecimal zeroScaledBy(long longScale) {
        if (longScale == (long)((int)longScale)) {
            return TBigDecimal.valueOf(0L, (int)longScale);
        }
        if (longScale >= 0L) {
            return new TBigDecimal(0, Integer.MAX_VALUE);
        }
        return new TBigDecimal(0, Integer.MIN_VALUE);
    }

    private TBigInteger getUnscaledValue() {
        if (this.intVal == null) {
            this.intVal = TBigInteger.valueOf(this.smallValue);
        }
        return this.intVal;
    }

    private void setUnscaledValue(TBigInteger unscaledValue) {
        this.intVal = unscaledValue;
        this.bitLength = unscaledValue.bitLength();
        if (this.bitLength < 64) {
            this.smallValue = unscaledValue.longValue();
        }
    }

    private static int bitLength(long smallValue) {
        if (smallValue < 0L) {
            smallValue ^= 0xFFFFFFFFFFFFFFFFL;
        }
        return 64 - Long.numberOfLeadingZeros(smallValue);
    }

    private static int bitLength(int smallValue) {
        if (smallValue < 0) {
            smallValue ^= 0xFFFFFFFF;
        }
        return 32 - Integer.numberOfLeadingZeros(smallValue);
    }

    static {
        int j;
        int i;
        ZERO = new TBigDecimal(0, 0);
        ONE = new TBigDecimal(1, 0);
        TEN = new TBigDecimal(10, 0);
        LONG_TEN_POW = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
        LONG_FIVE_POW = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L, 7450580596923828125L};
        LONG_FIVE_POW_BIT_LENGTH = new int[LONG_FIVE_POW.length];
        LONG_TEN_POW_BIT_LENGTH = new int[LONG_TEN_POW.length];
        BI_SCALED_BY_ZERO = new TBigDecimal[11];
        ZERO_SCALED_BY = new TBigDecimal[11];
        CH_ZEROS = new char[100];
        for (i = 0; i < ZERO_SCALED_BY.length; ++i) {
            TBigDecimal.BI_SCALED_BY_ZERO[i] = new TBigDecimal(i, 0);
            TBigDecimal.ZERO_SCALED_BY[i] = new TBigDecimal(0, i);
            TBigDecimal.CH_ZEROS[i] = 48;
        }
        while (i < CH_ZEROS.length) {
            TBigDecimal.CH_ZEROS[i] = 48;
            ++i;
        }
        for (j = 0; j < LONG_FIVE_POW_BIT_LENGTH.length; ++j) {
            TBigDecimal.LONG_FIVE_POW_BIT_LENGTH[j] = TBigDecimal.bitLength(LONG_FIVE_POW[j]);
        }
        for (j = 0; j < LONG_TEN_POW_BIT_LENGTH.length; ++j) {
            TBigDecimal.LONG_TEN_POW_BIT_LENGTH[j] = TBigDecimal.bitLength(LONG_TEN_POW[j]);
        }
        TEN_POW = TMultiplication.bigTenPows;
        FIVE_POW = TMultiplication.bigFivePows;
    }
}

