/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.lang.reflect;

import com.antgroup.antchain.myjava.classlib.impl.reflection.Flags;
import com.antgroup.antchain.myjava.classlib.java.lang.TClass;
import com.antgroup.antchain.myjava.classlib.java.lang.TIllegalAccessException;
import com.antgroup.antchain.myjava.classlib.java.lang.TIllegalArgumentException;
import com.antgroup.antchain.myjava.classlib.java.lang.TObject;
import com.antgroup.antchain.myjava.classlib.java.lang.annotation.TAnnotation;
import com.antgroup.antchain.myjava.classlib.java.lang.reflect.TAccessibleObject;
import com.antgroup.antchain.myjava.classlib.java.lang.reflect.TMember;
import com.antgroup.antchain.myjava.classlib.java.lang.reflect.TModifier;
import com.antgroup.antchain.myjava.classlib.java.lang.reflect.TType;
import com.antgroup.antchain.myjava.interop.Address;
import com.antgroup.antchain.myjava.runtime.RuntimeObject;
import com.antgroup.antchain.myjava.runtime.WasmRuntime;
import java.util.Arrays;
import java.util.Objects;

public class TField
extends TAccessibleObject
implements TMember {
    private TClass<?> declaringClass;
    private String name;
    private int modifiers;
    private int accessLevel;
    private TClass<?> type;
    private short fieldOffset;
    private TAnnotation[] annotations;
    public TType genericType;

    public TField(TClass<?> declaringClass, String name, int modifiers, int accessLevel, TClass<?> type, short fieldOffset, TAnnotation[] annotations) {
        this.declaringClass = declaringClass;
        this.name = name;
        this.modifiers = modifiers;
        this.accessLevel = accessLevel;
        this.type = type;
        this.fieldOffset = fieldOffset;
        this.annotations = annotations;
        this.genericType = type;
    }

    @Override
    public TClass<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return Flags.getModifiers(this.modifiers, this.accessLevel);
    }

    public boolean isEnumConstant() {
        return (this.modifiers & 8) != 0;
    }

    public TClass<?> getType() {
        return this.type;
    }

    @Override
    public TAnnotation[] getDeclaredAnnotations() {
        return Arrays.copyOf(this.annotations, this.annotations.length);
    }

    public TAnnotation getDeclaredAnnotation(Class<?> annotationClass) {
        Objects.requireNonNull(annotationClass, "annotationClass");
        for (TAnnotation annotation : this.annotations) {
            if (annotation.annotationType() != annotationClass) continue;
            return annotation;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TModifier.toString(this.getModifiers()));
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(this.getType().getName()).append(' ').append(this.declaringClass.getName()).append(".").append(this.name);
        return sb.toString();
    }

    public Object get(Object obj) throws TIllegalArgumentException, TIllegalAccessException {
        this.checkInstance(obj);
        RuntimeObject runtimeObject = (RuntimeObject)Address.ofObject(obj).toStructure();
        Address fieldAddress = runtimeObject.toAddress().add(this.fieldOffset);
        if (this.type.isPrimitive()) {
            String typeName = this.type.getName();
            if (typeName.equals(Integer.TYPE.getName())) {
                return fieldAddress.getInt();
            }
            if (typeName.equals(Character.TYPE.getName())) {
                return Character.valueOf(fieldAddress.getChar());
            }
            if (typeName.equals(Byte.TYPE.getName())) {
                return fieldAddress.getByte();
            }
            if (typeName.equals(Short.TYPE.getName())) {
                return fieldAddress.getShort();
            }
            if (typeName.equals(Long.TYPE.getName())) {
                return fieldAddress.getLong();
            }
            if (typeName.equals(Boolean.TYPE.getName())) {
                return fieldAddress.getByte() != 0;
            }
            if (typeName.equals(Float.TYPE.getName())) {
                return Float.valueOf(fieldAddress.getFloat());
            }
            if (typeName.equals(Double.TYPE.getName())) {
                return fieldAddress.getDouble();
            }
            throw new RuntimeException("not supported Field.get type " + typeName);
        }
        if (this.type.isArray()) {
            return WasmRuntime.addressToObject(fieldAddress.getAddress());
        }
        return WasmRuntime.addressToObject(fieldAddress.getAddress());
    }

    public TType getGenericType() {
        return this.genericType != null ? this.genericType : this.type;
    }

    public void setDouble(Object obj, double value) throws TIllegalArgumentException, TIllegalAccessException {
        this.set(obj, value);
    }

    public void setFloat(Object obj, float value) throws TIllegalArgumentException, TIllegalAccessException {
        this.set(obj, Float.valueOf(value));
    }

    public void setLong(Object obj, long value) throws TIllegalArgumentException, TIllegalAccessException {
        this.set(obj, value);
    }

    public void setInt(Object obj, int value) throws TIllegalArgumentException, TIllegalAccessException {
        this.set(obj, value);
    }

    public void setBoolean(Object obj, boolean value) throws TIllegalArgumentException, TIllegalAccessException {
        this.set(obj, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(Object obj, Object value) throws TIllegalArgumentException, TIllegalAccessException {
        this.checkInstance(obj);
        RuntimeObject runtimeObject = (RuntimeObject)Address.ofObject(obj).toStructure();
        Address fieldAddress = runtimeObject.toAddress().add(this.fieldOffset);
        if (this.type.isPrimitive()) {
            String typeName = this.type.getName();
            if (typeName.equals(Integer.TYPE.getName())) {
                fieldAddress.putInt((Integer)value);
                return;
            } else if (typeName.equals(Character.TYPE.getName())) {
                fieldAddress.putChar(((Character)value).charValue());
                return;
            } else if (typeName.equals(Byte.TYPE.getName())) {
                fieldAddress.putByte((Byte)value);
                return;
            } else if (typeName.equals(Short.TYPE.getName())) {
                fieldAddress.putShort((Short)value);
                return;
            } else if (typeName.equals(Long.TYPE.getName())) {
                fieldAddress.putLong((Long)value);
                return;
            } else if (typeName.equals(Boolean.TYPE.getName())) {
                fieldAddress.putByte((Boolean)value != false ? (byte)1 : 0);
                return;
            } else if (typeName.equals(Float.TYPE.getName())) {
                fieldAddress.putFloat(((Float)value).floatValue());
                return;
            } else {
                if (!typeName.equals(Double.TYPE.getName())) throw new RuntimeException("not supported Field.set type " + typeName);
                fieldAddress.putDouble((Double)value);
            }
            return;
        } else if (this.type.isArray()) {
            fieldAddress.putAddress(Address.ofObject(value));
            return;
        } else {
            fieldAddress.putAddress(Address.ofObject(value));
        }
    }

    private void checkInstance(Object obj) {
        if ((this.modifiers & 0x200) == 0) {
            if (obj == null) {
                throw new NullPointerException();
            }
            if (!this.declaringClass.isInstance((TObject)obj)) {
                throw new TIllegalArgumentException();
            }
        }
    }

    public boolean equals(Object other) {
        Objects.requireNonNull(other, "other");
        if (this == other) {
            return true;
        }
        if (!(other instanceof TField)) {
            return false;
        }
        TField otherField = (TField)other;
        return this.name.equals(otherField.getName()) && this.getType().equals(otherField.getType()) && this.fieldOffset == otherField.fieldOffset;
    }
}

