/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.lang;

import com.antgroup.antchain.myjava.classlib.java.io.TSerializable;
import com.antgroup.antchain.myjava.classlib.java.lang.TNullPointerException;
import com.antgroup.antchain.myjava.classlib.java.lang.TObject;
import com.antgroup.antchain.myjava.classlib.java.util.TObjects;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import java.util.Objects;

@NoMetadata
public final class TStackTraceElement
extends TObject
implements TSerializable {
    private String declaringClass;
    private String methodName;
    private String fileName;
    private int lineNumber;

    public TStackTraceElement(String declaringClass, String methodName, String fileName, int lineNumber) {
        if (declaringClass == null || methodName == null) {
            throw new TNullPointerException();
        }
        this.declaringClass = declaringClass;
        this.methodName = methodName;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public String getClassName() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean isNativeMethod() {
        return this.fileName == null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.declaringClass, this.methodName, this.fileName, this.lineNumber);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TStackTraceElement)) {
            return false;
        }
        TStackTraceElement other = (TStackTraceElement)obj;
        return TObjects.equals(this.declaringClass, other.declaringClass) && TObjects.equals(this.methodName, other.methodName) && TObjects.equals(this.fileName, other.fileName) && this.lineNumber == other.lineNumber;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int index = this.declaringClass.lastIndexOf(46);
        sb.append(this.declaringClass.substring(index + 1)).append('.').append(this.methodName).append('(');
        if (this.fileName != null) {
            sb.append(this.fileName).append(':').append(this.lineNumber);
        } else {
            sb.append("Unknown Source");
        }
        sb.append(")");
        return sb.toString();
    }
}

