/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.lang;

import com.antgroup.antchain.myjava.classlib.java.lang.TCharacter;
import com.antgroup.antchain.myjava.classlib.java.lang.TComparable;
import com.antgroup.antchain.myjava.classlib.java.lang.TNumber;
import com.antgroup.antchain.myjava.classlib.java.lang.TNumberFormatException;
import com.antgroup.antchain.myjava.classlib.java.lang.TString;
import com.antgroup.antchain.myjava.classlib.java.lang.TStringBuilder;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjava.interop.NoSideEffects;

@NoMetadata
public class TFloat
extends TNumber
implements TComparable<TFloat> {
    public static final float POSITIVE_INFINITY = Float.POSITIVE_INFINITY;
    public static final float NEGATIVE_INFINITY = Float.NEGATIVE_INFINITY;
    public static final float MAX_VALUE = Float.MAX_VALUE;
    public static final float MIN_VALUE = Float.MIN_NORMAL;
    public static final float MIN_NORMAL = Float.MIN_VALUE;
    public static final int MAX_EXPONENT = 127;
    public static final int MIN_EXPONENT = -126;
    public static final int SIZE = 32;
    public static final Class<Float> TYPE = Float.TYPE;
    private float value;

    public TFloat(float value) {
        this.value = value;
    }

    public TFloat(double value) {
        this((float)value);
    }

    public TFloat(TString value) throws TNumberFormatException {
        this(TFloat.parseFloat(value));
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public static TFloat valueOf(float d) {
        return new TFloat(d);
    }

    public static String toString(float d) {
        return new TStringBuilder().append(d).toString();
    }

    @Override
    public String toString() {
        return TFloat.toString(this.value);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TFloat && ((TFloat)other).value == this.value;
    }

    @Override
    public int hashCode() {
        return TFloat.hashCode(this.value);
    }

    public static int hashCode(float f) {
        return TFloat.floatToIntBits(f);
    }

    public static boolean isNaN(float v) {
        return false;
    }

    public static boolean isInfinite(float v) {
        return false;
    }

    public static boolean isFinite(float v) {
        return true;
    }

    public static float parseFloat(TString string) throws TNumberFormatException {
        if (string.isEmpty()) {
            throw new TNumberFormatException();
        }
        int start = 0;
        int end = string.length();
        while (string.charAt(start) <= ' ') {
            if (++start != end) continue;
            throw new TNumberFormatException();
        }
        while (string.charAt(end - 1) <= ' ') {
            --end;
        }
        boolean negative = false;
        int index = start;
        if (string.charAt(index) == '-') {
            ++index;
            negative = true;
        } else if (string.charAt(index) == '+') {
            ++index;
        }
        if (index == end) {
            throw new TNumberFormatException();
        }
        char c = string.charAt(index);
        int mantissa = 0;
        int exp = 0;
        boolean hasOneDigit = false;
        if (c != '.') {
            hasOneDigit = true;
            if (c < '0' || c > '9') {
                throw new TNumberFormatException();
            }
            while (index < end && string.charAt(index) == '0') {
                ++index;
            }
            while (index < end && (c = string.charAt(index)) >= '0' && c <= '9') {
                if (mantissa < 0xCCCCCC3) {
                    mantissa = mantissa * 10 + (c - 48);
                } else {
                    ++exp;
                }
                ++index;
            }
        }
        if (index < end && string.charAt(index) == '.') {
            ++index;
            while (index < end && (c = string.charAt(index)) >= '0' && c <= '9') {
                if (mantissa < 0xCCCCCC3) {
                    mantissa = mantissa * 10 + (c - 48);
                    --exp;
                }
                ++index;
                hasOneDigit = true;
            }
            if (!hasOneDigit) {
                throw new TNumberFormatException();
            }
        }
        if (index < end) {
            c = string.charAt(index);
            if (c != 'e' && c != 'E') {
                throw new TNumberFormatException();
            }
            boolean negativeExp = false;
            if (++index == end) {
                throw new TNumberFormatException();
            }
            if (string.charAt(index) == '-') {
                ++index;
                negativeExp = true;
            } else if (string.charAt(index) == '+') {
                ++index;
            }
            int numExp = 0;
            hasOneDigit = false;
            while (index < end && (c = string.charAt(index)) >= '0' && c <= '9') {
                numExp = 10 * numExp + (c - 48);
                hasOneDigit = true;
                ++index;
            }
            if (!hasOneDigit) {
                throw new TNumberFormatException();
            }
            if (negativeExp) {
                numExp = -numExp;
            }
            exp += numExp;
        }
        if (exp > 38 || exp == 38 && mantissa > 34028234) {
            return !negative ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
        }
        if (negative) {
            mantissa = -mantissa;
        }
        return (float)mantissa * TFloat.decimalExponent(exp);
    }

    private static float decimalExponent(int n) {
        double d;
        if (n < 0) {
            d = 0.1;
            n = -n;
        } else {
            d = 10.0;
        }
        double result = 1.0;
        while (n != 0) {
            if (n % 2 != 0) {
                result *= d;
            }
            d *= d;
            n /= 2;
        }
        return (float)result;
    }

    public static TFloat valueOf(TString s) throws TNumberFormatException {
        return TFloat.valueOf(TFloat.parseFloat(s));
    }

    public boolean isNaN() {
        return TFloat.isNaN(this.value);
    }

    public boolean isInfinite() {
        return TFloat.isInfinite(this.value);
    }

    @NoSideEffects
    public static native int compare(float var0, float var1);

    @Override
    public int compareTo(TFloat other) {
        return TFloat.compare(this.value, other.value);
    }

    public static int floatToRawIntBits(float value) {
        return TFloat.floatToIntBits(value);
    }

    public static native int floatToIntBits(float var0);

    public static native float intBitsToFloat(int var0);

    public static String toHexString(float f) {
        if (TFloat.isNaN(f)) {
            return "NaN";
        }
        if (TFloat.isInfinite(f)) {
            return f > 0.0f ? "Infinity" : "-Infinity";
        }
        char[] buffer = new char[18];
        int sz = 0;
        int bits = TFloat.floatToIntBits(f);
        boolean subNormal = false;
        int exp = (bits >>> 23 & 0xFF) - 127;
        int mantissa = (bits & 0x7FFFFF) << 1;
        if (exp == -127) {
            ++exp;
            subNormal = true;
        }
        for (int i = 0; i < 6; ++i) {
            int digit = mantissa & 0xF;
            if (digit > 0 || sz > 0) {
                buffer[sz++] = TCharacter.forDigit(digit, 16);
            }
            mantissa >>>= 4;
        }
        if (sz == 0) {
            buffer[sz++] = 48;
        }
        buffer[sz++] = 46;
        buffer[sz++] = subNormal ? 48 : 49;
        buffer[sz++] = 120;
        buffer[sz++] = 48;
        if (((long)bits & 0x80000000L) != 0L) {
            buffer[sz++] = 45;
        }
        int half = sz / 2;
        for (int i = 0; i < half; ++i) {
            char tmp = buffer[i];
            buffer[i] = buffer[sz - i - 1];
            buffer[sz - i - 1] = tmp;
        }
        buffer[sz++] = 112;
        if (exp < 0) {
            exp = -exp;
            buffer[sz++] = 45;
        }
        int pos = 100;
        boolean first = true;
        for (int i = 0; i < 3; ++i) {
            int digit = exp / pos;
            if (digit > 0 || !first) {
                buffer[sz++] = TCharacter.forDigit(digit, 10);
                first = false;
            }
            exp %= pos;
            pos /= 10;
        }
        if (first) {
            buffer[sz++] = 48;
        }
        return new String(buffer, 0, sz);
    }
}

