/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.io;

import com.antgroup.antchain.myjava.classlib.java.io.TReader;
import com.antgroup.antchain.myjava.classlib.java.lang.TIllegalArgumentException;
import com.antgroup.antchain.myjava.classlib.java.lang.TMath;
import com.antgroup.antchain.myjava.classlib.java.lang.TNullPointerException;
import com.antgroup.antchain.myjava.classlib.java.lang.TString;
import java.io.IOException;

public class TStringReader
extends TReader {
    private TString string;
    private int index;
    private int mark;

    public TStringReader(TString string) {
        if (string == null) {
            throw new TNullPointerException();
        }
        this.string = string;
    }

    @Override
    public int read() throws IOException {
        this.checkOpened();
        if (this.index >= this.string.length()) {
            return -1;
        }
        return this.string.charAt(this.index++);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.checkOpened();
        if (this.index >= this.string.length()) {
            return -1;
        }
        int n = TMath.min(this.string.length() - this.index, len);
        for (int i = 0; i < n; ++i) {
            cbuf[off++] = this.string.charAt(this.index++);
        }
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkOpened();
        n = n < 0L ? TMath.max(n, (long)(-this.index)) : TMath.min((long)(this.string.length() - this.index), n);
        this.index = (int)((long)this.index + n);
        return n;
    }

    @Override
    public boolean ready() throws IOException {
        this.checkOpened();
        return true;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.checkOpened();
        if (readAheadLimit < 0) {
            throw new TIllegalArgumentException();
        }
        this.mark = this.index;
    }

    @Override
    public void reset() throws IOException {
        this.checkOpened();
        this.index = this.mark;
    }

    @Override
    public void close() {
        this.string = null;
    }

    private void checkOpened() throws IOException {
        if (this.string == null) {
            throw new IOException();
        }
    }
}

