/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.impl.tz;

import com.antgroup.antchain.myjava.classlib.impl.Base46;
import com.antgroup.antchain.myjava.classlib.impl.CharFlow;
import com.antgroup.antchain.myjava.classlib.impl.tz.StorableDateTimeZone;
import java.time.ZoneOffset;
import java.time.zone.ZoneRules;
import java.util.Collections;

public final class FixedDateTimeZone
extends StorableDateTimeZone {
    private final int iWallOffset;
    private final int iStandardOffset;

    public FixedDateTimeZone(String id, int wallOffset, int standardOffset) {
        super(id);
        this.iWallOffset = wallOffset;
        this.iStandardOffset = standardOffset;
    }

    @Override
    public int getOffset(long instant) {
        return this.iWallOffset;
    }

    @Override
    public int getStandardOffset(long instant) {
        return this.iStandardOffset;
    }

    @Override
    public int getOffsetFromLocal(long instantLocal) {
        return this.iWallOffset;
    }

    @Override
    public boolean isFixed() {
        return true;
    }

    @Override
    public long nextTransition(long instant) {
        return instant;
    }

    @Override
    public long previousTransition(long instant) {
        return instant;
    }

    @Override
    public void write(StringBuilder sb) {
        Base46.encodeUnsigned(sb, 1);
        FixedDateTimeZone.writeTime(sb, this.iWallOffset);
        FixedDateTimeZone.writeTime(sb, this.iStandardOffset);
    }

    public static FixedDateTimeZone readZone(String id, CharFlow flow) {
        int wallOffset = (int)FixedDateTimeZone.readTime(flow);
        int standardOffset = (int)FixedDateTimeZone.readTime(flow);
        return new FixedDateTimeZone(id, wallOffset, standardOffset);
    }

    @Override
    public ZoneRules asZoneRules() {
        if (this.iWallOffset == this.iStandardOffset) {
            return ZoneRules.of(ZoneOffset.ofTotalSeconds(this.iStandardOffset / 1000));
        }
        return ZoneRules.of(ZoneOffset.ofTotalSeconds(this.iStandardOffset / 1000), ZoneOffset.ofTotalSeconds(this.iWallOffset / 1000), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }
}

