/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.impl;

import com.antgroup.antchain.myjava.metaprogramming.CompileTime;
import com.antgroup.antchain.myjava.metaprogramming.Meta;
import com.antgroup.antchain.myjava.metaprogramming.Metaprogramming;
import com.antgroup.antchain.myjava.metaprogramming.ReflectClass;
import com.antgroup.antchain.myjava.metaprogramming.Value;
import com.antgroup.antchain.myjava.metaprogramming.reflect.ReflectMethod;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.function.Supplier;

@CompileTime
public class ResourceBundleImpl {
    private ResourceBundleImpl() {
    }

    @Meta
    public static native Map<String, Supplier<ResourceBundle>> createBundleMap(boolean var0);

    private static void createBundleMap(Value<Boolean> b) throws IOException {
        ClassLoader loader = Metaprogramming.getClassLoader();
        Enumeration<URL> urls = loader.getResources("META-INF/services/java.util.ResourceBundle");
        LinkedHashSet<String> implementations = new LinkedHashSet<String>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    implementations.add(line);
                }
            }
        }
        Value<Map> result = Metaprogramming.emit(() -> new HashMap());
        for (String implementation : implementations) {
            Value<ResourceBundle> lazyResource;
            String path = implementation.replace('.', '/');
            ReflectClass<?> cls = Metaprogramming.findClass(implementation);
            if (cls != null) {
                ReflectMethod constructor = cls.getMethod("<init>", new ReflectClass[0]);
                if (constructor == null) continue;
                lazyResource = Metaprogramming.lazy(() -> (ResourceBundle)constructor.construct(new Object[0]));
            } else {
                if (loader.getResource(path + ".properties") == null) continue;
                lazyResource = Metaprogramming.lazyFragment(() -> {
                    Properties properties = new Properties();
                    try (InputStream input = loader.getResourceAsStream(path + ".properties");){
                        properties.load(input);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return Metaprogramming.proxy(ListResourceBundle.class, (instance, methodName, args) -> {
                        Value<List> contentsBuilder = Metaprogramming.emit(() -> new ArrayList());
                        for (Object propertyName : properties.keySet()) {
                            String key;
                            String value;
                            if (!(propertyName instanceof String) || (value = properties.getProperty(key = (String)propertyName)) == null) continue;
                            Metaprogramming.emit(() -> ((List)contentsBuilder.get()).add(new Object[]{key, value}));
                        }
                        Metaprogramming.exit(() -> ((List)contentsBuilder.get()).toArray((T[])new Object[0][]));
                    });
                });
            }
            Value<Supplier> supplierValueRaw = Metaprogramming.proxy(Supplier.class, (instance, methodName, args) -> Metaprogramming.exit(() -> lazyResource.get()));
            Value<Supplier> supplierValue = Metaprogramming.emit(() -> (Supplier)supplierValueRaw.get());
            Metaprogramming.emit(() -> ((Map)result.get()).put(implementation, (Supplier)supplierValue.get()));
        }
        Metaprogramming.exit(() -> result.get());
    }
}

