/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.impl;

import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.ClassHolder;
import com.antgroup.antchain.myjava.model.ClassHolderTransformer;
import com.antgroup.antchain.myjava.model.ClassHolderTransformerContext;
import com.antgroup.antchain.myjava.model.ElementModifier;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodHolder;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.BinaryInstruction;
import com.antgroup.antchain.myjava.model.instructions.BinaryOperation;
import com.antgroup.antchain.myjava.model.instructions.ExitInstruction;
import com.antgroup.antchain.myjava.model.instructions.NumericOperandType;

public class NumericClassTransformer
implements ClassHolderTransformer {
    @Override
    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        switch (cls.getName()) {
            case "java.lang.Integer": {
                this.transformInteger(cls);
                break;
            }
            case "java.lang.Long": {
                this.transformLong(cls);
                break;
            }
            case "java.lang.Float": {
                this.transformFloat(cls);
                break;
            }
            case "java.lang.Double": {
                this.transformDouble(cls);
            }
        }
    }

    private void transformInteger(ClassHolder cls) {
        this.transformCompareMethod(cls, ValueType.INTEGER, NumericOperandType.INT);
    }

    private void transformLong(ClassHolder cls) {
        this.transformCompareMethod(cls, ValueType.LONG, NumericOperandType.LONG);
    }

    private void transformFloat(ClassHolder cls) {
        this.transformCompareMethod(cls, ValueType.FLOAT, NumericOperandType.FLOAT);
    }

    private void transformDouble(ClassHolder cls) {
        this.transformCompareMethod(cls, ValueType.DOUBLE, NumericOperandType.DOUBLE);
    }

    private void transformCompareMethod(ClassHolder cls, ValueType type, NumericOperandType insnType) {
        MethodHolder method = cls.getMethod(new MethodDescriptor("compare", type, type, ValueType.INTEGER));
        Program program = new Program();
        program.createVariable();
        Variable firstArg = program.createVariable();
        Variable secondArg = program.createVariable();
        Variable result = program.createVariable();
        BasicBlock block = program.createBasicBlock();
        BinaryInstruction insn = new BinaryInstruction(BinaryOperation.COMPARE, insnType);
        insn.setFirstOperand(firstArg);
        insn.setSecondOperand(secondArg);
        insn.setReceiver(result);
        block.add(insn);
        ExitInstruction exit = new ExitInstruction();
        exit.setValueToReturn(result);
        block.add(exit);
        method.setProgram(program);
        method.getModifiers().remove((Object)ElementModifier.NATIVE);
    }
}

