/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.impl;

import com.antgroup.antchain.myjava.classlib.impl.ExceptionHelpers;
import com.antgroup.antchain.myjava.common.DisjointSet;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.ClassHierarchy;
import com.antgroup.antchain.myjava.model.ClassHolder;
import com.antgroup.antchain.myjava.model.ClassHolderTransformer;
import com.antgroup.antchain.myjava.model.ClassHolderTransformerContext;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MethodHolder;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.AssignInstruction;
import com.antgroup.antchain.myjava.model.instructions.ClassConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvocationType;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.StringConstantInstruction;
import java.util.Arrays;

public class ClassForNameTransformer
implements ClassHolderTransformer {
    private static final MethodReference getNameMethod = new MethodReference(Class.class, "getName", String.class);
    private static final MethodReference forNameMethod = new MethodReference(Class.class, "forName", String.class, Boolean.TYPE, ClassLoader.class, Class.class);
    private static final MethodReference forNameShortMethod = new MethodReference(Class.class, "forName", String.class, Class.class);
    private static final MethodReference initMethod = new MethodReference(Class.class, "initialize", Void.TYPE);

    @Override
    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        for (MethodHolder method : cls.getMethods()) {
            Program program = method.getProgram();
            if (program == null) continue;
            this.transformProgram(program, context.getHierarchy());
        }
    }

    private void transformProgram(Program program, ClassHierarchy hierarchy) {
        if (!this.hasForNameCall(program)) {
            return;
        }
        DisjointSet varSet = new DisjointSet();
        for (int i = 0; i < program.variableCount(); ++i) {
            varSet.create();
        }
        int[] nameIndexes = new int[program.variableCount()];
        String[] constants = new String[program.variableCount()];
        Arrays.fill(nameIndexes, -1);
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                if (instruction instanceof InvokeInstruction) {
                    InvokeInstruction invoke = (InvokeInstruction)instruction;
                    if (!invoke.getMethod().equals(getNameMethod) || invoke.getReceiver() == null) continue;
                    nameIndexes[invoke.getReceiver().getIndex()] = invoke.getInstance().getIndex();
                    continue;
                }
                if (instruction instanceof StringConstantInstruction) {
                    StringConstantInstruction stringConstant = (StringConstantInstruction)instruction;
                    constants[stringConstant.getReceiver().getIndex()] = stringConstant.getConstant();
                    continue;
                }
                if (!(instruction instanceof AssignInstruction)) continue;
                AssignInstruction assign = (AssignInstruction)instruction;
                varSet.union(assign.getAssignee().getIndex(), assign.getReceiver().getIndex());
            }
        }
        nameIndexes = Arrays.copyOf(nameIndexes, varSet.size());
        int[] nameRepresentatives = new int[nameIndexes.length];
        Arrays.fill(nameRepresentatives, -1);
        String[] constantsByClasses = new String[varSet.size()];
        for (int i = 0; i < program.variableCount(); ++i) {
            int varClass = varSet.find(i);
            if (nameRepresentatives[varClass] < 0) {
                nameRepresentatives[varClass] = i;
            }
            if (nameIndexes[i] >= 0) {
                nameIndexes[varClass] = varSet.find(nameIndexes[i]);
            }
            constantsByClasses[varClass] = constants[i];
        }
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                Variable representative;
                InvokeInstruction invoke;
                if (!(instruction instanceof InvokeInstruction) || !(invoke = (InvokeInstruction)instruction).getMethod().equals(forNameMethod) && !invoke.getMethod().equals(forNameShortMethod)) continue;
                int classNameIndex = invoke.getArguments().get(0).getIndex();
                int nameIndex = nameIndexes[classNameIndex];
                String constant = constantsByClasses[invoke.getArguments().get(0).getIndex()];
                if (nameIndex >= 0) {
                    representative = program.variableAt(nameRepresentatives[nameIndex]);
                } else {
                    if (constant == null) continue;
                    if (hierarchy.getClassSource().get(constant) == null || !this.filterClassName(constant)) {
                        InvokeInstruction invokeException = new InvokeInstruction();
                        invokeException.setType(InvocationType.SPECIAL);
                        invokeException.setMethod(new MethodReference(ExceptionHelpers.class, "classNotFound", Class.class));
                        invokeException.setReceiver(program.createVariable());
                        invokeException.setLocation(invoke.getLocation());
                        invoke.insertPrevious(invokeException);
                        representative = invokeException.getReceiver();
                    } else {
                        ClassConstantInstruction classConstant = new ClassConstantInstruction();
                        classConstant.setConstant(ValueType.object(constant));
                        classConstant.setReceiver(program.createVariable());
                        classConstant.setLocation(invoke.getLocation());
                        invoke.insertPrevious(classConstant);
                        representative = classConstant.getReceiver();
                    }
                }
                InvokeInstruction initInvoke = new InvokeInstruction();
                initInvoke.setLocation(invoke.getLocation());
                initInvoke.setType(InvocationType.SPECIAL);
                initInvoke.setMethod(initMethod);
                initInvoke.setInstance(representative);
                invoke.insertPrevious(initInvoke);
                if (invoke.getReceiver() == null) {
                    invoke.delete();
                    continue;
                }
                AssignInstruction assign = new AssignInstruction();
                assign.setLocation(invoke.getLocation());
                assign.setAssignee(representative);
                assign.setReceiver(invoke.getReceiver());
                invoke.replace(assign);
            }
        }
    }

    private boolean hasForNameCall(Program program) {
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                InvokeInstruction invoke;
                if (!(instruction instanceof InvokeInstruction) || !(invoke = (InvokeInstruction)instruction).getMethod().equals(forNameMethod) && !invoke.getMethod().equals(forNameShortMethod)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean filterClassName(String className) {
        switch (className) {
            case "kotlin.reflect.jvm.internal.ReflectionFactoryImpl": {
                return false;
            }
        }
        return true;
    }
}

