/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.cache;

import com.antgroup.antchain.myjava.ast.AsyncMethodNode;
import com.antgroup.antchain.myjava.ast.ControlFlowEntry;
import com.antgroup.antchain.myjava.ast.RegularMethodNode;
import com.antgroup.antchain.myjava.cache.AstCacheEntry;
import com.antgroup.antchain.myjava.cache.AstIO;
import com.antgroup.antchain.myjava.cache.CacheStatus;
import com.antgroup.antchain.myjava.cache.InMemorySymbolTable;
import com.antgroup.antchain.myjava.cache.MethodNodeCache;
import com.antgroup.antchain.myjava.cache.VarDataInput;
import com.antgroup.antchain.myjava.cache.VarDataOutput;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ReferenceCache;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class InMemoryMethodNodeCache
implements MethodNodeCache {
    private Map<MethodReference, RegularItem> cache = new HashMap<MethodReference, RegularItem>();
    private Map<MethodReference, RegularItem> newItems = new HashMap<MethodReference, RegularItem>();
    private Map<MethodReference, AsyncItem> asyncCache = new HashMap<MethodReference, AsyncItem>();
    private Map<MethodReference, AsyncItem> newAsyncItems = new HashMap<MethodReference, AsyncItem>();
    private AstIO io;

    public InMemoryMethodNodeCache(ReferenceCache referenceCache, InMemorySymbolTable symbolTable, InMemorySymbolTable fileSymbolTable, InMemorySymbolTable variableSymbolTable) {
        this.io = new AstIO(referenceCache, symbolTable, fileSymbolTable, variableSymbolTable);
    }

    @Override
    public AstCacheEntry get(MethodReference methodReference, CacheStatus cacheStatus) {
        RegularItem item = this.cache.get(methodReference);
        if (item == null) {
            return null;
        }
        if (Arrays.stream(item.dependencies).anyMatch(cacheStatus::isStaleClass)) {
            return null;
        }
        VarDataInput input = new VarDataInput(new ByteArrayInputStream(item.entry));
        try {
            ControlFlowEntry[] cfg = this.io.readControlFlow(input);
            RegularMethodNode ast = this.io.read(input, methodReference);
            return new AstCacheEntry(ast, cfg);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void store(MethodReference methodReference, AstCacheEntry entry, Supplier<String[]> dependencies) {
        this.newItems.put(methodReference, new RegularItem(entry, (String[])dependencies.get().clone()));
    }

    @Override
    public AsyncMethodNode getAsync(MethodReference methodReference, CacheStatus cacheStatus) {
        AsyncItem item = this.asyncCache.get(methodReference);
        if (item == null) {
            return null;
        }
        if (Arrays.stream(item.dependencies).anyMatch(cacheStatus::isStaleClass)) {
            return null;
        }
        VarDataInput input = new VarDataInput(new ByteArrayInputStream(item.node));
        try {
            return this.io.readAsync(input, methodReference);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void storeAsync(MethodReference methodReference, AsyncMethodNode node, Supplier<String[]> dependencies) {
        this.newAsyncItems.put(methodReference, new AsyncItem(node, (String[])dependencies.get().clone()));
    }

    public void commit() {
        this.cache.putAll(this.newItems);
        this.asyncCache.putAll(this.newAsyncItems);
        this.newItems.clear();
        this.newAsyncItems.clear();
    }

    public void discard() {
        this.newItems.clear();
        this.newAsyncItems.clear();
    }

    public void invalidate() {
        this.cache.clear();
        this.newItems.clear();
        this.asyncCache.clear();
        this.newAsyncItems.clear();
    }

    final class AsyncItem {
        final byte[] node;
        final String[] dependencies;

        AsyncItem(AsyncMethodNode node, String[] dependencies) {
            try {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                VarDataOutput data = new VarDataOutput(output);
                InMemoryMethodNodeCache.this.io.writeAsync(data, node);
                this.node = output.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.dependencies = dependencies;
        }
    }

    final class RegularItem {
        final byte[] entry;
        final String[] dependencies;

        RegularItem(AstCacheEntry entry, String[] dependencies) {
            try {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                VarDataOutput data = new VarDataOutput(output);
                InMemoryMethodNodeCache.this.io.write(data, entry.cfg);
                InMemoryMethodNodeCache.this.io.write(data, entry.method);
                this.entry = output.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.dependencies = dependencies;
        }
    }
}

