/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.cache;

import com.antgroup.antchain.myjava.ast.AsyncMethodNode;
import com.antgroup.antchain.myjava.ast.AsyncMethodPart;
import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.ast.QualificationExpr;
import com.antgroup.antchain.myjava.ast.RecursiveVisitor;
import com.antgroup.antchain.myjava.ast.RegularMethodNode;
import java.util.HashSet;
import java.util.Set;

public class AstDependencyExtractor
extends RecursiveVisitor {
    private final ExtractingVisitor visitor = new ExtractingVisitor();

    public String[] extract(RegularMethodNode node) {
        node.getBody().acceptVisitor(this.visitor);
        String[] result = this.visitor.dependencies.toArray(new String[0]);
        this.visitor.dependencies.clear();
        return result;
    }

    public String[] extract(AsyncMethodNode node) {
        for (AsyncMethodPart part : node.getBody()) {
            part.getStatement().acceptVisitor(this.visitor);
        }
        String[] result = this.visitor.dependencies.toArray(new String[0]);
        this.visitor.dependencies.clear();
        return result;
    }

    static final class ExtractingVisitor
    extends RecursiveVisitor {
        final Set<String> dependencies = new HashSet<String>();

        ExtractingVisitor() {
        }

        @Override
        public void visit(InvocationExpr expr) {
            super.visit(expr);
            this.dependencies.add(expr.getMethod().getClassName());
        }

        @Override
        public void visit(QualificationExpr expr) {
            super.visit(expr);
            this.dependencies.add(expr.getField().getClassName());
        }
    }
}

