/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.optimization;

import com.antgroup.antchain.myjava.backend.wasm.generate.WasmClassGenerator;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmModule;
import com.antgroup.antchain.myjava.backend.wasm.render.WasmBinaryVersion;
import com.antgroup.antchain.myjava.utils.MyJavaCoreProperties;
import com.antgroup.antchain.myjava.vm.BuildTarget;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teavm.apachecommons.io.IOUtils;

public class StartOptimizer {
    private static final Logger log = LoggerFactory.getLogger(StartOptimizer.class);
    private final BuildTarget buildTarget;
    private final WasmClassGenerator classGenerator;
    private final WasmModule module;
    private final WasmBinaryVersion wasmVersion;
    private final boolean obfuscated;
    private final String inputWasmPath;
    private final String inputWasmFileRelativePath;
    private String outputWasmFileRelativePath;
    private static String cachedAvailableStartOptimizerToolPath = null;

    public StartOptimizer(BuildTarget buildTarget, WasmClassGenerator classGenerator, WasmModule module, WasmBinaryVersion wasmVersion, boolean obfuscated, String inputWasmPath, String inputWasmFileRelativePath) {
        this.buildTarget = buildTarget;
        this.classGenerator = classGenerator;
        this.module = module;
        this.wasmVersion = wasmVersion;
        this.obfuscated = obfuscated;
        this.inputWasmPath = inputWasmPath;
        this.inputWasmFileRelativePath = inputWasmFileRelativePath;
        this.outputWasmFileRelativePath = null;
    }

    public String getOutputWasmFileRelativePath() {
        return this.outputWasmFileRelativePath;
    }

    private static boolean isMacOS() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.toLowerCase().contains("mac");
    }

    private static boolean isLinux() {
        String osName = System.getProperty("os.name");
        return osName.contains("nix") || osName.contains("nux") || osName.contains("aix");
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.toLowerCase().contains("win");
    }

    private static void tryInstallStartOptimizerTool(String targetPath) throws IOException {
        File targetFile;
        String sourceToolRelativeDir = "tools/start_optimizer";
        if (StartOptimizer.isMacOS()) {
            sourceToolRelativeDir = sourceToolRelativeDir + "/mac/x64";
        } else if (StartOptimizer.isLinux()) {
            sourceToolRelativeDir = sourceToolRelativeDir + "/linux/x64";
        } else if (StartOptimizer.isWindows()) {
            sourceToolRelativeDir = sourceToolRelativeDir + "/win/x64";
        } else {
            throw new IOException("start_optimizer not included in resources now for this platform");
        }
        File targetDir = new File(targetPath).getParentFile();
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        String toolSourceRelativePath = sourceToolRelativeDir + "/" + StartOptimizer.getStartOptimizerToolBaseName();
        try (InputStream toolSourceInput = StartOptimizer.class.getClassLoader().getResourceAsStream(toolSourceRelativePath);
             FileOutputStream output = new FileOutputStream(new File(targetPath), false);){
            if (toolSourceInput == null) {
                throw new IOException("can't find " + toolSourceRelativePath + " included in myjava jar");
            }
            IOUtils.copy(toolSourceInput, (OutputStream)output);
        }
        if (StartOptimizer.isMacOS() || StartOptimizer.isLinux()) {
            log.info("now chmod +x {}", (Object)targetPath);
            ProcessBuilder pb = new ProcessBuilder("chmod", "+x", targetPath);
            Process process = pb.start();
            try {
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    throw new IOException("chmod +x " + targetPath + " failed");
                }
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        if (!(targetFile = new File(targetPath)).exists() || !targetFile.canExecute()) {
            throw new IOException(targetPath + " not installed successfully or not executable");
        }
    }

    private static String getStartOptimizerToolBaseName() {
        String startOptimizerBaseName = "start_optimizer";
        if (StartOptimizer.isWindows()) {
            startOptimizerBaseName = startOptimizerBaseName + ".exe";
        }
        return startOptimizerBaseName;
    }

    private static String getStartOptimizerToolFilenameWithPostfix() {
        String startOptimizerBaseName = StartOptimizer.getStartOptimizerToolBaseName();
        int dotPos = startOptimizerBaseName.lastIndexOf(46);
        String baseName = dotPos >= 0 ? startOptimizerBaseName.substring(0, dotPos) : startOptimizerBaseName;
        String ext = dotPos >= 0 ? startOptimizerBaseName.substring(dotPos) : "";
        String myjavaVersion = MyJavaCoreProperties.getProjectVersion();
        if (myjavaVersion != null) {
            baseName = baseName + "-" + myjavaVersion;
        }
        return baseName + ext;
    }

    private static synchronized String getAvailableStartOptimizerToolPath() {
        String fullPath;
        File file;
        if (cachedAvailableStartOptimizerToolPath != null) {
            return cachedAvailableStartOptimizerToolPath;
        }
        String toolDir = System.getenv("TOOL_HOME");
        if (toolDir == null) {
            String homeDir = System.getProperty("user.home");
            toolDir = Paths.get(homeDir, "tools").toString();
        }
        if (!(file = new File(fullPath = Paths.get(toolDir, StartOptimizer.getStartOptimizerToolFilenameWithPostfix()).toString())).exists()) {
            log.warn("start_optimizer not installed in ~/tools/, now auto installing it");
            try {
                StartOptimizer.tryInstallStartOptimizerTool(fullPath);
                if (!file.exists()) {
                    log.error("install start_optimizer tool failed to " + fullPath);
                }
            }
            catch (IOException e) {
                log.error("install start_optimizer tool failed " + e.getMessage());
                cachedAvailableStartOptimizerToolPath = "";
                return cachedAvailableStartOptimizerToolPath;
            }
        }
        if (!file.canExecute()) {
            log.warn("{} not executable, maybe need run chmod +x {}", (Object)fullPath, (Object)fullPath);
            cachedAvailableStartOptimizerToolPath = "";
            return cachedAvailableStartOptimizerToolPath;
        }
        cachedAvailableStartOptimizerToolPath = fullPath;
        return cachedAvailableStartOptimizerToolPath;
    }

    private String optimizeStartByCommandLineTool(String startOptimizerToolPath) throws Exception {
        log.info("using start_optimizer command line tool to optimize wasm start");
        String optimizedWasmFileName = this.inputWasmFileRelativePath + ".optimized.wasm";
        String optimizedWasmFullPath = this.buildTarget.getFilePath(optimizedWasmFileName);
        ProcessBuilder pb = new ProcessBuilder(startOptimizerToolPath, "-o", optimizedWasmFullPath, this.inputWasmPath);
        pb.directory(new File(this.inputWasmPath).getParentFile());
        pb.redirectErrorStream(true);
        Process process = pb.start();
        int exitCode = process.waitFor();
        if (exitCode == 0) {
            return optimizedWasmFileName;
        }
        String processOutput = IOUtils.toString(process.getInputStream(), StandardCharsets.UTF_8);
        String processError = IOUtils.toString(process.getErrorStream(), StandardCharsets.UTF_8);
        throw new RuntimeException("start_optimizer generate optimized wasm file error " + processOutput + " " + processError);
    }

    public void apply() throws Exception {
        String startOptimizerToolPath = StartOptimizer.getAvailableStartOptimizerToolPath();
        if (startOptimizerToolPath == null || startOptimizerToolPath.isEmpty()) {
            throw new IOException("start_optimizer not installed, install it or disable this option");
        }
        this.outputWasmFileRelativePath = this.optimizeStartByCommandLineTool(startOptimizerToolPath);
    }
}

