/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.javautils;

import com.antgroup.antchain.myjava.backend.wasm.binary.BinaryWriter;
import com.antgroup.antchain.myjava.backend.wasm.binary.DataValue;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassBinarySizeCalculator {
    private static final Logger log = LoggerFactory.getLogger(ClassBinarySizeCalculator.class);
    private Map<String, Integer> classBinaryAppendedSizes = new LinkedHashMap<String, Integer>();
    private Map<String, Integer> functionBinarySizes = new LinkedHashMap<String, Integer>();
    private int segmentsDataTotalSize = 0;

    public void addStringPoolSize(String className, String stringValue) {
        this.addSize(className, stringValue.getBytes(StandardCharsets.UTF_8).length);
    }

    public void addSizeByDataValue(String className, DataValue dataValue) {
        int size = BinaryWriter.getDataTypeOffset(dataValue.getType(), 0);
        this.addSize(className, size);
    }

    public void addSize(String className, int stringSize) {
        int newSize = this.classBinaryAppendedSizes.getOrDefault(className, 0) + stringSize;
        this.classBinaryAppendedSizes.put(className, newSize);
    }

    public void addFunctionSize(String funcName, int size) {
        int newSize = this.functionBinarySizes.getOrDefault(funcName, 0) + size;
        this.functionBinarySizes.put(funcName, newSize);
    }

    public void addSegmentsDataSize(int size) {
        this.segmentsDataTotalSize += size;
    }

    public int logClassesBinarySizes() {
        log.info("-------------- class binary sizes begin --------------");
        int total = 0;
        for (String className : this.classBinaryAppendedSizes.keySet()) {
            int size = this.classBinaryAppendedSizes.get(className);
            log.info(String.format("class %s size %d", className, size));
            total += size;
        }
        log.info("------------------------------------------------------");
        int totalFuncsSize = 0;
        for (String funcName : this.functionBinarySizes.keySet()) {
            int size = this.functionBinarySizes.get(funcName);
            log.info(String.format("func %s size %d", funcName, size));
            totalFuncsSize += size;
        }
        log.info(String.format("classes count %d, meta total size: %d bytes", this.classBinaryAppendedSizes.size(), total));
        log.info(String.format("functions count %d, total size: %d bytes", this.functionBinarySizes.size(), totalFuncsSize));
        log.info(String.format("data segments total size: %d bytes", this.segmentsDataTotalSize));
        log.info("-------------- class binary sizes ended --------------");
        return total + totalFuncsSize;
    }
}

