/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.intrinsics;

import com.antgroup.antchain.myjava.ast.ConstantExpr;
import com.antgroup.antchain.myjava.ast.Expr;
import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGenerationContext;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGeneratorUtil;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsicManager;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmGlobal;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmType;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmCall;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpression;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmFloatBinary;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmFloatBinaryOperation;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmFloatType;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmFloatUnary;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmFloatUnaryOperation;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmGetGlobal;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIndirectCall;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt32Constant;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntBinary;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntBinaryOperation;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntType;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntUnary;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntUnaryOperation;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmSetGlobal;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmUnreachable;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.runtime.WasmRuntime;

public class WasmRuntimeIntrinsic
implements WasmIntrinsic {
    private static final String INVOKE_VOID_INDIRECT_METHOD_PREFIX = "invokeVoidIndirect";
    private static final String INVOKE_INDIRECT_METHOD_PREFIX = "invokeIndirect";
    private static final String INVOKE_SPECIAL_VOID_INDIRECT_METHOD_PREFIX = "invokeSpecialVoidIndirect";
    private static final String INVOKE_SPECIAL_INDIRECT_METHOD_PREFIX = "invokeSpecialIndirect";

    @Override
    public boolean isApplicable(WasmGenerationContext ctx, MethodReference methodReference) {
        String methodName;
        if (!methodReference.getClassName().equals(WasmRuntime.class.getName())) {
            return false;
        }
        switch (methodName = methodReference.getName()) {
            case "gt": 
            case "lt": 
            case "initStack": 
            case "addressToObject": 
            case "inWasmRuntime": 
            case "abortUnreachable": 
            case "getWrapperBodyAddress": 
            case "numberOfLeadingZerosOfInt32": 
            case "numberOfLeadingZerosOfInt64": 
            case "numberOfTrailingZerosOfInt32": 
            case "numberOfTrailingZerosOfInt64": 
            case "bigCountOfInt32": 
            case "bigCountOfInt64": 
            case "rotateLeftOfInt32": 
            case "rotateLeftOfInt64": 
            case "rotateRightOfInt32": 
            case "rotateRightOfInt64": 
            case "absOfFloat32": 
            case "absOfFloat64": 
            case "ceilOfFloat64": 
            case "floorOfFloat64": 
            case "sqrtOfFloat64": 
            case "minOfFloat32": 
            case "maxOfFloat32": 
            case "minOfFloat64": 
            case "maxOfFloat64": 
            case "copySignOfFloat32": 
            case "copySignOfFloat64": 
            case "setInt32Global": 
            case "setInt64Global": 
            case "getInt32Global": 
            case "getInt64Global": {
                return true;
            }
        }
        return methodName.startsWith(INVOKE_VOID_INDIRECT_METHOD_PREFIX) || methodName.startsWith(INVOKE_INDIRECT_METHOD_PREFIX) || methodName.startsWith(INVOKE_SPECIAL_VOID_INDIRECT_METHOD_PREFIX) || methodName.startsWith(INVOKE_SPECIAL_INDIRECT_METHOD_PREFIX);
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        String methodName;
        switch (methodName = invocation.getMethod().getName()) {
            case "lt": {
                return WasmRuntimeIntrinsic.comparison(WasmIntBinaryOperation.LT_SIGNED, WasmFloatBinaryOperation.LT, invocation, manager);
            }
            case "gt": {
                return WasmRuntimeIntrinsic.comparison(WasmIntBinaryOperation.GT_SIGNED, WasmFloatBinaryOperation.GT, invocation, manager);
            }
            case "addressToObject": {
                return manager.generate(invocation.getArguments().get(0));
            }
            case "inWasmRuntime": {
                return new WasmInt32Constant(1);
            }
            case "abortUnreachable": {
                return new WasmUnreachable();
            }
            case "getWrapperBodyAddress": {
                WasmCall call = new WasmCall("myjava_wrapperBody", true);
                WasmExpression arg = manager.generate(invocation.getArguments().get(0));
                call.getArguments().add(arg);
                return call;
            }
            case "numberOfLeadingZerosOfInt32": {
                WasmExpression arg = manager.generate(invocation.getArguments().get(0));
                WasmIntUnary expr = new WasmIntUnary(WasmIntType.INT32, WasmIntUnaryOperation.CLZ, arg);
                return expr;
            }
            case "numberOfLeadingZerosOfInt64": {
                WasmExpression arg = manager.generate(invocation.getArguments().get(0));
                WasmIntUnary expr = new WasmIntUnary(WasmIntType.INT64, WasmIntUnaryOperation.CLZ, arg);
                return expr;
            }
            case "numberOfTrailingZerosOfInt32": {
                WasmExpression arg = manager.generate(invocation.getArguments().get(0));
                WasmIntUnary expr = new WasmIntUnary(WasmIntType.INT32, WasmIntUnaryOperation.CTZ, arg);
                return expr;
            }
            case "numberOfTrailingZerosOfInt64": {
                WasmExpression arg = manager.generate(invocation.getArguments().get(0));
                WasmIntUnary expr = new WasmIntUnary(WasmIntType.INT64, WasmIntUnaryOperation.CTZ, arg);
                return expr;
            }
            case "bigCountOfInt32": {
                WasmExpression arg = manager.generate(invocation.getArguments().get(0));
                WasmIntUnary expr = new WasmIntUnary(WasmIntType.INT32, WasmIntUnaryOperation.POPCNT, arg);
                return expr;
            }
            case "bigCountOfInt64": {
                WasmExpression arg = manager.generate(invocation.getArguments().get(0));
                WasmIntUnary expr = new WasmIntUnary(WasmIntType.INT64, WasmIntUnaryOperation.POPCNT, arg);
                return expr;
            }
            case "rotateLeftOfInt32": {
                WasmExpression arg0 = manager.generate(invocation.getArguments().get(0));
                WasmExpression arg1 = manager.generate(invocation.getArguments().get(1));
                return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ROTL, arg0, arg1);
            }
            case "rotateLeftOfInt64": {
                WasmExpression arg0 = manager.generate(invocation.getArguments().get(0));
                WasmExpression arg1 = manager.generate(invocation.getArguments().get(1));
                return new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.ROTL, arg0, arg1);
            }
            case "rotateRightOfInt32": {
                WasmExpression arg0 = manager.generate(invocation.getArguments().get(0));
                WasmExpression arg1 = manager.generate(invocation.getArguments().get(1));
                return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ROTR, arg0, arg1);
            }
            case "rotateRightOfInt64": {
                WasmExpression arg0 = manager.generate(invocation.getArguments().get(0));
                WasmExpression arg1 = manager.generate(invocation.getArguments().get(1));
                return new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.ROTR, arg0, arg1);
            }
            case "absOfFloat32": {
                WasmExpression arg = manager.generate(invocation.getArguments().get(0));
                return new WasmFloatUnary(WasmFloatType.FLOAT32, WasmFloatUnaryOperation.ABS, arg);
            }
            case "absOfFloat64": {
                WasmExpression arg = manager.generate(invocation.getArguments().get(0));
                return new WasmFloatUnary(WasmFloatType.FLOAT64, WasmFloatUnaryOperation.ABS, arg);
            }
            case "ceilOfFloat64": {
                WasmExpression arg = manager.generate(invocation.getArguments().get(0));
                return new WasmFloatUnary(WasmFloatType.FLOAT64, WasmFloatUnaryOperation.CEIL, arg);
            }
            case "floorOfFloat64": {
                WasmExpression arg = manager.generate(invocation.getArguments().get(0));
                return new WasmFloatUnary(WasmFloatType.FLOAT64, WasmFloatUnaryOperation.FLOOR, arg);
            }
            case "sqrtOfFloat64": {
                WasmExpression arg = manager.generate(invocation.getArguments().get(0));
                return new WasmFloatUnary(WasmFloatType.FLOAT64, WasmFloatUnaryOperation.SQRT, arg);
            }
            case "minOfFloat32": {
                WasmExpression arg0 = manager.generate(invocation.getArguments().get(0));
                WasmExpression arg1 = manager.generate(invocation.getArguments().get(1));
                return new WasmFloatBinary(WasmFloatType.FLOAT32, WasmFloatBinaryOperation.MIN, arg0, arg1);
            }
            case "maxOfFloat32": {
                WasmExpression arg0 = manager.generate(invocation.getArguments().get(0));
                WasmExpression arg1 = manager.generate(invocation.getArguments().get(1));
                return new WasmFloatBinary(WasmFloatType.FLOAT32, WasmFloatBinaryOperation.MAX, arg0, arg1);
            }
            case "minOfFloat64": {
                WasmExpression arg0 = manager.generate(invocation.getArguments().get(0));
                WasmExpression arg1 = manager.generate(invocation.getArguments().get(1));
                return new WasmFloatBinary(WasmFloatType.FLOAT64, WasmFloatBinaryOperation.MIN, arg0, arg1);
            }
            case "maxOfFloat64": {
                WasmExpression arg0 = manager.generate(invocation.getArguments().get(0));
                WasmExpression arg1 = manager.generate(invocation.getArguments().get(1));
                return new WasmFloatBinary(WasmFloatType.FLOAT64, WasmFloatBinaryOperation.MAX, arg0, arg1);
            }
            case "copySignOfFloat32": {
                WasmExpression arg0 = manager.generate(invocation.getArguments().get(0));
                WasmExpression arg1 = manager.generate(invocation.getArguments().get(1));
                return new WasmFloatBinary(WasmFloatType.FLOAT32, WasmFloatBinaryOperation.COPYSIGN, arg0, arg1);
            }
            case "copySignOfFloat64": {
                WasmExpression arg0 = manager.generate(invocation.getArguments().get(0));
                WasmExpression arg1 = manager.generate(invocation.getArguments().get(1));
                return new WasmFloatBinary(WasmFloatType.FLOAT64, WasmFloatBinaryOperation.COPYSIGN, arg0, arg1);
            }
            case "setInt32Global": {
                Expr indexExpr = invocation.getArguments().get(0);
                if (!(indexExpr instanceof ConstantExpr)) {
                    throw new RuntimeException("global set/get api only accept int32 constant as argument index");
                }
                ConstantExpr indexConstExpr = (ConstantExpr)indexExpr;
                int index = (Integer)indexConstExpr.getValue();
                WasmExpression value = manager.generate(invocation.getArguments().get(1));
                return new WasmSetGlobal(new WasmGlobal(WasmType.INT32, index), value);
            }
            case "setInt64Global": {
                Expr indexExpr = invocation.getArguments().get(0);
                if (!(indexExpr instanceof ConstantExpr)) {
                    throw new RuntimeException("global set/get api only accept int32 constant as argument index");
                }
                ConstantExpr indexConstExpr = (ConstantExpr)indexExpr;
                int index = (Integer)indexConstExpr.getValue();
                WasmExpression value = manager.generate(invocation.getArguments().get(1));
                return new WasmSetGlobal(new WasmGlobal(WasmType.INT64, index), value);
            }
            case "getInt32Global": {
                Expr indexExpr = invocation.getArguments().get(0);
                if (!(indexExpr instanceof ConstantExpr)) {
                    throw new RuntimeException("global set/get api only accept int32 constant as argument index");
                }
                ConstantExpr indexConstExpr = (ConstantExpr)indexExpr;
                int index = (Integer)indexConstExpr.getValue();
                return new WasmGetGlobal(new WasmGlobal(WasmType.INT32, index));
            }
            case "getInt64Global": {
                Expr indexExpr = invocation.getArguments().get(0);
                if (!(indexExpr instanceof ConstantExpr)) {
                    throw new RuntimeException("global set/get api only accept int32 constant as argument index");
                }
                ConstantExpr indexConstExpr = (ConstantExpr)indexExpr;
                int index = (Integer)indexConstExpr.getValue();
                return new WasmGetGlobal(new WasmGlobal(WasmType.INT64, index));
            }
        }
        if (methodName.startsWith(INVOKE_SPECIAL_VOID_INDIRECT_METHOD_PREFIX)) {
            String remaining = methodName.substring(INVOKE_SPECIAL_VOID_INDIRECT_METHOD_PREFIX.length());
            String numStr = remaining.substring(0, remaining.indexOf("With"));
            int argsCount = Integer.parseInt(numStr);
            remaining = remaining.substring(numStr.length() + "With".length());
            String[] paramTypesInMethodName = new String[argsCount];
            for (int i = 0; i < argsCount; ++i) {
                String item;
                if (remaining.startsWith("Int")) {
                    item = "Int";
                } else if (remaining.startsWith("Long")) {
                    item = "Long";
                } else {
                    throw new RuntimeException("unknown invoke special indirect method " + methodName);
                }
                paramTypesInMethodName[i] = item;
                remaining = remaining.substring(item.length());
            }
            WasmExpression selector = manager.generate(invocation.getArguments().get(0));
            WasmIndirectCall indirectCall = new WasmIndirectCall(selector);
            for (int i = 0; i < argsCount; ++i) {
                if (paramTypesInMethodName[i].equals("Long")) {
                    indirectCall.getParameterTypes().add(WasmType.INT64);
                } else {
                    indirectCall.getParameterTypes().add(WasmType.INT32);
                }
                WasmExpression argExpr = manager.generate(invocation.getArguments().get(1 + i));
                indirectCall.getArguments().add(argExpr);
            }
            return indirectCall;
        }
        if (methodName.startsWith(INVOKE_SPECIAL_INDIRECT_METHOD_PREFIX)) {
            String remaining = methodName.substring(INVOKE_SPECIAL_INDIRECT_METHOD_PREFIX.length());
            String numStr = remaining.substring(0, remaining.indexOf("Return"));
            int argsCount = Integer.parseInt(numStr);
            remaining = remaining.substring(numStr.length() + "Return".length());
            String funcNameReturnTypeStr = remaining.substring(0, remaining.indexOf("With"));
            remaining = remaining.substring(funcNameReturnTypeStr.length() + "With".length());
            String[] paramTypesInMethodName = new String[argsCount];
            for (int i = 0; i < argsCount; ++i) {
                String item;
                if (remaining.startsWith("Int")) {
                    item = "Int";
                } else if (remaining.startsWith("Long")) {
                    item = "Long";
                } else {
                    throw new RuntimeException("unknown invoke special indirect method " + methodName);
                }
                paramTypesInMethodName[i] = item;
                remaining = remaining.substring(item.length());
            }
            WasmExpression selector = manager.generate(invocation.getArguments().get(0));
            WasmIndirectCall indirectCall = new WasmIndirectCall(selector);
            if ("Long".equals(funcNameReturnTypeStr)) {
                indirectCall.setReturnType(WasmType.INT64);
            } else {
                indirectCall.setReturnType(WasmType.INT32);
            }
            for (int i = 0; i < argsCount; ++i) {
                if (paramTypesInMethodName[i].equals("Long")) {
                    indirectCall.getParameterTypes().add(WasmType.INT64);
                } else {
                    indirectCall.getParameterTypes().add(WasmType.INT32);
                }
                WasmExpression argExpr = manager.generate(invocation.getArguments().get(1 + i));
                indirectCall.getArguments().add(argExpr);
            }
            return indirectCall;
        }
        if (methodName.startsWith(INVOKE_VOID_INDIRECT_METHOD_PREFIX)) {
            int argsCount = Integer.parseInt(methodName.substring(INVOKE_VOID_INDIRECT_METHOD_PREFIX.length()));
            WasmExpression selector = manager.generate(invocation.getArguments().get(0));
            WasmIndirectCall indirectCall = new WasmIndirectCall(selector);
            for (int i = 0; i < argsCount; ++i) {
                indirectCall.getParameterTypes().add(WasmType.INT32);
                WasmExpression argExpr = manager.generate(invocation.getArguments().get(1 + i));
                indirectCall.getArguments().add(argExpr);
            }
            return indirectCall;
        }
        if (methodName.startsWith(INVOKE_INDIRECT_METHOD_PREFIX)) {
            int argsCount = Integer.parseInt(methodName.substring(INVOKE_INDIRECT_METHOD_PREFIX.length()));
            WasmExpression selector = manager.generate(invocation.getArguments().get(0));
            WasmIndirectCall indirectCall = new WasmIndirectCall(selector);
            indirectCall.setReturnType(WasmType.INT32);
            for (int i = 0; i < argsCount; ++i) {
                indirectCall.getParameterTypes().add(WasmType.INT32);
                WasmExpression argExpr = manager.generate(invocation.getArguments().get(1 + i));
                indirectCall.getArguments().add(argExpr);
            }
            return indirectCall;
        }
        throw new IllegalArgumentException(invocation.getMethod().getName());
    }

    private static WasmExpression comparison(WasmIntBinaryOperation intOp, WasmFloatBinaryOperation floatOp, InvocationExpr invocation, WasmIntrinsicManager manager) {
        WasmType type = WasmGeneratorUtil.mapType(invocation.getMethod().parameterType(0));
        WasmExpression first = manager.generate(invocation.getArguments().get(0));
        WasmExpression second = manager.generate(invocation.getArguments().get(1));
        switch (type) {
            case INT32: {
                return new WasmIntBinary(WasmIntType.INT32, intOp, first, second);
            }
            case INT64: {
                return new WasmIntBinary(WasmIntType.INT64, intOp, first, second);
            }
            case FLOAT32: {
                return new WasmFloatBinary(WasmFloatType.FLOAT32, floatOp, first, second);
            }
            case FLOAT64: {
                return new WasmFloatBinary(WasmFloatType.FLOAT64, floatOp, first, second);
            }
        }
        throw new IllegalArgumentException(type.toString());
    }
}

