/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.intrinsics;

import com.antgroup.antchain.myjava.ast.ConstantExpr;
import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmClassGenerator;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGenerationContext;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsicManager;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpression;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt32Constant;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntBinary;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntBinaryOperation;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntType;
import com.antgroup.antchain.myjava.interop.Structure;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ValueType;

public class StructureIntrinsic
implements WasmIntrinsic {
    private ClassReaderSource classSource;
    private WasmClassGenerator classGenerator;

    public StructureIntrinsic(ClassReaderSource classSource, WasmClassGenerator classGenerator) {
        this.classSource = classSource;
        this.classGenerator = classGenerator;
    }

    @Override
    public boolean isApplicable(WasmGenerationContext ctx, MethodReference methodReference) {
        if (!this.classSource.isSuperType(Structure.class.getName(), methodReference.getClassName()).orElse(false).booleanValue()) {
            return false;
        }
        switch (methodReference.getName()) {
            case "toAddress": 
            case "cast": 
            case "sizeOf": 
            case "add": {
                return true;
            }
        }
        return false;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "toAddress": 
            case "cast": {
                return manager.generate(invocation.getArguments().get(0));
            }
            case "sizeOf": {
                ValueType.Object type = (ValueType.Object)((ConstantExpr)invocation.getArguments().get(0)).getValue();
                return new WasmInt32Constant(this.classGenerator.getClassSize(type.getClassName()));
            }
            case "add": {
                WasmExpression base = manager.generate(invocation.getArguments().get(1));
                WasmExpression offset = manager.generate(invocation.getArguments().get(2));
                Object type = ((ConstantExpr)invocation.getArguments().get(0)).getValue();
                String className = ((ValueType.Object)type).getClassName();
                int size = this.classGenerator.getClassSize(className);
                int alignment = this.classGenerator.getClassAlignment(className);
                size = WasmClassGenerator.align(size, alignment);
                offset = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.MUL, offset, new WasmInt32Constant(size));
                return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, base, offset);
            }
        }
        throw new IllegalArgumentException(invocation.getMethod().toString());
    }
}

