/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.intrinsics;

import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGenerationContext;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsicManager;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpression;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt32Constant;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntBinary;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntBinaryOperation;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntType;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.runtime.RuntimeClass;

public class RuntimeClassIntrinsic
implements WasmIntrinsic {
    @Override
    public boolean isApplicable(WasmGenerationContext ctx, MethodReference methodReference) {
        if (!methodReference.getClassName().equals(RuntimeClass.class.getName())) {
            return false;
        }
        switch (methodReference.getName()) {
            case "pack": 
            case "unpack": 
            case "fromClass": {
                return true;
            }
        }
        return false;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "pack": {
                return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHR_UNSIGNED, manager.generate(invocation.getArguments().get(0)), new WasmInt32Constant(3));
            }
            case "unpack": {
                return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, manager.generate(invocation.getArguments().get(0)), new WasmInt32Constant(3));
            }
            case "fromClass": {
                return manager.generate(invocation.getArguments().get(0));
            }
        }
        throw new AssertionError();
    }
}

