/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.intrinsics;

import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGenerationContext;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsicManager;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpression;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt32Constant;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.runtime.Mutator;
import java.util.ArrayList;
import java.util.List;

public class MutatorIntrinsic
implements WasmIntrinsic {
    private List<WasmInt32Constant> staticGcRootsExpressions = new ArrayList<WasmInt32Constant>();
    private List<WasmInt32Constant> classesExpressions = new ArrayList<WasmInt32Constant>();
    private List<WasmInt32Constant> classCountExpressions = new ArrayList<WasmInt32Constant>();

    public void setStaticGcRootsAddress(int address) {
        for (WasmInt32Constant constant : this.staticGcRootsExpressions) {
            constant.setValue(address);
        }
    }

    public void setClassesAddress(int address) {
        for (WasmInt32Constant constant : this.classesExpressions) {
            constant.setValue(address);
        }
    }

    public void setClassCount(int count) {
        for (WasmInt32Constant constant : this.classCountExpressions) {
            constant.setValue(count);
        }
    }

    @Override
    public boolean isApplicable(WasmGenerationContext ctx, MethodReference methodReference) {
        if (!methodReference.getClassName().equals(Mutator.class.getName())) {
            return false;
        }
        switch (methodReference.getName()) {
            case "getStaticGCRoots": 
            case "getClasses": 
            case "getClassCount": {
                return true;
            }
        }
        return false;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "getStaticGCRoots": {
                WasmInt32Constant constant = new WasmInt32Constant(0);
                this.staticGcRootsExpressions.add(constant);
                return constant;
            }
            case "getClasses": {
                WasmInt32Constant constant = new WasmInt32Constant(0);
                this.classesExpressions.add(constant);
                return constant;
            }
            case "getClassCount": {
                WasmInt32Constant constant = new WasmInt32Constant(0);
                this.classCountExpressions.add(constant);
                return constant;
            }
        }
        throw new IllegalArgumentException(invocation.getMethod().toString());
    }
}

