/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.intrinsics;

import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmClassGenerator;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGenerationContext;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGeneratorUtil;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsicManager;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpression;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIndirectCall;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ValueType;

public class FunctionIntrinsic
implements WasmIntrinsic {
    private WasmClassGenerator classGenerator;

    public FunctionIntrinsic(WasmClassGenerator classGenerator) {
        this.classGenerator = classGenerator;
    }

    @Override
    public boolean isApplicable(WasmGenerationContext ctx, MethodReference methodReference) {
        return this.classGenerator.isFunctionClass(methodReference.getClassName());
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        WasmExpression selector = manager.generate(invocation.getArguments().get(0));
        WasmIndirectCall call = new WasmIndirectCall(selector);
        for (ValueType type : invocation.getMethod().getParameterTypes()) {
            call.getParameterTypes().add(WasmGeneratorUtil.mapType(type));
        }
        if (invocation.getMethod().getReturnType() != ValueType.VOID) {
            call.setReturnType(WasmGeneratorUtil.mapType(invocation.getMethod().getReturnType()));
        }
        for (int i = 1; i < invocation.getArguments().size(); ++i) {
            call.getArguments().add(manager.generate(invocation.getArguments().get(i)));
        }
        return call;
    }
}

