/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.generate;

import com.antgroup.antchain.myjava.backend.wasm.generate.WasmClassGenerator;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmFunction;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmModule;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmType;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt32Constant;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt32Subtype;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmLoadInt32;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmReturn;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.runtime.WasmHeap;

public class WasmSpecialFunctionGenerator {
    private WasmClassGenerator classGenerator;

    public WasmSpecialFunctionGenerator(WasmClassGenerator classGenerator) {
        this.classGenerator = classGenerator;
    }

    public void generateSpecialFunctions(WasmModule module) {
        module.add(this.javaHeapAddress());
        module.add(this.availableBytes());
        module.add(this.storageAddress());
        module.add(this.storageSize());
    }

    private WasmFunction javaHeapAddress() {
        WasmFunction function = new WasmFunction("myjava_javaHeapAddress");
        function.setExportName("myjava_javaHeapAddress");
        function.setResult(WasmType.INT32);
        int address = this.classGenerator.getFieldOffset(new FieldReference(WasmHeap.class.getName(), "heapAddress"));
        function.getBody().add(new WasmReturn(new WasmLoadInt32(4, new WasmInt32Constant(address), WasmInt32Subtype.INT32)));
        return function;
    }

    private WasmFunction availableBytes() {
        WasmFunction function = new WasmFunction("myjava_availableBytes");
        function.setExportName("myjava_availableBytes");
        function.setResult(WasmType.INT32);
        int address = this.classGenerator.getFieldOffset(new FieldReference(WasmHeap.class.getName(), "heapSize"));
        function.getBody().add(new WasmReturn(new WasmLoadInt32(4, new WasmInt32Constant(address), WasmInt32Subtype.INT32)));
        return function;
    }

    private WasmFunction storageAddress() {
        WasmFunction function = new WasmFunction("myjava_storageAddress");
        function.setExportName("myjava_storageAddress");
        function.setResult(WasmType.INT32);
        int address = this.classGenerator.getFieldOffset(new FieldReference(WasmHeap.class.getName(), "heapAddress"));
        function.getBody().add(new WasmReturn(new WasmLoadInt32(4, new WasmInt32Constant(address), WasmInt32Subtype.INT32)));
        return function;
    }

    private WasmFunction storageSize() {
        WasmFunction function = new WasmFunction("myjava_storageSize");
        function.setExportName("myjava_storageSize");
        function.setResult(WasmType.INT32);
        int address = this.classGenerator.getFieldOffset(new FieldReference(WasmHeap.class.getName(), "storageSize"));
        function.getBody().add(new WasmReturn(new WasmLoadInt32(4, new WasmInt32Constant(address), WasmInt32Subtype.INT32)));
        return function;
    }
}

