/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.generate;

import com.antgroup.antchain.myjava.backend.wasm.generate.WasmClassGenerator;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmFunction;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmLocal;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmModule;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmType;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmCall;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmGetLocal;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt32Constant;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt32Subtype;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntBinary;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntBinaryOperation;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntType;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmLoadInt32;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmReturn;
import com.antgroup.antchain.myjava.interop.Address;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.runtime.Allocator;
import com.antgroup.antchain.myjava.runtime.IntWrapper;
import com.antgroup.antchain.myjava.runtime.RuntimeArray;
import com.antgroup.antchain.myjava.runtime.RuntimeClass;

public class WasmInteropFunctionGenerator {
    private WasmClassGenerator classGenerator;

    public WasmInteropFunctionGenerator(WasmClassGenerator classGenerator) {
        this.classGenerator = classGenerator;
    }

    public void generateFunctions(WasmModule module) {
        module.add(this.allocateString());
        module.add(this.stringData());
        module.add(this.wrapperBody());
        module.add(this.allocateArray("myjava_allocateObjectArray", ValueType.parse(Object.class)));
        module.add(this.allocateArray("myjava_allocateStringArray", ValueType.parse(String.class)));
        module.add(this.allocateArray("myjava_allocateByteArray", ValueType.parse(Byte.TYPE)));
        module.add(this.allocateArray("myjava_allocateShortArray", ValueType.parse(Short.TYPE)));
        module.add(this.allocateArray("myjava_allocateCharArray", ValueType.parse(Character.TYPE)));
        module.add(this.allocateArray("myjava_allocateIntArray", ValueType.parse(Integer.TYPE)));
        module.add(this.allocateArray("myjava_allocateLongArray", ValueType.parse(Long.TYPE)));
        module.add(this.allocateArray("myjava_allocateFloatArray", ValueType.parse(Float.TYPE)));
        module.add(this.allocateArray("myjava_allocateDoubleArray", ValueType.parse(Double.TYPE)));
        module.add(this.arrayData("myjava_objectArrayData", 4));
        module.add(this.arrayData("myjava_byteArrayData", 1));
        module.add(this.arrayData("myjava_shortArrayData", 2));
        module.add(this.arrayData("myjava_charArrayData", 2));
        module.add(this.arrayData("myjava_intArrayData", 4));
        module.add(this.arrayData("myjava_longArrayData", 8));
        module.add(this.arrayData("myjava_floatArrayData", 4));
        module.add(this.arrayData("myjava_doubleArrayData", 8));
        module.add(this.arrayLength());
    }

    private WasmFunction allocateString() {
        WasmFunction function = new WasmFunction("myjava_allocateString");
        function.setExportName(function.getName());
        function.setResult(WasmType.INT32);
        function.getParameters().add(WasmType.INT32);
        WasmLocal sizeLocal = new WasmLocal(WasmType.INT32, "size");
        function.add(sizeLocal);
        String constructorName = this.classGenerator.names.forMethod(new MethodReference(String.class, "allocate", Integer.TYPE, String.class));
        WasmCall constructorCall = new WasmCall(constructorName);
        constructorCall.getArguments().add(new WasmGetLocal(sizeLocal));
        function.getBody().add(constructorCall);
        function.getBody().add(new WasmReturn(constructorCall));
        return function;
    }

    private WasmFunction allocateArray(String name, ValueType type) {
        WasmFunction function = new WasmFunction(name);
        function.setExportName(name);
        function.setResult(WasmType.INT32);
        function.getParameters().add(WasmType.INT32);
        WasmLocal sizeLocal = new WasmLocal(WasmType.INT32, "size");
        function.add(sizeLocal);
        int classPointer = this.classGenerator.getClassPointer(ValueType.arrayOf(type));
        String allocName = this.classGenerator.names.forMethod(new MethodReference(Allocator.class, "allocateArray", RuntimeClass.class, Integer.TYPE, Address.class));
        WasmCall call = new WasmCall(allocName);
        call.getArguments().add(new WasmInt32Constant(classPointer));
        call.getArguments().add(new WasmGetLocal(sizeLocal));
        function.getBody().add(new WasmReturn(call));
        return function;
    }

    private WasmFunction stringData() {
        WasmFunction function = new WasmFunction("myjava_stringData");
        function.setExportName(function.getName());
        function.setResult(WasmType.INT32);
        function.getParameters().add(WasmType.INT32);
        WasmLocal stringLocal = new WasmLocal(WasmType.INT32, "string");
        function.add(stringLocal);
        int offset = this.classGenerator.getFieldOffset(new FieldReference("java.lang.String", "characters"));
        WasmLoadInt32 chars = new WasmLoadInt32(4, new WasmGetLocal(stringLocal), WasmInt32Subtype.INT32, offset);
        function.getBody().add(new WasmReturn(chars));
        return function;
    }

    private WasmFunction wrapperBody() {
        WasmFunction function = new WasmFunction("myjava_wrapperBody");
        function.setExportName(function.getName());
        function.setResult(WasmType.INT32);
        function.getParameters().add(WasmType.INT32);
        WasmLocal wrapperLocal = new WasmLocal(WasmType.INT32, "wrapper");
        function.add(wrapperLocal);
        int offset = this.classGenerator.getFieldOffset(new FieldReference(IntWrapper.class.getName(), "value"));
        WasmIntBinary ptr = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, new WasmGetLocal(wrapperLocal), new WasmInt32Constant(offset));
        function.getBody().add(new WasmReturn(ptr));
        return function;
    }

    private WasmFunction arrayData(String name, int alignment) {
        WasmFunction function = new WasmFunction(name);
        function.setExportName(function.getName());
        function.setResult(WasmType.INT32);
        function.getParameters().add(WasmType.INT32);
        WasmLocal arrayLocal = new WasmLocal(WasmType.INT32, "array");
        function.add(arrayLocal);
        int start = WasmClassGenerator.align(this.classGenerator.getClassSize(RuntimeArray.class.getName()), alignment);
        WasmIntBinary data = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, new WasmGetLocal(arrayLocal), new WasmInt32Constant(start));
        function.getBody().add(new WasmReturn(data));
        return function;
    }

    private WasmFunction arrayLength() {
        WasmFunction function = new WasmFunction("myjava_arrayLength");
        function.setExportName(function.getName());
        function.setResult(WasmType.INT32);
        function.getParameters().add(WasmType.INT32);
        WasmLocal arrayLocal = new WasmLocal(WasmType.INT32, "array");
        function.add(arrayLocal);
        int sizeOffset = this.classGenerator.getFieldOffset(new FieldReference(RuntimeArray.class.getName(), "size"));
        WasmIntBinary ptr = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, new WasmGetLocal(arrayLocal), new WasmInt32Constant(sizeOffset));
        WasmLoadInt32 length = new WasmLoadInt32(4, ptr, WasmInt32Subtype.INT32);
        function.getBody().add(new WasmReturn(length));
        return function;
    }
}

