/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.generate;

import com.antgroup.antchain.myjava.ast.OperationType;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmType;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.util.VariableType;

public final class WasmGeneratorUtil {
    private WasmGeneratorUtil() {
    }

    public static WasmType mapType(OperationType type) {
        switch (type) {
            case INT: {
                return WasmType.INT32;
            }
            case LONG: {
                return WasmType.INT64;
            }
            case FLOAT: {
                return WasmType.FLOAT32;
            }
            case DOUBLE: {
                return WasmType.FLOAT64;
            }
        }
        throw new IllegalArgumentException(type.toString());
    }

    public static WasmType mapType(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case CHARACTER: 
                case INTEGER: {
                    return WasmType.INT32;
                }
                case LONG: {
                    return WasmType.INT64;
                }
                case FLOAT: {
                    return WasmType.FLOAT32;
                }
                case DOUBLE: {
                    return WasmType.FLOAT64;
                }
            }
        } else if (type == ValueType.VOID) {
            return null;
        }
        return WasmType.INT32;
    }

    public static WasmType mapType(VariableType type) {
        switch (type) {
            case INT: {
                return WasmType.INT32;
            }
            case LONG: {
                return WasmType.INT64;
            }
            case FLOAT: {
                return WasmType.FLOAT32;
            }
            case DOUBLE: {
                return WasmType.FLOAT64;
            }
        }
        return WasmType.INT32;
    }
}

