/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.binary;

import com.antgroup.antchain.myjava.backend.wasm.binary.DataArray;
import com.antgroup.antchain.myjava.backend.wasm.binary.DataPrimitives;
import com.antgroup.antchain.myjava.backend.wasm.binary.DataStructure;
import com.antgroup.antchain.myjava.backend.wasm.binary.DataType;
import com.antgroup.antchain.myjava.backend.wasm.binary.DataValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BinaryWriter {
    private int address;
    private List<DataValue> values = new ArrayList<DataValue>();

    public BinaryWriter(int start) {
        this.address = start;
    }

    public int append(DataValue value) {
        int result = BinaryWriter.align(this.address, this.getAlignment(value.getType()));
        this.values.add(value);
        this.address = this.offset(value.getType(), result);
        return result;
    }

    public int getAddress() {
        return this.address;
    }

    private int offset(DataType type, int index) {
        return BinaryWriter.getDataTypeOffset(type, index);
    }

    public static int getDataTypeOffset(DataType type, int index) {
        if (type == DataPrimitives.BYTE) {
            return index + 1;
        }
        if (type == DataPrimitives.SHORT) {
            return BinaryWriter.align(index, 2) + 2;
        }
        if (type == DataPrimitives.INT) {
            return BinaryWriter.align(index, 4) + 4;
        }
        if (type == DataPrimitives.LONG) {
            return BinaryWriter.align(index, 8) + 8;
        }
        if (type == DataPrimitives.FLOAT) {
            return BinaryWriter.align(index, 4) + 4;
        }
        if (type == DataPrimitives.DOUBLE) {
            return BinaryWriter.align(index, 8) + 8;
        }
        if (type == DataPrimitives.ADDRESS) {
            return BinaryWriter.align(index, 4) + 4;
        }
        if (type instanceof DataArray) {
            DataArray array = (DataArray)type;
            int next = BinaryWriter.getDataTypeOffset(array.getComponentType(), index);
            return index + (next - index) * array.getSize();
        }
        if (type instanceof DataStructure) {
            DataType[] components;
            DataStructure structure = (DataStructure)type;
            if (structure.getAlignment() > 0) {
                index = BinaryWriter.align(index, structure.getAlignment());
            }
            for (DataType component : components = structure.getComponents()) {
                index = BinaryWriter.getDataTypeOffset(component, index);
            }
            return index;
        }
        return index;
    }

    public static int align(int address, int alignment) {
        if (address == 0) {
            return 0;
        }
        return ((address - 1) / alignment + 1) * alignment;
    }

    private int getAlignment(DataType type) {
        if (type == DataPrimitives.BYTE) {
            return 1;
        }
        if (type == DataPrimitives.SHORT) {
            return 2;
        }
        if (type == DataPrimitives.INT) {
            return 4;
        }
        if (type == DataPrimitives.LONG) {
            return 8;
        }
        if (type == DataPrimitives.FLOAT) {
            return 4;
        }
        if (type == DataPrimitives.DOUBLE) {
            return 8;
        }
        if (type == DataPrimitives.ADDRESS) {
            return 4;
        }
        if (type instanceof DataArray) {
            return this.getAlignment(((DataArray)type).getComponentType());
        }
        if (type instanceof DataStructure) {
            DataStructure structure = (DataStructure)type;
            return Math.max(structure.getAlignment(), this.getAlignment(structure.getComponents()[0]));
        }
        return 1;
    }

    public byte[] getData() {
        byte[] result = new byte[this.address];
        int offset = 0;
        for (DataValue value : this.values) {
            offset = this.writeData(result, offset, value);
        }
        return Arrays.copyOf(result, offset);
    }

    private int writeData(byte[] result, int offset, DataValue value) {
        block4: {
            DataType type;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block5: {
                                        block3: {
                                            type = value.getType();
                                            if (type != DataPrimitives.BYTE) break block3;
                                            result[offset++] = value.getByte(0);
                                            break block4;
                                        }
                                        if (type != DataPrimitives.SHORT) break block5;
                                        offset = BinaryWriter.align(offset, 2);
                                        short v = value.getShort(0);
                                        result[offset++] = (byte)v;
                                        result[offset++] = (byte)(v >> 8);
                                        break block4;
                                    }
                                    if (type != DataPrimitives.INT) break block6;
                                    offset = this.writeInt(offset, result, value.getInt(0));
                                    break block4;
                                }
                                if (type != DataPrimitives.LONG) break block7;
                                offset = this.writeLong(offset, result, value.getLong(0));
                                break block4;
                            }
                            if (type != DataPrimitives.FLOAT) break block8;
                            int v = Float.floatToRawIntBits(value.getFloat(0));
                            offset = this.writeInt(offset, result, v);
                            break block4;
                        }
                        if (type != DataPrimitives.DOUBLE) break block9;
                        long v = Double.doubleToRawLongBits(value.getDouble(0));
                        offset = this.writeLong(offset, result, v);
                        break block4;
                    }
                    if (type != DataPrimitives.ADDRESS) break block10;
                    offset = this.writeInt(offset, result, (int)value.getAddress(0));
                    break block4;
                }
                if (!(type instanceof DataArray)) break block11;
                DataArray array = (DataArray)type;
                for (int i = 0; i < array.getSize(); ++i) {
                    offset = this.writeData(result, offset, value.getValue(i));
                }
                break block4;
            }
            if (!(type instanceof DataStructure)) break block4;
            DataStructure structure = (DataStructure)type;
            if (structure.getAlignment() > 0) {
                offset = BinaryWriter.align(offset, structure.getAlignment());
            }
            int componentCount = structure.getComponents().length;
            for (int i = 0; i < componentCount; ++i) {
                offset = this.writeData(result, offset, value.getValue(i));
            }
        }
        return offset;
    }

    private int writeInt(int offset, byte[] result, int v) {
        offset = BinaryWriter.align(offset, 4);
        result[offset++] = (byte)v;
        result[offset++] = (byte)(v >> 8);
        result[offset++] = (byte)(v >> 16);
        result[offset++] = (byte)(v >> 24);
        return offset;
    }

    private int writeLong(int offset, byte[] result, long v) {
        offset = BinaryWriter.align(offset, 8);
        result[offset++] = (byte)v;
        result[offset++] = (byte)(v >> 8);
        result[offset++] = (byte)(v >> 16);
        result[offset++] = (byte)(v >> 24);
        result[offset++] = (byte)(v >> 32);
        result[offset++] = (byte)(v >> 40);
        result[offset++] = (byte)(v >> 48);
        result[offset++] = (byte)(v >> 56);
        return offset;
    }
}

